<?php
namespace FrequentlyBuy\Metafields;
/**
 * 
 *
 * @package     FrequentlyBuy
 * @author      ThemeLooks
 * @copyright   2022 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

trait Border_Radius {

    public function border_radius_field( $args ) {

        $default = [
            'title' => '',
            'name' => '',
            'value' => '',
            'placeholder' => '',
            'condition'   => '',
            'is_pro'      => ''
        ];

        $args = wp_parse_args( $args, $default );
        $this->border_radius_markup( $args );
    }

    public function border_radius_markup( $args ) {

        $fieldName = $args['name'];
        $condition = !empty( $args['condition'] ) ? 'data-condition='.wp_json_encode( $args['condition'] ) : '';
        $value = $args['value'];
        

        $topLeft    = !empty( $value['top_left'] ) ? $value['top_left'] : '';
        $topRight  = !empty( $value['top_right'] ) ? $value['top_right'] : '';
        $bottomLeft = !empty( $value['bottom_left'] ) ? $value['bottom_left'] : '';
        $bottomRight   = !empty( $value['bottom_right'] ) ? $value['bottom_right'] : '';
        ?>
        <div class="frequentlybuy-label frequentlybuy-<?php echo esc_attr( $fieldName ); ?> frequentlybuy-field-wrp" <?php echo esc_attr( $condition ); ?>>
            <?php
            if( !empty( $args['is_pro'] ) ) {
                echo '<span class="pro-badge">PRO</span>';
            }
            ?>
            <h3><?php echo esc_html( $args['title'] ); ?></h3>
            <div class="dimension-input-group">
                <div class="dimension-field-wrap">
                <span><?php esc_html_e( 'Top Left', 'frequentlybuy' ); ?></span>
                <input type="number" class="dimension-field" name="<?php echo esc_attr( $fieldName.'[top_left]' ); ?>" value="<?php echo esc_html( $topLeft ); ?>"/>
                </div>
                <div class="dimension-field-wrap">
                <span><?php esc_html_e( 'Top Right', 'frequentlybuy' ); ?></span>
                <input type="number" class="dimension-field" name="<?php echo esc_attr( $fieldName.'[top_right]' ); ?>" value="<?php echo esc_html( $topRight ); ?>"/>
                </div>
                <div class="dimension-field-wrap">
                <span><?php esc_html_e( 'Bottom Left', 'frequentlybuy' ); ?></span>
                <input type="number" class="dimension-field" name="<?php echo esc_attr( $fieldName.'[bottom_left]' ); ?>" value="<?php echo esc_html( $bottomLeft ); ?>"/>
                </div>
                <div class="dimension-field-wrap">
                <span><?php esc_html_e( 'Bottom Right', 'frequentlybuy' ); ?></span>
                <input type="number" class="dimension-field" name="<?php echo esc_attr( $fieldName.'[bottom_right]' ); ?>" value="<?php echo esc_html( $bottomRight ); ?>"/>
                </div>
            </div>
        </div>
        <?php
    }
}