<?php
namespace FrequentlyBuy\Metafields;
/**
 * 
 *
 * @package     FrequentlyBuy
 * @author      ThemeLooks
 * @copyright   2022 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

trait Border {

    public function border_field( $args ) {

        $default = [
            'title' => '',
            'name' => '',
            'condition'   => '',
            'value' => '',
            'is_pro' => ''
        ];

        $args = wp_parse_args( $args, $default );
        $this->border_markup( $args );
    }

    public function border_markup( $args ) {

        $name = $args['name'];

        $value = $args['value'];

        $fieldName = esc_attr( $name );
        $condition = !empty( $args['condition'] ) ? 'data-condition='.wp_json_encode( $args['condition'] ) : '';

        $width    = !empty( $value['width'] ) ? $value['width'] : '';
        $style    = !empty( $value['style'] ) ? $value['style'] : '';
        $color    = !empty( $value['color'] ) ? $value['color'] : '';

        $options = [
            'none'   => esc_html__( 'None', 'frequentlybuy' ),
            'solid'  => esc_html__( 'Solid', 'frequentlybuy' ),
            'dotted' => esc_html__( 'Dotted', 'frequentlybuy' ),
            'dashed' => esc_html__( 'Dashed', 'frequentlybuy' ),
            'double' => esc_html__( 'Double', 'frequentlybuy' ),
            'groove' => esc_html__( 'Groove', 'frequentlybuy' )
        ];
        ?>
        <div class="frequentlybuy-label frequentlybuy-<?php echo esc_attr( $fieldName ); ?> frequentlybuy-field-wrp" <?php echo esc_attr( $condition ); ?>>
            <?php
            if( !empty( $args['is_pro'] ) ) {
                echo '<span class="pro-badge">PRO</span>';
            }
            ?>
            <h3><?php echo esc_html( $args['title'] ); ?></h3>
            <div class="border-input-group">
                <div class="border-field-wrap">
                    <input type="number" class="border-number-field" placeholder="px" name="<?php echo esc_attr( $fieldName ); ?>[width]" value="<?php echo esc_html( $width ); ?>"/>
                </div>

                <div class="border-field-wrap">
                    <select name="<?php echo esc_attr( $fieldName ); ?>[style]">
                        <?php 
                        if( !empty( $options ) ) {
                            foreach( $options as $key => $option ) {
                                echo '<option value="'.esc_attr( $key ).'" '.selected( $style, $key, false ).'>'.esc_html( $option ).'</option>';
                            }
                        }
                        ?>
                    </select>
                </div>

                <div class="border-field-wrap">
                    <input type="text" id="bg_color" data-alpha-enabled="true" data-alpha-color-type="rgb" class="color-field" value="<?php echo esc_html( $color ); ?>" name="<?php echo esc_attr( $fieldName ); ?>[color]" />
                </div>

            </div>
        </div>
        <?php
    }
}