<?php
namespace FrequentlyBuy\Inc;

/**
 * 
 *
 * @package     FrequentlyBuy
 * @author      ThemeLooks
 * @copyright   2026 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

if( !defined( 'WPINC' ) ) {
    die;
}

class WooHook {

    function __construct() {
        add_action( 'woocommerce_before_add_to_cart_button', [ $this, 'add_custom_content_after_cart_button' ] );
        //
        add_action( 'woocommerce_add_to_cart', [ $this, 'frequentlybuy_add_products' ], 10, 6 );
    }
    
    public function add_custom_content_after_cart_button() {
       require_once FREQUENTLYBUY_DIR_PATH.'/view/frequently-products.php';
       echo '<input type="hidden" name="frequentlybuy_cart_data" class="frequentlybuy-cart-data" /> ';

       $product = wc_get_product( get_the_ID() );
       
       echo '<input type="hidden" name="frequentlybuy_product_price" value="'.absint( $product->get_price() ).'" /> ';
    }

    public function frequentlybuy_add_products( $cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data ) {

        static $processing = false;

        if ( $processing ) {
            return;
        }

        if( !empty( $_REQUEST['frequentlybuy_cart_data'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended

            $processing = true;
            
            $frequentlyBuyData = json_decode( wp_unslash( $_REQUEST['frequentlybuy_cart_data'] ), true ); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
            
            if ( ! is_array( $frequentlyBuyData ) ) {
                $processing = false;
                return;
            }

            foreach ( $frequentlyBuyData as $extra_product ) {

                $extra_product_id = absint( $extra_product['product_id'] );
                $variationID = !empty( $extra_product['variation_id'] ) ? absint( $extra_product['variation_id'] ) : '';
                $extraVariation = !empty( $extra_product['variation'] ) ? $extra_product['variation'] : [];              
                //
                $cart_id = WC()->cart->generate_cart_id( absint( $extra_product_id ), absint( $variationID ), array_map( 'sanitize_text_field', $extraVariation ) );

                $qty = wc_stock_amount( absint( $extra_product['qty'] ?? 1 ) );

                if ( ! WC()->cart->find_product_in_cart( $cart_id ) ) {
                    $getCartID = WC()->cart->add_to_cart( absint( $extra_product_id ), $qty , absint( $variationID ), array_map( 'sanitize_text_field', $extraVariation ) );
                    WC()->cart->set_quantity( $getCartID, $qty );
                }
            }
            
            $processing = false;

        }

    }




}