<?php
namespace FrequentlyBuy\Inc;

/**
 * 
 *
 * @package     FrequentlyBuy
 * @author      ThemeLooks
 * @copyright   2026 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

if( !defined( 'WPINC' ) ) {
    die;
}


class Meta_Base
{

    public static $getFields;

    function __construct()
    {
        add_action('add_meta_boxes', [__CLASS__, 'register_meta_boxes']);
        add_action('save_post', [__CLASS__, 'save_meta_data'], 10, 2 );

        self::$getFields = new \FrequentlyBuy\Metafields\Fields_Maping();

        self::$getFields->scripts();
    }

    /**
     * Register meta box
     * 
     */
    public static function register_meta_boxes()
    {
        add_meta_box('frequentlybuy-meta', esc_html__('Set Options', 'frequentlybuy'), [__CLASS__, 'display_callback'], 'frequentlybuy');
    }

    /**
     * Meta box display callback.
     *
     * @param WP_Post $post Current post object.
     */
    public static function display_callback($post)
    {

        $postID = $post->ID;

        $prefix = '_frequentlybuy_';

        $active = get_post_meta( absint( $postID ) , $prefix.'active_frequentlybuy', true);
        $position = get_post_meta( absint( $postID ) , $prefix.'display_position', true);
        $type = get_post_meta( absint( $postID ) , $prefix.'display_type', true);
        $individualProduct = get_post_meta( absint( $postID ) , $prefix.'individual_product', true);
        $productAddons = get_post_meta( absint( $postID ) , $prefix.'product_addons', true);

        // Fields 
        $getFields = self::$getFields;

        ?>
        <div class="frequentlybuy-meta-content-box">

            <div class="frequentlybuy-meta-tabs">
                <ul>
                    <li id="settings_tab" class="frequentlybuy-tab frequentlybuy-active">
                        <span><img src="<?php echo esc_url(FREQUENTLYBUY_DIR_URL . 'meta-fields/assets/icon/settings.svg'); ?>" /></span>
                        <?php esc_html_e('Display Settings', 'frequentlybuy'); ?>
                    </li>
                    <li id="settings_style" class="frequentlybuy-tab"><span><img src="<?php echo esc_url(FREQUENTLYBUY_DIR_URL . '/meta-fields/assets/icon/style.svg'); ?>" /></span>
                        <?php esc_html_e('Addons Set', 'frequentlybuy'); ?> </li>
                </ul>
            </div>

            <div class="frequentlybuy-meta-tabs-content-area">

                <div data-tabref="settings_tab" class="frequentlybuy-meta-tab-content frequentlybuy-active">
                    <?php
                    $getFields->switcher_field(
                        [
                            'title' => esc_html__('Active', 'frequentlybuy'),
                            'name' => 'active_frequentlybuy',
                            'value' => $active
                        ]
                    );

                    $getFields->select_field(
                        [
                            'title' => esc_html__('Display Position', 'frequentlybuy'),
                            'name' => 'display_position',
                            'value' => $position,
                            'options' => apply_filters( 'frequentlybuy_display_position', ['before_button' => esc_html__('Before Add to cart button', 'frequentlybuy'),'after_button' => esc_html__('After Add to cart button ( Pro )', 'frequentlybuy')] )
                        ]
                    );

                    $displayType = [
                        'individual' => esc_html__('Individual Product', 'frequentlybuy'),
                        'all_pro' => esc_html__('All Product ( Pro )', 'frequentlybuy'),
                        'category_pro' => esc_html__('Category Wise (Pro)', 'frequentlybuy')
                    ];

                    $getFields->select_field(
                        [
                            'title' => esc_html__('Display Type', 'frequentlybuy'),
                            'name' => 'display_type',
                            'value' => $type,
                            'options' => apply_filters( 'frequentlybuy_display_type', $displayType )
                        ]
                    );

                    $getFields->multiple_select_field(
                        [
                            'title' => esc_html__('Display Individual Product', 'frequentlybuy'),
                            'name' => 'individual_product',
                            'value' => $individualProduct,
                            'maxselect' => apply_filters( 'frequentlybuy_individual_product_maxselect', '5'),
                            'options' => \FrequentlyBuy\Inc\Helper::get_products()
                        ]
                    );

                    do_action( 'frequentlybuy_display_settings_meta_fields_after', $postID, $getFields );
                    
                    ?>
                </div>
                <div data-tabref="settings_style" class="frequentlybuy-meta-tab-content frequentlybuy-hide">
                    <?php
                    $getFields->multiple_select_field(
                        [
                            'title' => esc_html__('Set Products as Add-ons', 'frequentlybuy'),
                            'name' => 'product_addons',
                            'value' => $productAddons,
                            'maxselect' => apply_filters( 'frequentlybuy_product_addons_maxselect', '5'),
                            'options' => \FrequentlyBuy\Inc\Helper::get_products()
                        ]
                    );
                    ?>
                </div>

            </div>
            <?php wp_nonce_field(
                'frequentlybuy_save_post',
                'frequentlybuy_nonce'
            ); ?>
        </div>
        <?php


    }

    public static function save_meta_data($post_id, $post)
    {

        // 1. Check nonce existence
        if (
            ! isset( $_POST['frequentlybuy_nonce'] ) ||
            ! wp_verify_nonce(
                sanitize_text_field( wp_unslash( $_POST['frequentlybuy_nonce'] ) ),
                'frequentlybuy_save_post'
            )
        ) {
            return;
        }

        // 2. Prevent autosave
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        }

        // 3. Check user capability
        if ( ! current_user_can( 'edit_post', $post_id ) ) {
            return;
        }

        // 4. (Optional) Restrict post type
        if ( 'frequentlybuy' !== $post->post_type ) {
            return;
        }
        
        //
        $prefix = '_frequentlybuy_';

        update_post_meta( absint( $post_id ) , $prefix.'active_frequentlybuy', sanitize_text_field( wp_unslash( $_POST['active_frequentlybuy'] ?? '' ) ) );

        update_post_meta( absint( $post_id ), $prefix.'display_position', sanitize_text_field( wp_unslash( $_POST['display_position'] ?? '' ) ));

        update_post_meta( absint( $post_id ), $prefix.'display_type', sanitize_text_field( wp_unslash( $_POST['display_type'] ?? '' ) ));

        update_post_meta( absint( $post_id ) , $prefix.'individual_product', array_map( 'sanitize_text_field', wp_unslash( $_POST['individual_product'] ?? [] ) ) );

        update_post_meta( absint( $post_id ) , $prefix.'product_addons', array_map( 'sanitize_text_field', wp_unslash( $_POST['product_addons'] ?? [] ) ) );
        
        do_action( 'frequentlybuy_meta_save', $post_id, $prefix, $_POST );

    }



}

new Meta_Base();