<?php
namespace FrequentlyBuy\Inc;

/**
 * 
 *
 * @package     FrequentlyBuy
 * @author      ThemeLooks
 * @copyright   2026 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

if( !defined( 'WPINC' ) ) {
    die;
}

class Hook {

    function __construct() {
        
        add_action('init', [ $this, 'register_post_type' ] );
        add_action('wp_enqueue_scripts', [ $this, 'enqueue_scripts' ] );
        add_action( 'load-post-new.php', [ $this, 'prevent_new_post' ]  );
        add_action( 'wp_insert_post_data', [ $this, 'prevent_saving_frequently_data' ] , 10, 2 );
        add_filter( 'frequentlybuy_addons_list', [ $this, 'addons_list' ], 10, 2 );
        add_action( 'frequentlybuy_display_settings_meta_fields_after', [ $this, 'display_settings_meta_fields_after' ] , 10, 2 );
        add_action( 'admin_notices', [ $this, 'frequentlybuy_admin_pro_notices' ] );

    }
        
    public function register_post_type() {

        $labels = array(
            'name'               => esc_html__('Add Frequently', 'frequentlybuy'),
            'singular_name'      => esc_html__('Add Frequently', 'frequentlybuy'),
            'menu_name'          => esc_html__('Add Frequently', 'frequentlybuy'),
            'name_admin_bar'     => esc_html__('Add Frequently', 'frequentlybuy'),
            'add_new'            => esc_html__('Add New', 'frequentlybuy'),
            'add_new_item'       => esc_html__('Add New Frequently', 'frequentlybuy'),
            'new_item'           => esc_html__('New Frequently', 'frequentlybuy'),
            'edit_item'          => esc_html__('Edit Frequently', 'frequentlybuy'),
            'view_item'          => esc_html__('View Frequently', 'frequentlybuy'),
            'all_items'          => esc_html__('Add Frequently', 'frequentlybuy'),
            'search_items'       => esc_html__('Search Frequently', 'frequentlybuy'),
            'not_found'          => esc_html__('No Frequently found.', 'frequentlybuy'),
            'not_found_in_trash' => esc_html__('No Frequently found in Trash.', 'frequentlybuy'),
        );

        $args = array(
            'labels'             => $labels,
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => 'frequentlybuy-admin-page',
            'query_var'          => true,
            'rewrite'            => array('slug' => 'add-frequently'),
            'capability_type'    => 'post',
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => 20,
            'menu_icon'          => 'dashicons-editor-help',
            'supports'           => array('title'),
            'show_in_rest'       => false, // Gutenberg support
        );

        register_post_type('frequentlybuy', $args);
    }

    public function enqueue_scripts() {

        wp_enqueue_style( 'frequentlybuy-main', \FREQUENTLYBUY_DIR_URL.'/assets/css/main.css', array(), \FREQUENTLYBUY_VERSION, false  );

         wp_enqueue_script( 'wc-add-to-cart-variation' );

        wp_enqueue_script( 'frequentlybuy-main', \FREQUENTLYBUY_DIR_URL.'/assets/js/main.js', array( 'jquery', 'wc-add-to-cart','wc-add-to-cart-variation', 'wc-add-to-cart-variation' ), \FREQUENTLYBUY_VERSION, true );

        wp_localize_script( 'frequentlybuy-main', 'frequentlybuyMainScript', array(
            'ajax_url' => admin_url( 'admin-ajax.php' ),
            'wc_currency' => get_woocommerce_currency_symbol()
        ));

    }

    public function prevent_new_post() {

        if ( Helper::is_pro_active() ) {
            return;
        }

        if ( get_current_screen()->post_type !== 'frequentlybuy' ) {
            return;
        }

        if ( Helper::get_frequently_count() >= 1 ) {
            wp_die(
                esc_html__( 'Free version allows only one Frequently Buy item. Upgrade to Pro for unlimited.', 'frequentlybuy' ),
                esc_html__( 'Upgrade Required', 'frequentlybuy' ),
                [ 'back_link' => true ]
            );
        }

    }

    public function prevent_saving_frequently_data( $data, $postarr ) {

        if ( $data['post_type'] !== 'frequentlybuy' ) {
            return $data;
        }

        if ( Helper::is_pro_active() ) {
            return $data;
        }

        // Only block new posts
        if ( empty( $postarr['ID'] ) && Helper::get_frequently_count() >= 1 ) {
            wp_die(
                esc_html__( 'You can only create one Frequently Buy item in the free version.', 'frequentlybuy' )
            );
        }

        return $data;
    }

    public function addons_list( $productID, $frequentlybuy_getAddons ) {

        if( !empty( $frequentlybuy_getAddons ) ) {

            foreach( $frequentlybuy_getAddons as $addon ) {

                $displayType = get_post_meta( absint( $addon->ID ), '_frequentlybuy_display_type', true );

                if( $displayType == 'individual' ) {
                    // Individual product based
                    $individualProductIDS = get_post_meta( absint( $addon->ID ), '_frequentlybuy_individual_product', true );
                    if( !empty( $individualProductIDS ) && in_array( $productID, $individualProductIDS ) ) {
                        \FrequentlyBuy\Inc\Helper::get_addons_html( absint( $addon->ID ) );
                    }
                }

            }

        }

        
    }

    public function display_settings_meta_fields_after( $postID, $getFields ) {

        if( Helper::is_pro_active() ) {
            return;
        }

        $getFields->multiple_select_field(
            [
                'title' => esc_html__('Display Product Category', 'frequentlybuy'),
                'name' => '',
                'is_pro' => true
            ]
        );
        $getFields->select_field(
            [
                'title' => esc_html__('Select Style', 'frequentlybuy'),
                'name' => '',
                'is_pro' => true
            ]
        );
        $getFields->switcher_field(
            [
                'title' => esc_html__('Hide Quantity', 'frequentlybuy'),
                'name' => '',
                'is_pro' => true
            ]
        );

        $getFields->radio_field(
            [
                'title' => esc_html__('Option Selection Mode', 'frequentlybuy'),
                'name' => '',
                'options' => [ 'single' => 'Single Choice', 'multiple' => 'Multiple Choice' ],
                'is_pro' => true
            ]
        );

    }

    public function frequentlybuy_admin_pro_notices() {

        if ( Helper::is_pro_active() ) {
            return;
        }

        $screen = get_current_screen();

        if ( $screen->post_type === 'frequentlybuy' && Helper::get_frequently_count() >= 1 ) {
            echo '<div class="notice notice-warning">
                <p>
                    <strong>Frequently Buy:</strong>
                    Free version allows only one item.
                    <a href="https://themelooks.com/" target="_blank">Upgrade to Pro</a> for unlimited.
                </p>
            </div>';
        }
    }



}