<?php
namespace FrequentlyBuy\Inc;

/**
 * 
 *
 * @package     FrequentlyBuy
 * @author      ThemeLooks
 * @copyright   2026 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

if( !defined( 'WPINC' ) ) {
    die;
}

class Helper {


    public static function get_products() {
        $args = array(
            'limit' => '-1',
        );
        $products = wc_get_products( $args );

        $getProducts = [];

        if( !empty( $products ) ) {
            foreach( $products as $product ) {
                $getProducts[$product->get_id()] = $product->get_name();
            }
        }

        return $getProducts;

    }

    public static function get_product_categories() {

        $product_categories = get_terms( array(
            'taxonomy'   => 'product_cat',
            'hide_empty' => true,
        ) );

        $getCategories = [];

        if( !empty( $product_categories ) ) {
            foreach( $product_categories as $category ) {
                $getCategories[$category->term_id] = $category->name;
            }
        }

        return $getCategories;

    }

    public static function get_addons_html( $id ) {

        $title = get_the_title( absint( $id ) );
        $addons = get_post_meta( absint( $id ), '_frequentlybuy_product_addons', true );
        $style = get_post_meta( absint( $id ) , '_frequentlybuy_frequently_style', true);
        
        //
        $checkType = apply_filters( 'frequentlybuy_item_check_type', 'checkbox', absint( $id ) );
        $checkBoxTypeName = apply_filters( 'frequentlybuy_item_title', sanitize_title( $title ).'[]', sanitize_title( $title ), absint( $id ) );
        $itemStyle = !empty( $style ) ? $style : '1';

        ?>
        <div class="frequently-product-group">
            <?php
            if( !empty( $title ) ) {
                echo '<h3>'.esc_html( $title ).'</h3>';
            }
            ?>
            <!---  frequently-items-style-2, frequently-items-style-3 frequently-items-style-4 ---->
            <div class="frequently-product-items frequently-items-style-<?php echo esc_attr( $itemStyle ); ?>">
                <?php
                if( !empty( $addons ) ) {
                    foreach( $addons as $addon ) {
                        $product = wc_get_product( $addon );
                        $is_variable = $product->is_type( 'variable' );
                        ?>
                        <label class="frequently-product-item" data-price="<?php echo esc_attr( $product->get_price() ); ?>" for="item_<?php echo esc_attr( $product->get_id() ); ?>">
                            <!-- <div class="frequently-product-item-inner"> -->
                            <?php
                            if( $itemStyle == '4' ):
                            ?>
                            <div class="frequently-product-item-tool-tips">
                                <span class="frequently-tool-tips-title"><?php echo esc_html( $product->get_name() ); ?></span>
                                <div class="price"><?php echo wp_kses_post( $product->get_price_html() ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></div>
                            </div>
                            <?php endif; ?>

                            <div class="product-item-part-left">
                                <input class="frequently-addon-check" <?php //echo esc_attr( $product->get_type() == 'variable' ? 'disabled' : '' ); ?> id="item_<?php echo esc_attr( $product->get_id() ); ?>" data-product-type="<?php echo esc_attr( $product->get_type() ); ?>" value="<?php echo esc_attr( $product->get_id() ); ?>" name="<?php echo esc_attr( $checkBoxTypeName ); ?>" type="<?php echo esc_attr( $checkType ); ?>" />
                                <div class="product-item-part-left-inner">
                                
                                <?php echo wp_kses_post( $product->get_image() ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                                
                                <?php if( $itemStyle != '4' ): ?>
                                <a href="<?php echo esc_url( get_the_permalink( absint( $product->get_id() ) ) ); ?>"><h4><?php echo esc_html( $product->get_name() ); ?></h4></a>
                                <?php endif; ?>
                                </div>
                                <?php
                                if( $is_variable ){
                                    echo '<span class="frequently-product-item-variation">'.esc_html__( 'Select Variation', 'frequentlybuy' ).'</span>';
                                }
                                ?>
                            </div>

                            <?php if( $itemStyle != '4' ): ?>
                            <div class="product-item-part-right">
                                <div class="price"><?php echo wp_kses_post( $product->get_price_html() ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></div>
                                <?php do_action( 'frequentlybuy_product_item_qty', $id ); ?>
                            </div>
                            <?php
                            endif; 
                            //echo '</div>';
                            //
                            if( $is_variable ){
                            $available_variations = $product->get_available_variations();
                            $attributes           = $product->get_variation_attributes();
                            ?>
                            <div class="frequently_variations_form" data-product_id="<?php echo absint( $product->get_id() ); ?>" data-product_variations="<?php echo esc_attr( wp_json_encode( $available_variations ) ); ?>">
                                <span class="variations-form-close variations-form-close-btn">X</span>
                                <?php foreach ( $attributes as $attribute_name => $options ) : ?>
                                    <div class="frequently-variation" data-attribute="<?php echo esc_html( $product->get_attribute( $attribute_name ) ); ?>">
                                        <label><?php echo esc_html( wc_attribute_label( $attribute_name ) ); ?></label>
                                        <?php
                                        wc_dropdown_variation_attribute_options( array(
                                            'options'   => $options,
                                            'attribute' => $attribute_name,
                                            'product'   => $product,
                                            'class'   => 'frequently-variation-attribute',
                                        ) );
                                        ?>
                                    </div>
                                <?php endforeach; ?>

                                <input type="hidden" name="frequently_item_variation_id" class="frequently_item_variation_id" value="0" />
                                    <span class="variations-filter-clear">Clear Filter</span>
                                    <span class="variation-apply-btn variations-form-close"><?php esc_html_e( 'Apply', 'frequentlybuy' ); ?></span>
                                </div>

                            <?php
                            }
                            ?>
                        </label>

                        <?php

                    }
                }
                ?>

            </div>
            
        </div>
        <?php
    }

    public static function is_pro_active() {
        return defined( 'FREQUENTLYBUY_PRO' ) && FREQUENTLYBUY_PRO;
    }

    public static function get_frequently_count() {
        $count = wp_count_posts( 'frequentlybuy' );
        return isset( $count->publish ) ? (int) $count->publish : 0;
    }


}