<?php
/*
Plugin Name:  FrequentlyBuy - Bought Together Upsells for WooCommerce
Plugin URI:   https://themelooks.com/frequentlybuy
Description:  FrequentlyBuy allows you to create frequently bought together product bundles in WooCommerce to increase sales and improve customer experience.
Version:      1.0.0
Author:       Themelooks
Author URI:   https://themelooks.com/
Requires Plugins: woocommerce
License:      GPL2
License URI:  https://www.gnu.org/licenses/gpl-2.0.html
Text Domain:  frequentlybuy
Domain Path:  /languages
*/


// Block Direct access
if( !defined( 'ABSPATH' ) ){ die( 'You should not access this file directly!.' ); }

// Define Plugin Version.
if( !defined( 'FREQUENTLYBUY_VERSION' ) )
	define( 'FREQUENTLYBUY_VERSION', '1.0.0' );

// Define Constants for direct access alert message.
if( !defined( 'FREQUENTLYBUY_ALERT_MSG' ) )
	define( 'FREQUENTLYBUY_ALERT_MSG', 'You should not access this file directly.!' );

// Define constants for plugin directory path.
if( !defined( 'FREQUENTLYBUY_DIR_PATH' ) )
	define( 'FREQUENTLYBUY_DIR_PATH', plugin_dir_path( __FILE__ ) );

// Define constants for plugin dirname.
if( !defined( 'FREQUENTLYBUY_DIR_NAME' ) )
	define( 'FREQUENTLYBUY_DIR_NAME', dirname( __FILE__ ) );

// Define constants for plugin directory path.
if( !defined( 'FREQUENTLYBUY_DIR_URL' ) )
	define( 'FREQUENTLYBUY_DIR_URL', plugin_dir_url( __FILE__ ) );

// Define constants for plugin basenam.
if( !defined( 'FREQUENTLYBUY_BASENAME' ) )
	define( 'FREQUENTLYBUY_BASENAME', plugin_basename( __FILE__ ) );

require_once FREQUENTLYBUY_DIR_PATH.'vendor/autoload.php';

final class FrequentlyBuy {

	private static $instance = null;

	private function __construct() {
		
		$this->init();
	}
	
	public static function getInstance() {
		
		if( self::$instance == null ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	public function init() {
		
		//
		add_filter( 'wp_enqueue_scripts', [ $this, 'enqueue_scripts' ] );

        //
        new FrequentlyBuy\Admin\Admin();
        new FrequentlyBuy\Inc\Hook();
        new FrequentlyBuy\Inc\WooHook();

	}

	public function enqueue_scripts() {
		wp_enqueue_style( 'frequentlybuy-main', FREQUENTLYBUY_DIR_URL.'assets/css/main.css', [], FREQUENTLYBUY_VERSION );
	}  

}

FrequentlyBuy::getInstance();
