( function($) {
    "use strict";

    $('.frequently-addon-check').on('change', function (e) {

        e.stopPropagation();
        
        var frequentlyBuy = [];

        if ( $(this).is(':checked') ) {
            $(this).closest('.frequently-product-item').find('.frequently_variations_form').show();
        } else {
            $(this).closest('.frequently-product-item').find('.frequently_variations_form').hide();
        }
        //
        $('.frequently-addon-check:checked').each(function ( i, item ) {

            let $variationID = '';

            if ( $(item).data('product-type') == 'variable' ) {
                $variationID = $(item).closest('.frequently-product-item').find('.frequently_item_variation_id').val();
            }

            let $qty = $(item).closest('.frequently-product-item').find('.item-qty').val();

            var $itemData = { product_id: $(this).val(), qty: $qty ? $qty : '1', variation_id: $variationID };
            frequentlyBuy.push($itemData);
        });
        //
        $('.frequentlybuy-cart-data').val(JSON.stringify(frequentlyBuy));
        
    })
    
    // Open frequently item variation popup
    $('.frequently-product-item-variation').on('click', function (e) {

        e.preventDefault();
        e.stopPropagation();
        
        $(this).closest('.frequently-product-item').find('.frequently_variations_form').show();

    })
    
    // Close frequently item variation popup
    $('.variations-form-close').on('click', function (e) {
        e.preventDefault();
        $(this).closest('.frequently_variations_form').hide();
    })
    
    //
    $('.frequently-variation-attribute').on('change', function () {
        
        let $this = $(this),
            $variationsWrap = $this.closest('.frequently_variations_form');
        
        let $is_empty = true;

        let selectedAttrs = {};

        $variationsWrap.find('select').each(function ( i, item ) {
                        
            if ( $(item).val() == '' ) {
                $is_empty = false;
            }

            if ($(item).val() != '') {
                let $n = $(item).attr('name');
                let $v = $(item).val();
                selectedAttrs[$n] = $v;
            }
            
        });

        let $t = $variationsWrap.data('product_variations');

        //
        if ($is_empty) {

            let getVariations = [];
            $t.forEach(function (item, i) {

                if (objectToKey(item.attributes) === objectToKey(selectedAttrs)) {

                    // item.display_price
                    $this.closest('.frequently-product-item').data('price', item.display_price);
                    
                    $($variationsWrap).find('.frequently_item_variation_id').val(item.variation_id);
                    getVariations.push(true);
                } else {
                    getVariations.push(false);
                }

            })
            
            //
            if ( !getVariations.includes(true) ) {
                $($variationsWrap).find('.frequently_item_variation_id').val('');
            }
            
            //
            if (getVariations.includes(true)) {
                
                var frequentlyBuy = [];

                $('.frequently-addon-check:checked').each(function () {

                    let $variationID = '';

                    if ( $(this).data('product-type') == 'variable' ) {
                        $variationID = $(this).closest('.frequently-product-item').find('.frequently_item_variation_id').val();
                    }
                    let $qty = $(this).closest('.frequently-product-item').find('.item-qty').val();

                    var $itemData = { product_id: $(this).val(), qty: $qty ? $qty : '1', variation_id: $variationID };
                    frequentlyBuy.push($itemData);
                });
                //
                $('.frequentlybuy-cart-data').val(JSON.stringify(frequentlyBuy));

                
            }

        }
        

    })
    
    function objectToKey(obj) {
        return Object.keys(obj)
            .sort()
            .map(k => `${k}:${obj[k]}`)
            .join('|');
    }

    $('.single_add_to_cart_button').append('<span class="total-price-show"></span>');
    let $totalPrice = Number($('[name="frequentlybuy_product_price"]').val() || 0);
    /* Increase */
    $(".qty-increase").on("click", function (e) {
        e.preventDefault();
        e.stopPropagation();

        let $qty = $(this).closest('.frequently-product-item-qty').find('.item-qty'),
            currentVal = parseInt($qty.val());
        
        if (!isNaN(currentVal)) {
            let q = currentVal + 1;
            $qty.val(q);


             //
            var frequentlyBuy = [];
            let $addonsPrice = 0,
                $getTotalPriceOnQty;

            $('.frequently-addon-check:checked').each(function (i, item) {

                let $variationID = '';

                if ( $(this).data('product-type') == 'variable' ) {
                    $variationID = $(this).closest('.frequently-product-item').find('.frequently_item_variation_id').val();
                }
                let $qty = $(this).closest('.frequently-product-item').find('.item-qty').val();

                var $itemData = { product_id: $(this).val(), qty: $qty ? $qty : '1', variation_id: $variationID };
                frequentlyBuy.push($itemData);

                // Price Calculation
                let $productItem = $(item).closest('.frequently-product-item');

                $addonsPrice += Number($productItem.data('price')) * Number($qty);
                $getTotalPriceOnQty = $totalPrice + $addonsPrice;


            });
            //
            $('.frequentlybuy-cart-data').val(JSON.stringify(frequentlyBuy));
            $('.total-price-show').text( ' '+frequentlybuyMainScript.wc_currency+$getTotalPriceOnQty  );
            
        }

    });

    /* Decrease */
    $(".qty-decrease").on("click", function (e) {
        e.preventDefault();                
        e.stopPropagation();                

        let $qty = $(this).closest('.frequently-product-item-qty').find('.item-qty');
        let currentVal = parseInt($qty.val());
        if (!isNaN(currentVal) && currentVal > 1) {
            let q = currentVal - 1;
            $qty.val(q);


            //
            var frequentlyBuy = [];
            let $addonsPrice = 0,
                $getTotalPriceOnQty;

            $('.frequently-addon-check:checked').each(function (i, item) {

                let $variationID = '';

                if ( $(this).data('product-type') == 'variable' ) {
                    $variationID = $(this).closest('.frequently-product-item').find('.frequently_item_variation_id').val();
                }
                let $qty = $(this).closest('.frequently-product-item').find('.item-qty').val();

                var $itemData = { product_id: $(this).val(), qty: $qty ? $qty : '1', variation_id: $variationID };
                frequentlyBuy.push($itemData);

                // Price Calculation
                let $productItem = $(item).closest('.frequently-product-item');

                $addonsPrice += Number($productItem.data('price')) * Number($qty);
                $getTotalPriceOnQty = $totalPrice + $addonsPrice;
                
            });
            //
            $('.frequentlybuy-cart-data').val(JSON.stringify(frequentlyBuy));
            $('.total-price-show').text( ' '+frequentlybuyMainScript.wc_currency+$getTotalPriceOnQty  );

            
        }
    });

    /******* frequentlybuy total price *******/

    let $getTotalPrice;
    
    $('.frequently-product-item').on('click', function (e) {

        e.stopPropagation();

        let $addonsPrice = 0;

        $('body .frequently-addon-check:checked').each(function (i, item) {

            let $productItem = $(item).closest('.frequently-product-item'),
                    $qty = $productItem.find('.item-qty').val() ?? 1;

                $addonsPrice += Number($productItem.data('price')) * Number($qty);
        })

        $getTotalPrice = $totalPrice + $addonsPrice;

        $('.total-price-show').text( ' '+frequentlybuyMainScript.wc_currency+$getTotalPrice  );
        
    })
    

    $('.frequently_variations_form').each(function () {

        const $form = $(this);
        const variations = $form.data('product_variations');
        const $selects = $form.find('.frequently-variation-attribute');

        function getChosenAttributes() {
            let data = {};
            $selects.each(function () {
                const name = $(this).data('attribute_name') || $(this).attr('name');
                const val  = $(this).val();
                if (val) {
                    data[name] = val;
                }
            });
            return data;
        }

        function updateOptions(changedSelect = null) {

            $selects.each(function (index) {

                const $currentSelect = $(this);

                //  First select always show full list
                if (index === 0) {
                    $currentSelect.find('option').show().prop('disabled', false);
                    return;
                }

                const currentAttr = $currentSelect.data('attribute_name') || $currentSelect.attr('name');

                let chosen = getChosenAttributes();
                delete chosen[currentAttr];

                const matches = variations.filter(variation => {
                    return Object.entries(chosen).every(([key, val]) => {
                        return variation.attributes[key] === val;
                    });
                });

                let allowed = new Set();
                let allowAll = false;

                matches.forEach(v => {
                    const attrVal = v.attributes[currentAttr];

                    if (attrVal === '' || typeof attrVal === 'undefined') {
                        //allowAll = true;
                    } else {
                        allowed.add(attrVal);
                    }
                });

                $currentSelect.find('option').each(function () {
                    const val = $(this).val();
                    if (!val) return;

                    if (allowAll || allowed.has(val)) {
                        $(this).show().prop('disabled', false);
                    } else {
                        $(this).hide().prop('disabled', true);
                       
                    }
                });

            });

        }

        updateOptions();

        $selects.on('change', function () {
            updateOptions($(this));
        });

    });

    /************/

    $('.variations-filter-clear').on('click', function (e) {

        e.preventDefault();
        e.stopPropagation();

        let $select = $(this).closest('.frequently_variations_form').find('select');

        $select.each(function (i, item) {
            $(item).val('');
            $(item).find('option').show().prop('disabled', false);
        });
        
    })
    $('.frequently_variations_form').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();
    } )

    // variation apply button event
    $('.variation-apply-btn').on('click', function () {
        
        let $selectBox = $(this).closest('.frequently_variations_form').find('select'),
            $isEmpty = false;

        $selectBox.each(function (i, item) {

            if ( !$(item).val() ) {
                $isEmpty = true;
            }

        })
        
        if ( $isEmpty ) {
            $(this).closest('.frequently-product-item').find('.frequently-addon-check').prop('checked', false)
        }

        if (!$isEmpty) {
            
            let $addonsPrice = 0;
            let $t = $(document).find('.frequently-addon-check:checked');
            $t.each(function (i, item) {
                
                let $productItem = $(item).closest('.frequently-product-item'),
                    $qty = $productItem.find('.item-qty').val();

                $addonsPrice += Number($productItem.data('price')) * Number($qty);
            })
            $getTotalPrice = $totalPrice + $addonsPrice;
            $('.total-price-show').text( ' '+frequentlybuyMainScript.wc_currency+$getTotalPrice  );

        }

    } )


})(jQuery);