<?php
namespace FrequentlyBuy\Admin;

/**
 * 
 *
 * @package     FrequentlyBuy
 * @author      ThemeLooks
 * @copyright   2022 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

if( !defined( 'WPINC' ) ) {
    die;
}

class Admin {

    function __construct() {

        add_action( 'admin_menu', [ $this, 'register_admin_menu' ] );
        new \FrequentlyBuy\Inc\Meta_Base();
    }

    public function register_admin_menu() {
        add_menu_page(
            esc_html__( 'FrequentlyBuy', 'frequentlybuy' ),          // Page title
            esc_html__( 'FrequentlyBuy', 'frequentlybuy' ),          // Menu title
            'manage_options',                  // Capability
            'frequentlybuy-admin-page',                  // Menu slug
            [ $this, 'admin_page_callback' ],         // Callback
            'dashicons-admin-generic',         // Icon
            25                                 // Position
        );
    }

    public function admin_page_callback() {}


}