<?php
if (! defined('ABSPATH')) exit; // Exit if accessed directly 
 $consignment_number = isset($_REQUEST['consignment_number']) ? sanitize_text_field((wp_unslash($_REQUEST['consignment_number']))) : '';


?>
<div class="freightmat-Consignments-wrap freightmat-admin-pages">
    <?php if ($response && isset($response['message']) && $response['message']) { ?>
        <div class="freightmat-<?php echo ($response['status'] == 1) ? 'updated' : 'error' ?>">
            <p><?php echo esc_html($response['message']); ?></p>
        </div>
    <?php } ?>
    <div class="freightmat-track-onsignment-form freightmat-form-layout">
        <form method="POST" id="track-consignment-form">
            <div id="track-track-consignment">
                <div class="track-consignment-section">
                    <div class="track-consignment-fields">
                        <div class="freightmate-form-group">
                            <div class="form-group">
                                <label for="dispatch-date" class="dispatch-date">Enter Connote number to track</label>
                                <hr>
                                <input type="text" name="consignment_number" value="<?php echo esc_html($consignment_number); ?>" required>
                            </div>
                            <div class="form-group"></div>
                            <div class="form-group"></div>
                        </div>
                    </div>
                </div>
                <?php wp_nonce_field('track_consignment_action', 'track_consignment_nonce') ?>
                <div class="consignment-submit-wrap">
                    <input name="submit" type="submit" value="Track" class="freighmate-btn fr-mb-30">
                    <input type="hidden" name="freightmate_action" value="submit">
                </div>
            </div>
        </form>
        <?php
        if ($consignment_number) {
            echo '<div class="iframe-container">
            <iframe id="my-iframe" src="' . esc_html(FREIGHTMATE_TRACKING_URL) . '/t/' . esc_html($consignment_number) . '" frameborder="0"></iframe>
        </div>';
        }
        ?>
    </div>
</div>