<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

//$consignment_number = isset($_REQUEST['consignment_number']) ? wp_verify_nonce(esc_attr(wp_unslash(sanitize_text_field($_REQUEST['consignment_number'])))) : '';
$consignment_number = isset($_REQUEST['consignment_number']) 
    ? wp_verify_nonce(sanitize_text_field(wp_unslash($_REQUEST['consignment_number'])))
    : '';

$consignmentInfo = get_post_meta($order_id, FREIGHTMATE_META_PREFIX . 'consignment_result', true);
$consignmentTracking = isset($trackingData[0]) && isset($trackingData[0]['consignmentTracking']) ? $trackingData[0]['consignmentTracking'] : [];
$itemsTracking = isset($trackingData[0]) && isset($trackingData[0]['itemsTracking']) ? $trackingData[0]['itemsTracking'] : [];
$order_id = freightmateCommonMethods::getOrderIdByConnoteNumber($consignment_number);
$consignmentInfo = get_post_meta($order_id, FREIGHTMATE_META_PREFIX . 'consignment_result', true);

$senderAddressArray = isset($consignmentInfo['data']['senderAddress']) ? $consignmentInfo['data']['senderAddress'] : [];
$deliveryAddressArray = isset($consignmentInfo['data']['deliveryAddress']) ? $consignmentInfo['data']['deliveryAddress'] : [];

$senderAddress = isset($senderAddressArray['addressLine1']) || isset($senderAddressArray['addressLine2'])
    ? implode(", ", array_filter([$senderAddressArray['addressLine1'] ?? '', $senderAddressArray['addressLine2'] ?? '']))
    : '';

$deliveryAddress = isset($deliveryAddressArray['addressLine1']) || isset($deliveryAddressArray['addressLine2'])
    ? implode(", ", array_filter([$deliveryAddressArray['addressLine1'] ?? '', $deliveryAddressArray['addressLine2'] ?? '']))
    : '';
$trackingData = [];
$singleItemTracking = [];
$is_itemsTracking = false;
if (!empty($consignmentTracking) && is_array($consignmentTracking)) {
    $singleItemTracking = $consignmentTracking;
}
if (!empty($itemsTracking) && is_array($itemsTracking)) {
    $trackingData = $itemsTracking;
    $singleItemTracking = $trackingData[0]['itemStatus'];
    $is_itemsTracking = true;
}
?>
<?php if ($response && isset($response['message']) && $response['message']) { ?>
    <div class="freightmat-<?php echo ($response['status'] == 1) ? 'updated' : 'error' ?>">
        <p><?php echo esc_html($response['message']); ?></p>
    </div>
<?php } ?>
<?php if ($singleItemTracking) { ?>
    <div class="freightmate-track-and-trace">
        <div class="freightmate-custom-heading freightmate-custom-heading-flex">
            <h2>Consignment Tracking</h2>
            <?php
            
            if ($is_itemsTracking && $trackingData) {
               ?>
                <div class="freightmate-track-items">
                    <label class="freightmate-select">
                        <select class="freightmate-form-control" name="tracking-itemCode">
                        <?php 
                            foreach ($trackingData as $trackingItem){
                                $itemCode = isset($trackingItem['itemCode']) ? $trackingItem['itemCode'] : '';
                                ?>
                                <option value="<?php echo esc_html($itemCode); ?>"><?php echo esc_html($itemCode); ?></option>
                                <?php
                            }
                        ?>
                        </select>
                    </label>
                </div>
               <?php
            }
            ?>
        </div>
        <div id="track-itemsCodeHTML">
            <div class="top-section">
                <div class="left-section">

                    <p><strong>Consignment Number:</strong><br> <?php echo esc_html($consignment_number); ?></p>
                    <p><strong>Carrier - Service Type:</strong><br> Example Carrier - Standard Shipping</p>
                </div>
                <div class="right-section">
                    <p><strong>Sender Address:</strong><br> <?php echo esc_html($senderAddress); ?></p>
                    <p><strong>Receiver Address:</strong><br> <?php echo esc_html($deliveryAddress); ?></p>
                </div>
            </div>
            <?php 
                $tracking_steps = freightmateCommonMethods::tracking_steps_html($singleItemTracking); 
                echo esc_html($tracking_steps);
            ?>
            <div class="tracking-details">
                <table>
                    <thead>
                        <tr>
                            <th>Date Time</th>
                            <th>Status</th>
                            <th>Location</th>
                            <th>Carrier Description</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                                $formatted_date = gmdate("Y-m-d h:i A", strtotime($DateTime));
                        if ($singleItemTracking) {
                            foreach ($singleItemTracking as $tracking_value) {
                                if ($tracking_value['UpdateStatus'] == 'PROOF_OF_DELIVERY') {
                                    continue;
                                }
                                $DateTime = $tracking_value['DateTime'] ?? '';
                                $formatted_date = gmdate("Y-m-d h:i A", strtotime($DateTime));
                                $location  = $tracking_value['Location'] ?? '';
                                $Status  = $tracking_value['Status'] ?? '';
                                $StatusDescription  = $tracking_value['StatusDescription'] ?? '';
                                ?>
                                <tr>
                                    <td><?php echo esc_html($formatted_date); ?></td>
                                    <td><?php echo esc_html($Status); ?></td>
                                    <td><?php echo esc_html($location); ?></td>
                                    <td><?php echo esc_html($StatusDescription); ?></td>
                                </tr>
                                <?php
                                
                            }
                        }

                        ?>
                    </tbody>
                </table>
            </div>
            <div class="proofofTracking-details tracking-details">
                <h2 class="freightmate-custom-heading">Proof Of Delivery</h2>
                <table>
                    <thead>
                        <tr>
                            <th>Date Time</th>
                            <th>Signed By</th>
                            <th>Signature</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $prrofOfDeliveryOutput = '';
                        if ($singleItemTracking) {
                            foreach ($singleItemTracking as $tracking_value) {
                                if ($tracking_value['UpdateStatus'] != 'PROOF_OF_DELIVERY') {
                                    continue;
                                }
                                $signedBy = $tracking_value['CarrierDescription'] ?? '';
                                $signature = $tracking_value['POD'] ?? '';
                                $DateTime = $tracking_value['DateTime'] ?? '';
                                $formatted_date = gmdate("Y-m-d h:i A", strtotime($DateTime));
                                ?>
                                <tr>
                                    <td><?php echo esc_html($formatted_date); ?></td>
                                    <td><?php echo esc_html($signedBy); ?></td>
                                    <td><a target="_blank" href="<?php echo esc_html($signature); ?>" download><img src="<?php echo esc_html($signature); ?>" alt="Signature"/></a></td>
                                </tr>
                                <?php
                                
                            }
                        }
                        
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php } ?>