<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 
$freightmate_shipping = get_option(FREIGHTMATE_OPTION_PREFIX . 'freightmate_shipping');
$freightmate_shipping_charges = get_option(FREIGHTMATE_OPTION_PREFIX . 'freightmate_shipping_charges');
$is_checked = in_array($freightmate_shipping, ['freightmate_percentage', 'freightmate_flat']) ? 'checked' : '';
$woo_defaultshipping = get_option(FREIGHTMATE_OPTION_PREFIX . 'woo_defaultshipping', 0);
?>
<div class="freightmat-orders-wrap freightmat-admin-pages">
    <?php if ($response && isset($response['message']) && $response['message']) { ?>
        <div class="freightmat-<?php echo ($response['status'] == 1) ? 'updated' : 'error' ?>">
            <p><?php echo esc_html($response['message']); ?></p>
        </div>
    <?php } ?>
    <div class="freightmat-dashboard-form freightmat-form-layout">
        <h2 class="fr-mb-30 freightmat-subheading">Choose the shipping setting to display shipping rates on the WooCommerce checkout page.</h2>
        <form method="POST" name="freightmate_shipping_setting_form">
            <div class="freightmate-form-group freightmate-form-checkbox">
                <h2 class="freightmat-subheading">1. WooCommerce Shipping</h2>
                <div class="form-group">
                    <label class="freightmate-checkbox">
                        <input type="radio" name="freightmate_shipping" value="woocommerce_default" <?php echo ($freightmate_shipping == 'woocommerce_default' ? 'checked' : ''); ?>>
                        <span class="freightmate-checkmark"></span>WooCommerce Calculated
                    </label>
                    <i>Shipping will be managed according to the WooCommerce shipping settings</i>
                </div>
                <h2 class="freightmat-subheading">2. Freightmate Shipping</h2>
                <div class="form-group">
                    <label class="freightmate-checkbox">
                        <input type="radio" name="freightmate_shipping" value="freightmate_default" <?php echo ($freightmate_shipping == 'freightmate_default' ? 'checked' : ''); ?>>
                        <span class="freightmate-checkmark"></span>Freightmate Calculated
                    </label>
                    <i>Shipping charges will be automatically retrieved from Freightmate carriers and displayed on the WooCommerce checkout page.</i>
                </div>
                <div class="form-group shipping-markup">
                    <label class="freightmate-checkbox">
                       <!--  <input type="radio" <?php //echo esc_html($is_checked); ?>>
                        <span class="freightmate-checkmark"></span> -->
                        Freightmate Charges + Markup
                    </label>
                    <i>Charge additional shipping fees on Freightmate calculated shipping.</i>
                </div>
                <div class="form-group shipping-markup">
                    <div class="form-inner-group">
                        <div class="form-group">
                            <label class="freightmate-checkbox">
                                <input type="radio" name="freightmate_shipping" value="freightmate_percentage" <?php echo ($freightmate_shipping == 'freightmate_percentage' ? 'checked' : ''); ?>>
                                <span class="freightmate-checkmark"></span>Percentage
                            </label>
                        </div>
                        <div class="form-group">
                            <label class="freightmate-checkbox">
                                <input type="radio" name="freightmate_shipping" value="freightmate_flat" <?php echo ($freightmate_shipping == 'freightmate_flat' ? 'checked' : ''); ?>>
                                <span class="freightmate-checkmark"></span>Flat amount
                            </label>
                        </div>
                        <div class="form-group">
                            <input type="number" name="freightmate_shipping_charges" placeholder="Enter number" value="<?php echo esc_html($freightmate_shipping_charges); ?>">
                        </div>
                    </div>
                </div>
                <div class="form-group shipping-markup">
                    <label class="freightmate-checkbox">
                        <input type="checkbox" name="woo_defaultshipping" value="1" 
                            <?php echo (!empty($woo_defaultshipping) ? 'checked' : ''); ?>>
                        <span class="freightmate-checkmark"></span>Include WooCommerce Calculated
                    </label>
                    <i>This will include WooCommerce calculated + Freightmate calculated prices</i>
                </div>
            </div>
            <?php wp_nonce_field('freightmate_shipping_setting_action', 'freightmate_shipping_setting_nonce'); ?>
            <p class="submit">
                <input type="submit" name="submit" id="submit" class="button button-primary" value="Save">
                <input type="hidden" name="freightmate_action" value="submit">
                <input type="hidden" name="freightmate_action_type" value="save-shipping">
            </p>
        </form>
    </div>
    <div class="freightmate-revoke">
        <h2 class="freightmate-custom-heading">Revoke/Uninstall account</h2>
        <form method="POST" name="freightmate_uninstall_form" id="freightmate_uninstall_form">
            <input type="button" id="uninstall-freightmate" value="Uninstall" class="freighmate-btn freighmate-danger-btn">
            <input type="hidden" name="freightmate_action" value="submit">
            <input type="hidden" name="freightmate_action_type" value="delete-account">
            <?php wp_nonce_field('freightmate_uninstall_action', 'freightmate_uninstall_nonce'); ?>
        </form>
    </div>
</div>

<div id="freightmate-confirmationDialog" class="freightmate-dialog">
  <div class="freightmate-dialog-content">
    <p id="freightmate-dialogMessage">Are you sure?</p>
    <button id="freightmate-confirmBtn">Yes</button>
    <button id="freightmate-cancelBtn">No</button>
  </div>
</div>
