<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 
$order_list_table = new Freightmate_Order_List_Table();
$order_list_table->prepare_items();
?>
<div class="freightmat-orders-wrap freightmat-admin-pages">
    <?php if ($response && isset($response['message']) && $response['message']) { ?>
        <div class="freightmat-<?php echo ($response['status'] == 1) ? 'updated' : 'error' ?>">
            <p><?php echo esc_html($response['message']); ?></p>
        </div>
    <?php } ?>
    <div class="freightmat-dashboard-form freightmat-form-layout">
        <form method="get">
            <input type="hidden" name="page" value="<?php echo isset($_REQUEST['page']) ? esc_attr(sanitize_text_field(wp_unslash($_REQUEST['page']))) : ''; ?>">
            <p class="search-box">
                <label class="screen-reader-text" for="order-search-input">Search Orders:</label>
                <input type="search" id="order-search-input" name="s" value="<?php echo isset($_REQUEST['s']) ? esc_attr(sanitize_text_field(wp_unslash($_REQUEST['s']))) : ''; ?>" placeholder="Search Orders">
                <input type="submit" id="search-submit" class="button" value="Search Orders">
            </p>
        </form>
        <?php  $order_list_table->display(); ?>
    </div>
</div>