<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 

wp_enqueue_script('pdf-download-handler', plugin_dir_url(__DIR__) . 'js/freightmate-admin-header-script.js', array(), '1.0', true);

if (isset($_REQUEST['action']) && !empty($_REQUEST['action'])) {
    $action = sanitize_text_field(wp_unslash($_REQUEST['action']));
?>

    <?php
    if ($action == 'print_manifest' && isset($_REQUEST['manifestNumber']) && !empty($_REQUEST['manifestNumber'])) {
        $manifestNumber = sanitize_text_field(wp_unslash($_REQUEST['manifestNumber']));
        $result = freightmateCommonMethods::print_manifest_link($manifestNumber);
        $pdf = isset($result['pdf']) && $result['pdf'] ? $result['pdf'] : '';
        $name = isset($result['name']) && $result['name'] ? $result['name'] : '';
        if ($pdf && $name) {
            $pdfContent = base64_decode($pdf);
             wp_localize_script('pdf-download-handler', 'pdfData', array(
                'pdfContent' => esc_js($pdf),
                'fileName'   => esc_js($name)
            ));
        }
    }
    if ($action == 'print_label' && isset($_REQUEST['manifestNumber']) && !empty($_REQUEST['manifestNumber'])) {
        $manifestNumber = sanitize_text_field(wp_unslash($_REQUEST['manifestNumber']));
        $result = freightmateCommonMethods::print_manifest_label_link($manifestNumber);
        $pdf = isset($result['pdf']) && $result['pdf'] ? $result['pdf'] : '';
        $name = isset($result['name']) && $result['name'] ? $result['name'] : '';
        if ($pdf && $name) {
            $pdfContent = base64_decode($pdf);
             wp_localize_script('pdf-download-handler', 'pdfData', array(
                'pdfContent' => esc_js($pdf),
                'fileName'   => esc_js($name)
            ));

        }
    }
}
$manifest_list_table = new Freightmate_Manifest_List_Table();
$manifest_list_table->prepare_items();
?>
<div class="freightmat-Manifest-wrap freightmat-admin-pages">
    <?php if ($response && isset($response['message']) && $response['message']) { ?>
        <div class="freightmat-<?php echo ($response['status'] == 1) ? 'updated' : 'error' ?>">
            <p><?php echo esc_html($response['message']); ?></p>
        </div>
    <?php } ?>
    <div class="freightmat-dashboard-form freightmat-form-layout">
        <form method="get">
            <input type="hidden" name="page" value="<?php echo isset($_REQUEST['page']) ? esc_attr(sanitize_text_field(wp_unslash($_REQUEST['page']))) : ''; ?>">
            <p class="search-box">
                <label class="screen-reader-text" for="order-search-input">Search Manifest:</label>
                <input type="search" id="order-search-input" name="s" value="<?php echo isset($_REQUEST['s']) ? esc_attr(sanitize_text_field(wp_unslash($_REQUEST['s']))) : ''; ?>" placeholder="Search Manifest">
                <input type="submit" id="search-submit" class="button" value="Search Manifest">
            </p>
        </form>
        <?php  $manifest_list_table->display(); ?>
    </div>
</div>

