<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly 
$clientId = isset($response['client_address']) && isset($response['client_address']['clientId']) ? $response['client_address']['clientId'] : '';
$company_name = isset($response['client_address']) && isset($response['client_address']['company']) ? $response['client_address']['company'] : '';
$address = isset($response['client_address']) && isset($response['client_address']['address']) ? $response['client_address']['address'] : '';
$carriersData = isset($response['carriers']) && isset($response['carriers']['data']) ? $response['carriers']['data'] : [];
$carriers = isset($carriersData['results']) && isset($carriersData['results']) ? $carriersData['results'] : [];
$items = isset($response['items']) ? $response['items'] : [];
$shipping_data = isset($response['shipping']) && isset($response['shipping']['data']) ? $response['shipping']['data'] : [];
$shipping_address = isset($response['shipping']) && isset($response['shipping']['address']) ? $response['shipping']['address'] : [];
$customer_name = isset($shipping_address['name']) ? $shipping_address['name'] : '';
$customer_email = isset($shipping_address['email']) ? $shipping_address['email'] : '';
$address_1 = isset($shipping_address['address_1']) ? $shipping_address['address_1'] : '';
$address_2 = isset($shipping_address['address_2']) ? $shipping_address['address_2'] : '';
$company = isset($shipping_address['company']) && $shipping_address['company'] ? $shipping_address['company'] : $customer_name;
$city = isset($shipping_address['city']) ? $shipping_address['city'] : '';
$postcode = isset($shipping_address['postcode']) ? $shipping_address['postcode'] : '';
$tailgate = isset($shipping_address['tailgate']) ? $shipping_address['tailgate'] : false;
$suburbCode = [strtoupper($city), $postcode];
$phone = isset($shipping_address['phone']) ? $shipping_address['phone'] : '';
?>
<div class="freightmat-Consignments-wrap freightmat-admin-pages">
    <?php if ($response && isset($response['message']) && $response['message']) { ?>
        <div class="freightmat-<?php echo ($response['status'] == 1) ? 'updated' : 'error' ?>">
            <p><?php echo esc_html($response['message']); ?></p>
        </div>
    <?php } ?>
    <div class="freightmat-create-onsignment-form freightmat-form-layout">
        <div class="freightmat-back-link">
            <a href="<?php echo esc_html(admin_url('admin.php?page=freightmate-orders')); ?>"><span
                    class="freightmate-back-tag">❮</span><span>Back to Orders</span></a>
        </div>
        <form method="POST" id="create-consignment-form">
            <div id="create-new-consignment">
                <div class="new-consignment-section">
                    <h2 class="freightmate-custom-heading">New Consignment</h2>
                    <div class="new-consignment-fields">
                        <div class="freightmate-form-group">
                            <div class="dispatch-date-field form-group">
                                <label for="dispatch-date" class="dispatch-date">Dispatch Date</label>
                                <hr>
                                <input type="date" data-name="Dispatch Date" id="dispatch-date" name="dispatch-date"
                                    min="<?php echo esc_html(gmdate('Y-m-d')); ?>"
                                    value="<?php echo esc_html(gmdate('Y-m-d')); ?>" required>
                            </div>
                            <div class="dispatch-date-field form-group"></div>
                            <div class="dispatch-date-field form-group"></div>
                        </div>
                        <div class="freightmate-form-group">
                            <div class="sender-details-field form-group">
                                <label for="sender-details" class="sender-details">Sender Details</label>
                                <hr>
                                <h4><?php echo esc_html($company_name); ?></h4>
                                <p><?php echo esc_html($address); ?></p>
                            </div>
                            <div class="receiver-details-field form-group">
                                <label for="receiver-details" class="receiver-details">Receiver Details</label>
                                <hr>
                                <div class="form-group">
                                    <div class="freightmate-autocomplete">
                                        <div class="loader-placement">
                                <img src="<?php echo esc_html(FREIGHTMATE_APP_PLUGIN_URL) . '/images/freightmate-ajax-loader.gif' ?>"
                                                style="display: none;">
                                            <input type="text" id="receiver-address" name="receiver-address"
                                                placeholder="Select address">
                                        </div>
                                        <input type="hidden" name="sender-clientId"
                                            value="<?php echo esc_html($clientId); ?>">
                                        <div id="suggestions-container" class="suggestions"></div>
                                    </div>
                                </div>
                                <div class="freightmate-flex-box">
                                    <div class="form-group">
                                        <input type="text" id="company" data-name="Company Name" name="company"
                                            placeholder="Company name" value="<?php echo esc_html($company); ?>">
                                    </div>
                                    <div class="form-group">
                                        <input type="text" id="contact-name" name="contact-name"
                                            placeholder="Contact Name" data-name="Contact Name"
                                            value="<?php echo esc_html($customer_name); ?>">
                                    </div>
                                </div>
                                <div class="freightmate-flex-box">
                                    <div class="form-group">
                                        <input type="text" id="address-1" name="address-1" placeholder="Address Line 1"
                                            data-name="Address Line 1"
                                            value="<?php echo esc_attr(isset($address_1) ? $address_1 : ''); ?>">

                                    </div>
                                    <div class="form-group">
                                        <input type="text" id="address-2" name="address-2" placeholder="Address Line 2"
                                            data-name="Address Line 2"
                                            value="<?php echo esc_attr(isset($address_2) ? $address_2 : ''); ?>">

                                    </div>
                                </div>
                                <div class="freightmate-flex-box">
                                    <div class="form-group">
                                        <input type="tel" id="phone" name="phone" placeholder="Phone" data-name="Phone"
                                            value="<?php echo esc_html($phone); ?>">
                                    </div>
                                    <div class="form-group">
                                        <input type="email" id="email" name="email" placeholder="Email"
                                            data-name="Email"
                                            value="<?php echo esc_attr(isset($customer_email) ? $customer_email : ''); ?>">

                                    </div>
                                </div>
                                <div class="freightmate-flex-box">
                                    <div class="form-group">
                                        <div class="freightmate-autocomplete">
                                            <div class="loader-placement">
                                                <img src="<?php echo esc_html(FREIGHTMATE_APP_PLUGIN_URL) . '/images/freightmate-ajax-loader.gif' ?>"
                                                    style="display: none;">
                                                <?php $suburbCode_str = implode(', ', $suburbCode); ?>
                                                <input type="text" id="suburb-postcode" name="suburb-postcode"
                                                    placeholder="Suburb / Postcode" data-name="Suburb / Postcode"
                                                    value="<?php echo esc_html( $suburbCode_str ); ?>">
                                            </div>
                                            <div id="suburb-suggestions-container" class="suggestions"></div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <textarea id="special-instructions" name="special-instructions"
                                            placeholder="Special Instructions"
                                            data-name="Special Instructions"></textarea>
                                    </div>
                                </div>
                                <div class="freightmate-form-group freightmate-form-checkbox">
                                    <div class="form-group">
                                        <label class="freightmate-checkbox">
                                            <input type="checkbox" id="authority-to-leave" name="authority-to-leave">
                                            <span class="freightmate-checkmark"></span>Authority to Leave
                                        </label>
                                        <!-- <label for="authority-to-leave">Authority to Leave</label> -->
                                    </div>

                                    <div class="form-group">
                                        <label class="freightmate-checkbox">
                                            <input type="checkbox" id="tailgate-required" name="tailgate" <?php echo ($tailgate == true ? 'checked' : ''); ?>>
                                            <span class="freightmate-checkmark"></span>Tailgate Required
                                        </label>
                                        <!-- <label for="tailgate-required">Tailgate Required</label> -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="new-item-section">
                    <h2 class="freightmate-custom-heading">Item Info</h2>
                    <div class="new-consignment-fields">
                        <!-- <div class="freightmate-add-order-reference">
                            <a class="reference-btn" href="javascript:">+ Add Reference</a>
                        </div> -->
                        <div class="freightmate-wc-items">
                            <div class="freightmate-wc-items-labels">
                                <div class="freightmate-wc-item-label">Qty</div>
                                <div class="freightmate-wc-item-label">Product</div>
                                <div class="freightmate-wc-item-label">Item Type</div>
                                <div class="freightmate-wc-item-label">Length<sup>mtr</sup></div>
                                <div class="freightmate-wc-item-label">Width<sup>mtr</sup></div>
                                <div class="freightmate-wc-item-label">Height<sup>mtr</sup></div>
                                <div class="freightmate-wc-item-label">Weight<sup>kg</sup></div>
                                <div class="freightmate-wc-item-label">Action</div>
                            </div>

                            <div id="freightmate-items-container">
                                <?php
                                if ($shipping_data) {
                                    $item_count = 0;
                                    foreach ($shipping_data as $shipping_info) {
                                        $name = $shipping_info['name'] ?? '';
                                        $quantity = $shipping_info['quantity'] ?? '';
                                        $weight = $shipping_info['weight'] ?? '';
                                        $length = $shipping_info['length'] ?? '';
                                        $width = $shipping_info['width'] ?? '';
                                        $height = $shipping_info['height'] ?? '';
                                        $itemTypeName = $shipping_info['itemTypeName'] ?? '';
                                        $itemTypeId = $shipping_info['itemTypeId'] ?? '';
                                        $isMutable = $shipping_info['isMutable'] ?? true;
                                        $product_id = $shipping_info['product_id'] ?? '';
                                        $item_opts = '';

                                        ?>
                                        <div class="freightmate-wc-items-values-main"
                                            data-ismutable="<?php ($isMutable == true ? "true" : "false"); ?>"  
                                            data-item="<?php echo esc_html($item_count); ?>">
                                            <?php $disabled_attr = $isMutable == true ? '' : 'disabled'; ?>
                                            <div class="freightmate-wc-item-value freightmate-number"><input type="number"
                                                    name="item-type[<?php echo esc_html($item_count); ?>][quantity]"
                                                    value="<?php echo esc_html($quantity); ?>"></div>
                                            <div class="freightmate-wc-item-value"><?php echo esc_html($name); ?></div>
                                            <div class="freightmate-wc-item-value">
                                                <?php 
                                                if ($items) {
                                                    ?>
                                                    <label class="freightmate-select">
                                                        <select data-name="Items"
                                                            name="item-type[<?php echo esc_html($item_count); ?>][itemTypeName]"
                                                            data-targetId="<?php echo esc_html($item_count); ?>"
                                                            data-productId="<?php echo esc_html($product_id); ?>">
                                                            <option value="">Select Item</option>
                                                            <?php
                                                            foreach ($items as $item) {
                                                                $id = isset($item['id']) ? $item['id'] : '';
                                                                $itemName = isset($item['type']) && $item['type'] ? $item['type'] : '';
                                                                if (!isset($item['type']) && $itemName == '' && isset($item['name'])) {
                                                                    $itemName = $item['name'];
                                                                }
                                                                if ($id && $itemName) {
                                                                    $selected = $itemTypeId == $id ? 'selected' : '';
                                                                    ?>
                                                                    <option value="<?php echo esc_html($id); ?>" <?php echo esc_html($selected); ?>><?php echo esc_html($itemName); ?></option>
                                                                    <?php
                                                                }
                                                            }
                                                            ?>
                                                        </select>
                                                    </label>
                                                    <?php
                                                }
                                                ?>

                                            </div>
                                            <div class="freightmate-wc-item-value">
                                                <input type="number"
                                                    name="item-type[<?php echo esc_html($item_count); ?>][length]" min="0"
                                                    step="0.01" value="<?php echo esc_html($length); ?>" <?php echo esc_html($disabled_attr); ?> data-name="Items length">
                                            </div>
                                            <div class="freightmate-wc-item-value">
                                                <input type="number"
                                                    name="item-type[<?php echo esc_html($item_count); ?>][width]" min="0"
                                                    step="0.01" value="<?php echo esc_html($width); ?>" <?php echo esc_html($disabled_attr); ?> data-name="Items width">
                                            </div>
                                            <div class="freightmate-wc-item-value">
                                                <input type="number"
                                                    name="item-type[<?php echo esc_html($item_count); ?>][height]" min="0"
                                                    step="0.01" value="<?php echo esc_html($height); ?>" <?php echo esc_html($disabled_attr); ?> data-name="Items height">
                                            </div>
                                            <div class="freightmate-wc-item-value">
                                                <input type="number"
                                                    name="item-type[<?php echo esc_html($item_count); ?>][weight]" min="0"
                                                    step="0.01" value="<?php echo esc_html($weight); ?>" <?php echo esc_html($disabled_attr); ?> data-name="Items weight">
                                            </div>
                                            <input type="hidden"
                                                name="item-type[<?php echo esc_html($item_count); ?>][itemTypeName]"
                                                value="<?php echo esc_html($itemTypeName); ?>">

                                            <?php
                                            if ($item_count != 0) {
                                                ?>
                                                <div class="freightmate-wc-item-value freightmate-delete-item">
                                                    <a><span>&#11199;</span></a></div>
                                                <?php
                                            } else {
                                                ?>
                                                <div class="freightmate-wc-item-value freightmate-delete-item"></div>
                                                <?php
                                            }
                                            ?>
                                        </div>
                                        <?php
                                        $item_count++;
                                    }
                                }
                                ?>
                            </div>
                            <div class="freightmate-add-item-action"><button id="freightmate-add-item"
                                    class="freighmate-btn">Add Item</button></div>

                           
                        </div>
                    </div>
                </div>
                <div class="offer-carriers-details">
                    <h2 class="freightmate-custom-heading">Carriers</h2>
                    <div class="freightmate-carrier-fields new-consignment-fields">
                        <div class="form-group">
                            <div class="freightmate-flex-box fr-mb-15">
                                <label class="freightmate-select">
                                    <select name="carrier-type" id="carrier-type" data-name="Offers">
                                        <option value="CHEAPEST">CHEAPEST</option>
                                        <option value="OFFERS">OFFERS</option>
                                    </select>
                                </label>
                                <img class="freightmate-img img-w-40"
                                    src="<?php echo esc_html(FREIGHTMATE_APP_PLUGIN_URL) . '/images/freightmate-ajax-loader.gif' ?>"
                                    style="display: none;">
                            </div>
                        </div>
                        <input type="hidden" value="Calculate" class="freighmate-btn" id="calculate-carrier">
                    </div>
                    <div class="freightmate-carrier-items" id="freightmate-carrier-items">
                    </div>
                </div>
                <div class="action-consignment-section">
                    <h2 class="freightmate-custom-heading">Consignment</h2>
                    <div class="action-consignment-btns">
                        <!-- <button disabled>Print Labels</button> -->
                        <input type="hidden" name="order_id" value="<?php echo isset($_REQUEST['order_id']) ? esc_attr(sanitize_text_field(wp_unslash($_REQUEST['order_id']))) : ''; ?>">

                        <?php wp_nonce_field('create_consignment_action', 'create_consignment_nonce') ?>
                        <div class="consignment-submit-wrap">
                            <img class="freightmate-img"
                                src="<?php echo esc_html(FREIGHTMATE_APP_PLUGIN_URL) . '/images/freightmate-ajax-loader.gif' ?>"
                                style="display: none;">
                            <input class="testing" type="submit" id="submit-consignment" value="Submit Consignment">
                        </div>
                    </div>

                </div>
            </div>
    </div>
    </form>
</div>
</div>