<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 
//$order_id = isset($_REQUEST['order_id']) && !empty($_REQUEST['order_id']) ? sanitize_text_field($_REQUEST['order_id']) : ''; 
$order_id = isset($_REQUEST['order_id']) && !empty($_REQUEST['order_id']) ? sanitize_text_field(wp_unslash($_REQUEST['order_id'])) : '';
$order_id = sanitize_text_field($order_id);
$consignmentRes = get_post_meta($order_id, FREIGHTMATE_META_PREFIX . 'consignment_result', true);
$consignmentInfo = isset($consignmentRes['data']) && !empty($consignmentRes['data']) ? $consignmentRes['data'] : [];

$PickupStart = $consignmentInfo['preferredPickupStart'] ?? '';
$PickupEnd = $consignmentInfo['preferredPickupEnd'] ?? '';
//$readyTime = isset($_REQUEST['readyTime']) && !empty($_REQUEST['readyTime']) ? sanitize_text_field($_REQUEST['readyTime']) : $PickupStart;
//$closingTime = isset($_REQUEST['closingTime']) && !empty($_REQUEST['closingTime']) ? sanitize_text_field($_REQUEST['closingTime']) : $PickupEnd;

$readyTime = isset($_REQUEST['readyTime']) && !empty($_REQUEST['readyTime']) ? sanitize_text_field(wp_unslash($_REQUEST['readyTime'])) : $PickupStart;
$closingTime = isset($_REQUEST['closingTime']) && !empty($_REQUEST['closingTime']) ? sanitize_text_field(wp_unslash($_REQUEST['closingTime'])) : $PickupEnd;
$readyTime = sanitize_text_field($readyTime);
$closingTime = sanitize_text_field($closingTime);

$dispatchedAt = $consignmentInfo['dispatchedAt'] ?? '';
$dispatchedAtdt = freightmateCommonMethods::convert_iso8601_to_wp_timezone($dispatchedAt);
$dispatchedDate = $dispatchedAtdt['date'];
$currentDate = gmdate('Y-m-d');
//$cut_off = isset($_REQUEST['cut_off']) && !empty($_REQUEST['cut_off']) ? sanitize_text_field($_REQUEST['cut_off']) : '';
$cut_off = isset($_REQUEST['cut_off']) && !empty($_REQUEST['cut_off']) ? sanitize_text_field(wp_unslash($_REQUEST['cut_off'])) : '';


$cutOffDateTime = freightmateCommonMethods::convert_iso8601_to_wp_timezone($cut_off);
$cutOffDate = $cutOffDateTime['date'];
$cutOffTime = $cutOffDateTime['time'];
$manifestDate = $dispatchedDate;
if ($manifestDate < $currentDate) {
    $manifestDate = $currentDate;
}
if ($readyTime > $PickupStart) {
    // Assuming you want to add +1 day to $manifestDate if $readyTimeInput is less than $PickupStart
    $manifestDate = gmdate('Y-m-d', strtotime('+1 day', strtotime($manifestDate)));
} elseif ($manifestDate < $cutOffDate) {
    $manifestDate = $cutOffDate;
} elseif ( $manifestDate >= $currentDate && $readyTime > $cutOffTime  ) {
    // Assuming you want to add +1 day to $manifestDate if $readyTimeInput is less than $cutOffTime
    $manifestDate = gmdate('Y-m-d', strtotime('+1 day', strtotime($cutOffDate)));
}
?>
<div class="freightmat-manifest-wrap freightmat-admin-pages">
    <?php if ($response && isset($response['message']) && $response['message']) { ?>
        <div class="freightmat-<?php echo ($response['status'] == 1) ? 'updated' : 'error' ?>">
            <p>
                <?php 
                /* translators: %1$s is the error message */
                printf( esc_html__( 'Error: %1$s', 'freightmate-for-woocommerce'), esc_html( $response['message'] ) );
                ?>
            </p>
        </div>
    <?php } ?>
    <div class="freightmat-create-manifest-form freightmat-form-layout">
        <div class="freightmat-back-link">
            <a href="<?php echo esc_html(admin_url('admin.php?page=freightmate-consignment')); ?>"><span class="freightmate-back-tag">❮</span><span>Back to Consignments</span></a>
        </div>
        <form method="POST" id="create-manifest-form">
            <div id="create-new-manifest">
                <div class="new-manifest-section">
                    <h2 class="freightmate-custom-heading">New Manifest</h2>
                    <div class="manifest-data-warning">
                        <p>
                        Please note: If you proceed to manifest, the dispatch date(s) for all the selected consignment(s) will change to <?php echo esc_html($manifestDate); ?>.
                        </p>
                    </div>
                    <div class="new-manifest-fields">
                        <div class="freightmate-form-group">
                            <div class="freightmate-time-flex-box">
                                <div class="form-group">
                                    <label for="readyTime">Ready Time:</label>
                                    <input type="time" id="readyTime" name="readyTime" value="<?php echo isset($readyTime) ? esc_attr(wp_unslash($readyTime)) : ''; ?>">

                                </div>
                                <div class="form-group">
                                    <label for="closingTime">Closing Time:</label>
                                    <input type="time" id="closingTime" name="closingTime" value="<?php echo isset($closingTime) ? esc_attr(wp_unslash($closingTime)) : ''; ?>">

                                </div>
                            </div>
                            <div></div>
                        </div>
                    </div>
                </div>
                <div class="freightmate-ht5"></div>
                <div class="action-manifest-section">
                    <input name="submit" type="submit" id="submit-manifest" value="Create manifest" class="freighmate-btn">
                    <input type="hidden" name="freightmate_action" value="submit">
                    <?php wp_nonce_field('freightmate_create_manifest_action', 'freightmate_create_manifest_nonce'); ?>
                </div>
            </div>
    </div>
    </form>
</div>
</div>