<?php
if (! defined('ABSPATH')) exit; // Exit if accessed directly 
$consignment_list_table = new Freightmate_Consignment_List_Table();
$consignment_list_table->prepare_items();
?>
<div class="freightmat-Consignments-wrap freightmat-admin-pages">
    <?php if ($response && isset($response['message']) && $response['message'] && isset($response['is_deleted']) && $response['is_deleted'] == 1) { ?>
        <div class="freightmat-<?php echo ($response['status'] == 1) ? 'updated' : 'error' ?>">
            <p>
            <?php 
            /* translators: %1$s is the error message */
            printf( esc_html__( 'Error: %1$s', 'freightmate-for-woocommerce'), esc_html( $response['message'] ) );
            ?>
            </p>
        </div>
    <?php } ?>
    <div class="freightmat-dashboard-form freightmat-form-layout">
        <form method="get">
            <input type="hidden" name="page" value="<?php echo isset($_REQUEST['page']) ? esc_attr(sanitize_text_field(wp_unslash($_REQUEST['page']))) : ''; ?>">
            <p class="search-box">
                <label class="screen-reader-text" for="order-search-input">Search Consignments:</label>
                <input type="search" id="order-search-input" name="s" value="<?php echo isset($_REQUEST['s']) ? esc_attr(sanitize_text_field(wp_unslash($_REQUEST['s']))) : ''; ?>" placeholder="Search Consignments">
                <input type="submit" id="search-submit" class="button" value="Search Consignments">
            </p>
        </form>

        <?php $consignment_list_table->display(); ?>
    </div>
</div>

<div id="freightmate-confirmationDialog" class="freightmate-dialog">
    <div class="freightmate-dialog-content">
        <p id="freightmate-dialogMessage">Are you sure?</p>
        <button id="freightmate-confirmBtn">Yes</button>
        <button id="freightmate-cancelBtn">No</button>
    </div>
</div>