<?php
if (! defined('ABSPATH')) exit; // Exit if accessed directly 
$api_key = get_option(FREIGHTMATE_OPTION_PREFIX . 'client_api_key');
$password = get_option(FREIGHTMATE_OPTION_PREFIX . 'client_password');
$password = base64_decode($password);
$environment_type = get_option(FREIGHTMATE_OPTION_PREFIX . 'environment_type');
$live_api_url = get_option(FREIGHTMATE_OPTION_PREFIX . 'live_api_url');
$stage_api_url = get_option(FREIGHTMATE_OPTION_PREFIX . 'stage_api_url');
?>
<div class="freightmat-dashboard-wrap freightmat-admin-pages">
    <?php if ($response && isset($response['message']) && $response['message']) { ?>
        <div class="freightmat-<?php echo ($response['status'] == 1) ? 'updated' : 'error' ?>">
            <p>
            <?php 
            /* translators: %1$s is the error message */
            printf( esc_html__( 'Error: %1$s', 'freightmate-for-woocommerce'), esc_html( $response['message'] ) );
            ?>
            </p>
        </div>
    <?php } ?>
    <div class="freightmat-dashboard-form freightmat-form-layout">
        <form method="post">
            <?php wp_nonce_field('freightmate_creds_action', 'freightmate_creds_nonce') ?>
            <table class="form-table">
                <tbody>
                    <tr>
                        <th scope="row"><label for="freightmate-api-key">API Key</label></th>
                        <td><input name="freightmate-api-key" type="text" class="freightmate-form-control" id="freightmate-api-key" value="<?php echo isset($api_key) ? esc_attr(wp_unslash($api_key)) : ''; ?>"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="freightmate-password">Password</label></th>
                        <td><input name="freightmate-password" type="password" class="freightmate-form-control" id="freightmate-password" value="<?php echo isset($password) ? esc_attr(wp_unslash($password)) : ''; ?>"> </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="freightmate-password">Environment</label></th>
                        <td>
                            <label class="freightmate-select">
                                <select class="freightmate-form-control" name="freightmate-environment">
                                    <option value="">Select environment</option>
                                    <option value="STAGE" <?php echo ($environment_type == 'STAGE' ? 'selected' : ''); ?>>STAGE</option>
                                    <option value="LIVE" <?php echo ($environment_type == 'LIVE' ? 'selected' : ''); ?>>LIVE</option>
                                </select>
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="freightmate-api-key">API URL(Stage)</label></th>
                        <td><input name="freightmate-api-url-stage" type="url" class="freightmate-form-control" value="<?php echo !empty($stage_api_url) ? esc_url(wp_unslash($stage_api_url)) : 'https://api.sit.staging.freightmate.com'; ?>">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="freightmate-api-key">API URL(Live)</label></th>
                        <td><input name="freightmate-api-url-live" type="url" class="freightmate-form-control" value="<?php echo !empty($live_api_url) ? esc_url(wp_unslash($live_api_url)) : 'https://api.freightmate.com'; ?>">
                        </td>
                    </tr>
                </tbody>
            </table>
            <p class="submit">
                <input type="submit" name="submit" id="submit" class="button button-primary" value="Save">
                <input type="hidden" name="freightmate_action" value="submit">
            </p>
        </form>
                <div>
            <h3>Steps to Connect Your Freightmate Account</h3>  
<ol>  
  <li>Login to your Freightmate account at <a href="https://freightmate.com/login" target="_blank">https://freightmate.com/login</a>.</li>  
  <li>Navigate to the administration section and click on 'Clients' (<strong>Administration &gt; Clients</strong>).</li>  
  <li>Select the client you want to link with Shopify.</li>  
  <li>Click on 'API Keys' and create a new API key.</li>  
  <li>Fill in the reference name and save the API keys.</li>  
  <li>Copy the API key and secret, then paste them into the required section.</li>  
</ol>

        </div>
    </div>
</div>