document.addEventListener('DOMContentLoaded', function () {
    // Update shipping on cart and checkout field changes
    var checkoutForms = document.querySelectorAll('form.checkout, form.woocommerce-cart-form');
    checkoutForms.forEach(function (form) {
        form.addEventListener('change', function (event) {
            if (event.target.matches('input.qty, select.qty')) {
                document.body.dispatchEvent(new Event('update_checkout'));
            }
        });
    });

    // Ensure update is triggered when quantities are changed in the cart
    document.addEventListener('updated_cart_totals', function () {
        document.body.dispatchEvent(new Event('update_checkout'));
    });
    //Add Authority To leave field
    // Create the custom field HTML
    if (!document.getElementById('freightmate_custom_checkout_field')) {
        // var checkboxField = document.createElement('div');
        // checkboxField.id = 'freightmate_custom_checkout_field';
        // var label = document.createElement('label');
        // label.className = 'woocommerce-form__label woocommerce-form__label-for-checkbox checkbox';
        // var input = document.createElement('input');
        // input.className = 'woocommerce-form__input woocommerce-form__input-checkbox input-checkbox';
        // input.type = 'checkbox';
        // input.name = 'authority_to_leave';
        // input.id = 'authority_to_leave';
        // var span = document.createElement('span');
        // span.textContent = 'Authority to leave';
        // label.appendChild(input);
        // label.appendChild(span);
        // checkboxField.appendChild(label);
        // Find the element to insert before
        var checkboxField = `<div id="freightmate_custom_checkout_field" class="wc-block-checkout__authority-to-leave">
            <div class="wc-block-components-checkbox">
                <label for="authority_to_leave">
                    <input id="authority_to_leave" class="wc-block-components-checkbox__input" type="checkbox" aria-invalid="false">
                    <svg class="wc-block-components-checkbox__mark" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 20">
                        <path d="M9 16.2L4.8 12l-1.4 1.4L9 19 21 7l-1.4-1.4L9 16.2z"></path>
                    </svg>
                    <span class="wc-block-components-checkbox__label">Authority to leave</span>
                </label>
            </div>
        </div>`;
        console.log('====================================');
        console.log('checkboxField', checkboxField);
        console.log('====================================');
        var orderComments = document.getElementById('order-notes');

        // Insert the custom field before the order notes
        orderComments.insertAdjacentHTML('afterend', checkboxField);
    }
});
