document.addEventListener('DOMContentLoaded', function () {
    function freighmatecloneAndAppendItem() {
        const container = document.getElementById('freightmate-items-container');
        const lastItem = container.querySelector('.freightmate-wc-items-values-main:last-child');

        // Clone the last item
        const newItem = lastItem.cloneNode(true);
        newItem.querySelector('.freightmate-delete-item').remove();
        //Add delete action HTML
        deleteItem = document.createElement('div');
        deleteItem.className = 'freightmate-wc-item-value freightmate-delete-item';
        deleteItem.innerHTML = '<a><span>&#11199;</span></a>'; // Using &#11199; for the delete icon
        newItem.appendChild(deleteItem);
        // Get the current data-item value and increment it
        const currentIndex = parseInt(lastItem.getAttribute('data-item'));
        const newIndex = currentIndex + 1;
        newItem.setAttribute('data-item', newIndex);

        // Update all names and IDs to the new index
        newItem.querySelectorAll('input, select').forEach(function(element) {
            const name = element.getAttribute('name');
            if (name) {
                element.setAttribute('name', name.replace(`[${currentIndex}]`, `[${newIndex}]`));
            }
            const dataTargetId = element.getAttribute('data-targetid');
            if (dataTargetId) {
                element.setAttribute('data-targetid', newIndex);
            }
        });

        // Append the new item to the container
        container.appendChild(newItem);
    }
    if( document.getElementById('freightmate-add-item') ){
        document.getElementById('freightmate-add-item').addEventListener('click', freighmatecloneAndAppendItem);
    }
    const searchAddress = document.getElementById('receiver-address');
    //const parentWithLoader = searchAddress.closest('.loader-placement');
    const suggestionContainer = document.getElementById('suggestions-container');
    if (searchAddress) {
        searchAddress.addEventListener('input', handleSearchAddress);
    }
    function handleSearchAddress(event) {
        const searchKeyword = event.target.value;
        if (searchKeyword.length < 3) {
            suggestionContainer.innerHTML = '';
            return;
        }
        getSearchAddressResults(searchKeyword);
    }
    // Function to get URL parameter by name
    function getParameterByName(name) {
        name = name.replace(/[\[\]]/g, "\\$&");
        let url = window.location.href;
        let regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
            results = regex.exec(url);
        if (!results) return null;
        if (!results[2]) return '';
        return decodeURIComponent(results[2].replace(/\+/g, " "));
    }
    // Check if consignment_number parameter exists in URL
    // let consignmentNumber = getParameterByName('consignment_number');
    // if (consignmentNumber) {
    //     let submitButton = document.querySelector('form#track-consignment-form input[type="submit"]');
    //     // Check if the button is available and not already clicked
    //     if (submitButton && !submitButton.clicked) {
    //         // Manually trigger the click event
    //         submitButton.click();
    //         // Mark the button as clicked
    //         submitButton.clicked = true;
    //         return false;
    //     }
    // }
    function showToast(messages, type = 'info', duration = 3000) {
        const toastContainer = document.getElementById('toast-container');
        toastContainer.innerHTML = '';
        const toast = document.createElement('div');
        toast.classList.add('toast', type);
        let messagesList = '';
        if (messages) {
            messagesList += '<ul class="toast-ul">';
            messages.forEach(function (message, index) {
                messagesList += '<li>' + message + '</li>';
            });
            messagesList += '</ul>';
        }
        toast.innerHTML = `
            ${messagesList}
            <button class="close-btn">&times;</button>
        `;
        toast.querySelector('.close-btn').addEventListener('click', () => {
            toastContainer.removeChild(toast);
        });
        toastContainer.appendChild(toast);
        setTimeout(() => {
            toast.classList.add('show');
        }, 100); // Delay to ensure the CSS transition
        setTimeout(() => {
            toast.classList.remove('show');
            setTimeout(() => {
                toastContainer.removeChild(toast);
            }, 400); // Match the CSS transition duration
        }, duration);
    }
    // Return current date in Format : d/m/Y
    function freighmateCurrentDate() {
        const today = new Date();
        const day = today.getDate().toString().padStart(2, '0');
        const month = (today.getMonth() + 1).toString().padStart(2, '0'); // January is 0, so we add 1
        const year = today.getFullYear();
        return `${day}/${month}/${year}`;
    }
    function getSearchAddressResults(searchKeyword) {
        const nonce = freightmate.nonce;
        let loaderImage = document.getElementById('receiver-address').closest('.loader-placement').querySelector('img')
        return new Promise((resolve, reject) => {
            if (loaderImage) {
                loaderImage.style.display = 'block';
            }
            const xhr = new XMLHttpRequest();
            xhr.open('POST', freightmate.ajaxURL);
            xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            xhr.onload = function () {
                if (xhr.status === 200) {
                    const responseData = JSON.parse(xhr.responseText);
                    const suggestions = responseData.data.results;
                    suggestionContainer.innerHTML = ''; // Clear previous suggestions
                    // Loop through suggestions and create list items
                    suggestions.forEach((suggestion, index) => {
                        //Full Address HTML
                        let { company, addressLine1, addressLine2, suburb: { name, postcode } } = suggestion;
                        let fullAddressArray = [company, addressLine1, addressLine2, name, postcode];
                        let fullAddressHTML = fullAddressArray.filter(Boolean).join(', '); // Filter out empty values
                        const listItem = document.createElement('li');
                        listItem.textContent = fullAddressHTML;
                        listItem.dataset.id = index;
                        listItem.addEventListener('click', function () {
                            const clickedId = this.dataset.id;
                            suggestionContainer.innerHTML = "";
                            populateAddressResult(suggestions, clickedId);
                        });
                        suggestionContainer.appendChild(listItem);
                    });
                    if (loaderImage) {
                        loaderImage.style.display = 'none';
                    }
                    resolve();
                } else {
                    reject(Error('Error fetching suggestions'));
                }
            };
            xhr.onerror = function () {
                reject(Error('Network error'));
            };
            xhr.send(`action=wp_searchKeyword_ajax_action&searchKeyword=${encodeURIComponent(searchKeyword)}&nonce=${nonce}`);
        });
    }
    function populateAddressResult(addressData, index) {
        const selectedAddress = addressData[index];
        const searchAddress = document.getElementById('receiver-address');
        const eleCompany = document.getElementById('company');
        const eleName = document.getElementById('contact-name');
        const eleAddress1 = document.getElementById('address-1');
        const eleAddress2 = document.getElementById('address-2');
        const eleSuburbPostcode = document.getElementById('suburb-postcode');
        const elePhone = document.getElementById('phone');
        const eleEmail = document.getElementById('email');
        //const eleClientID = document.getElementById('sender-clientId');
        if (selectedAddress) {
            let { phoneNumber, email, company, contactName, addressLine1, addressLine2, suburb: { name, postcode } } = selectedAddress;
            let fullAddressArray = [company, addressLine1, addressLine2, name, postcode];
            let fullAddressHTML = fullAddressArray.filter(Boolean).join(', '); // Filter out empty values
            let suburbPostcode = [name, postcode].join(', ');

            searchAddress.value = fullAddressHTML;
            eleCompany.value = company || '';
            eleAddress1.value = addressLine1 || '';
            eleAddress2.value = addressLine2 || '';
            eleSuburbPostcode.value = suburbPostcode || '';
            eleName.value = contactName || '';
            elePhone.value = phoneNumber || '';
            eleEmail.value = email || '';
        }
    }
    //Begin: Search Suburb Feature code
    var searchSuburbInput = document.getElementById('suburb-postcode');
    //const SuburbWithLoader = searchSuburb.closest('.loader-placement');
    const suburbSuggestionDiv = document.getElementById('suburb-suggestions-container');
    if (searchSuburbInput) {
        searchSuburbInput.addEventListener('input', handleSearchSuburb);
    }
    function handleSearchSuburb(event) {
        const subUrb = event.target.value;
        if (subUrb.length < 3) {
            suburbSuggestionDiv.innerHTML = '';
            return;
        }
        getSearchSuburbResults(subUrb);
    }
    function getSearchSuburbResults(searchSuburb) {
        let loaderImage = searchSuburbInput.closest('.loader-placement').querySelector('img');
        return new Promise((resolve, reject) => {
            if (loaderImage) {
                loaderImage.style.display = 'block';
            }
            const xhr = new XMLHttpRequest();
            xhr.open('POST', freightmate.ajaxURL);
            xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            xhr.onload = function () {
                if (xhr.status === 200) {
                    const responseData = JSON.parse(xhr.responseText);
                    const suggestions = responseData.data && responseData.data.results ? responseData.data.results : [];
                    suburbSuggestionDiv.innerHTML = ''; // Clear previous suggestions
                    // Loop through suggestions and create list items
                    suggestions.forEach((suggestion, index) => {
                        //Full Address HTML
                        let { name, postcode } = suggestion;
                        let fullSuburbArray = [name, postcode];
                        let fullSuburbHTML = fullSuburbArray.filter(Boolean).join(', ');
                        const listItem = document.createElement('li');
                        listItem.textContent = fullSuburbHTML;
                        listItem.dataset.id = index;
                        listItem.addEventListener('click', function () {
                            const clickedId = this.dataset.id;
                            suburbSuggestionDiv.innerHTML = "";
                            populateSuburbResult(suggestions, clickedId);
                        });
                        suburbSuggestionDiv.appendChild(listItem);
                    });
                    if (loaderImage) {
                        loaderImage.style.display = 'none';
                    }
                    resolve();
                } else {
                    reject(Error('Error fetching suggestions'));
                }
            };
            xhr.onerror = function () {
                reject(Error('Network error'));
            };
            xhr.send(`action=wp_searchSuburb_ajax_action&searchSuburb=${encodeURIComponent(searchSuburb)}`);
        });
    }
    function populateSuburbResult(subUrbData, index) {
        const selectedSuburb = subUrbData[index];
        let { name, postcode } = selectedSuburb;
        let fullSuburbArray = [name, postcode];
        let fullSuburbHTML = fullSuburbArray.filter(Boolean).join(', ');
        searchSuburbInput.value = fullSuburbHTML;
    }
    //End: Search Suburb Feature code
    function validatePhoneNumber(phoneNumber) {
        const phoneRegex = /^(\+?\d{2}[ \-]?)?(((\(?[ \-]?)0?\)?[2|3|7|8]\)?[ \-]*\d{4}[ \-]?\d{4})|(1[ \-]?(300|800|900|902)[ \-]?((\d{6})|(\d{3}[ \-]?\d{3})))|(13[ \-]?([\d \-]{5})|((\(?[ \-]?)0?\)?4[\d \-]{8,10})))$/;
        return phoneRegex.test(phoneNumber);
    }
    // Validation function
    const createConsignmentValidate = function (isToast = true, checkOffers = false) {
        let invalidFieldsMessages = new Set();
        let excludeNames = ['sender-clientId', 'receiver-address', 'authority-to-leave', 'tailgate', 'contact-name', 'address-2', 'email', 'carrier-type'];
        if (document.querySelector('#carrier-type').value == 'CHEAPEST') {
            excludeNames.push('select_offer');
        }
        let is_valid = true;
        document.querySelectorAll('#create-consignment-form input, #create-consignment-form select').forEach(function (element) {
            let value = element.value.trim();
            let type = element.getAttribute('type');
            let placeholder = element.getAttribute('data-name');
            let name = element.getAttribute('name');
            if (excludeNames.includes(name)) {
                return;
            }
            // Check for blank values
            if (type != 'tel' && !value && name != '' && name != null && placeholder != null) {
                invalidFieldsMessages.add(`The ${placeholder} field is required.`);
                //showToast(`The ${placeholder} field is required.`, 'error');
                is_valid = false;
                element.classList.add('freightmate-invalid');
                return;
            } else {
                // Remove error message if value is present
                let errorElement = element.nextElementSibling;
                if (errorElement && errorElement.classList.contains('error-message')) {
                    errorElement.remove();
                }
                element.classList.remove('freightmate-invalid');
            }

            // Specific validation for telephone type
            if (type === 'tel' && value && !validatePhoneNumber(value) && name != '' && name != null && placeholder != null) {
                invalidFieldsMessages.add(`The phone number ${value} is invalid.`);
                is_valid = false;
                element.classList.add('freightmate-invalid'); // Add invalid class if needed for styling
            } else {
                // Remove error message if phone number is valid
                let errorElement = element.nextElementSibling;
                if (errorElement && errorElement.classList.contains('error-message')) {
                    errorElement.remove();
                }
                element.classList.remove('freightmate-invalid'); // Remove invalid class if valid
            }
        });
        //Only one item is allowed for immutable item types.
        if (document.querySelectorAll(".freightmate-wc-items-values-main[data-ismutable='false']")) {
            if (document.querySelectorAll(".freightmate-wc-items-values-main[data-ismutable='false']").length > 1) {
                invalidFieldsMessages.add(`Only one item is allowed for immutable item types.`);
                is_valid = false;
            }
        }
        if (is_valid == false && isToast == true) {
            showToast(invalidFieldsMessages, 'error');
        } else {
            document.getElementById('toast-container').innerHTML = '';
        }
        if (document.querySelector('#carrier-type').value === 'OFFERS') {
            const select_offerElement = document.querySelector('input[name="select_offer"]');
            if (select_offerElement) {
                let value = document.querySelector('input[name="select_offer"]:checked');
                if (!value) {
                    invalidFieldsMessages.add(`The Select Carrier field is required.`);
                    is_valid = false;
                }
            }
        }
        if (is_valid == true) {
            document.querySelector('input#submit-consignment').removeAttribute('disabled');
        }
        return is_valid;
    };

    // Create Consignment code
    const createConsignmentForm = document.querySelector('#create-consignment-form');
    if (createConsignmentForm) {
        const cLoaderImage = document.querySelector('.consignment-submit-wrap img.freightmate-img');
        createConsignmentForm.addEventListener('submit', function (event) {
            event.preventDefault();
            if (!createConsignmentValidate(true)) {
                return false;
            }
            // Serialize the form data
            const formData = new FormData(createConsignmentForm);
            const disabledFields = createConsignmentForm.querySelectorAll(':disabled');
            disabledFields.forEach(field => {
                formData.append(field.name, field.value);
            });
            const urlEncodedData = new URLSearchParams(formData);
            // Add the action parameter
            urlEncodedData.append('action', 'wp_createConsignment_ajax_action');
            document.querySelector('input#submit-consignment').setAttribute('disabled', 'disabled');
            if (cLoaderImage) {
                cLoaderImage.style.display = 'block';
            }
            const xhr = new XMLHttpRequest();
            xhr.open('POST', freightmate.ajaxURL);
            xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            xhr.onload = function () {
                if (xhr.status === 200) {
                    if (cLoaderImage) {
                        cLoaderImage.style.display = 'none';
                    }
                    const responseData = JSON.parse(xhr.responseText);
                    if (responseData.status_code != 200 && responseData.data && responseData.data.validationErrors) {
                        let allMessages = [];
                        if (responseData.data.validationErrors && responseData.data.validationErrors.length > 0) {
                            responseData.data.validationErrors.forEach(error => {
                                allMessages.push(error.message);
                            });
                        }
                        showToast(allMessages, 'error');
                        return false;
                    } else if (responseData.data.code != 200 && responseData.data.code != 201) {
                        showToast([responseData.data.message], 'error');
                    }
                    if (responseData.isCreated == false) {
                        showToast([`Something went wrong while creating consignment. Please try again.`], 'error');
                    } else {
                        showToast([`Your consignment has been created with Connote No: ${responseData.data.connoteNumber}`], 'success');
                        setTimeout(function () {
                            window.location.href = freightmate.redirect.orders;
                        }, 2000);
                    }

                } else {
                    showToast([`Something went wrong while creating consignment. Please try again.`], 'error');
                    return false;
                }
                document.querySelector('input#submit-consignment').removeAttribute('disabled');
            };
            xhr.onerror = function () {
                showToast([`Network error`], 'error');
                return false;
            };
            xhr.send(urlEncodedData);
        });
    }

    function createOfferHTML(offers) {
        let carrierOpts = '';
        offers.forEach(function (offer, index) {
            const carrierName = offer.carrierDetails.carrierName.replace(/_/g, ' ').replace(/\w\S*/g, function (txt) { return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase(); });
            const carrierSlug = offer.carrierDetails.carrierName;
            const serviceTypeSlug = offer.carrierDetails.serviceTypeName;
            const carrierImage = freightmate.images + 'carriers/' + carrierSlug + '.png';
            // const serviceTypeName = offer.carrierDetails.serviceTypeName.replace(/_/g, ' ').replace(/\w\S*/g, function (txt) { return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase(); });
            const serviceTypeName = offer.carrierDetails.serviceTypeDisplayName;
            let bookingCutoff = offer.carrierDetails.cutOffDay == 0 ? freighmateCurrentDate() : offer.carrierDetails.cutOffDay;
            let etaDays = offer.carrierDetails.etaDays == null ? 'N/A' : offer.carrierDetails.etaDays;
            let cutOffTime = offer.carrierDetails.cutOffTime;
            const selected_offer = carrierSlug + '#' + serviceTypeSlug;
            carrierOpts += '<div class="freightmate-carrier-item offer-row">' +
                '<div class="offer-option">' +
                '<div class="freighmate-service-select">' +
                '<label class="freightmate-checkbox">' +
                '<input type="radio" name="select_offer" data-name="Select Offer" value="' + selected_offer + '">' +
                '<span class="freightmate-checkmark"></span></label>' +
                '</div>' +
                '<div class="freighmate-service-name">' +
                '<div class="col service-type">' +
                '<p>' + serviceTypeName + '</p>' +
                '</div>' +
                '</div>' +
                '<div class="freighmate-carrierName-name">' +
                '<div class="col service-type">' +
                '<img src="' + carrierImage + '"/>' +
                '</div>' +
                '</div>' +
                '<div class="estimated-arrival">' +
                '<div class="freightmate-flex-col">' +
                '<p>Booking cutoff:</p>' +
                '<p class="freightmate-text-bold">' + bookingCutoff + '</p>' +
                '<p class="freightmate-text-bold">' + cutOffTime + '</p>' +
                '</div>' +
                '</div>' +
                '<div class="estimated-arrival">' +
                '<div class="freightmate-flex-col">' +
                '<p>Estimated arrival:</p>' +
                '<p class="freightmate-text-bold">' + etaDays + '</p>' +
                '</div>' +
                '</div>' +
                '<div class="freightmate-carrier-cost">' +
                '<div class="freightmate-flex-col">' +
                '<p class="total-cost"><span class="dollar-sign">$</span><span>' + offer.costs.totalCost + '</span></p>' +
                '<p class="total-cost-desc">Total Inc. Fuel &amp; GST</p>' +
                '</div>' +
                '</div>' +
                '</div>' +
                '</div>';
        });
        return carrierOpts;
    }
    const selectElements = document.querySelectorAll('#create-consignment-form select');
    const textInputs = document.querySelectorAll('#create-consignment-form input');
    textInputs.forEach(input => input.addEventListener('input', () => createConsignmentValidate(false, true)));
    selectElements.forEach(select => select.addEventListener('change', () => createConsignmentValidate(false, true)));
    const loaderImage = document.querySelector('img.freightmate-img');
    //Offer calculate
    let offerbtnSelector = "#calculate-carrier";
    if (document.querySelector(offerbtnSelector)) {
        document.querySelector(offerbtnSelector).addEventListener('click', function () {
            document.querySelector('div#freightmate-carrier-items').innerHTML = '';
            const selectedValue = document.querySelector('#carrier-type').value;  //this.value;
            const is_valid = createConsignmentValidate(true, false);
            console.log('is_valid', is_valid);
            if (selectedValue != 'OFFERS' || is_valid == false) {
                return;
            }
            // Serialize the form data
            const formData = new FormData(createConsignmentForm);
            const disabledFields = createConsignmentForm.querySelectorAll(':disabled');
            disabledFields.forEach(field => {
                formData.append(field.name, field.value);
            });
            const urlEncodedData = new URLSearchParams(formData);
            // Add the action parameter
            urlEncodedData.append('action', 'wp_checkOffers_ajax_action');
            return new Promise((resolve, reject) => {
                if (loaderImage) {
                    loaderImage.style.display = 'block';
                }
                const xhr = new XMLHttpRequest();
                xhr.open('POST', freightmate.ajaxURL);
                xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                xhr.onload = function () {
                    if (xhr.status === 200) {
                        const responseData = JSON.parse(xhr.responseText);
                        if (responseData.status_code != 200 && responseData.data && responseData.data.validationErrors) {
                            let allMessages = [];
                            if (responseData.data.validationErrors && responseData.data.validationErrors.length > 0) {
                                responseData.data.validationErrors.forEach(error => {
                                    allMessages.push(error.message);
                                });
                            }
                            showToast(allMessages, 'error');
                            if (loaderImage) {
                                loaderImage.style.display = 'none';
                            }
                            return false;
                        }
                        if (responseData.status_code == 200 && responseData.data) {
                            const offers = responseData.data.offers;
                            let offerHTML = createOfferHTML(offers);
                            document.querySelector('div#freightmate-carrier-items').innerHTML = offerHTML;
                            if (selectedValue === 'OFFERS') {
                                document.querySelector('input#submit-consignment').removeAttribute('disabled');
                            }
                        }
                        //const responseData = JSON.parse(xhr.responseText);
                        resolve();
                    } else {
                        reject(Error('Error fetching suggestions'));
                    }
                    if (loaderImage) {
                        loaderImage.style.display = 'none';
                    }
                    return false;
                };
                xhr.onerror = function () {
                    if (loaderImage) {
                        loaderImage.style.display = 'none';
                    }
                    reject(Error('Network error'));
                };
                xhr.send(urlEncodedData.toString());
                return false;
            });
        });
    }
    if (document.querySelector('#carrier-type')) {
        document.querySelector('#carrier-type').addEventListener('change', function () {
            const selectedValue = this.value;
            if (selectedValue == 'OFFERS') {
                jQuery('#calculate-carrier').trigger('click');
            }
        });
    }
    // if (document.querySelector('#carrier-type')) {
    //     document.querySelector('#carrier-type').addEventListener('change', function () {
    //         document.querySelector('div#freightmate-carrier-items').innerHTML = '';
    //         const selectedValue = this.value;
    //         const is_valid = createConsignmentValidate();
    //         console.log('is_valid', is_valid);
    //         if (selectedValue != 'OFFERS' || is_valid == false) {
    //             return;
    //         }
    //         // Serialize the form data
    //         const formData = new FormData(createConsignmentForm);
    //         const disabledFields = createConsignmentForm.querySelectorAll(':disabled');
    //         disabledFields.forEach(field => {
    //             formData.append(field.name, field.value);
    //         });
    //         const urlEncodedData = new URLSearchParams(formData);
    //         // Add the action parameter
    //         urlEncodedData.append('action', 'wp_checkOffers_ajax_action');
    //         return new Promise((resolve, reject) => {
    //             if (loaderImage) {
    //                 loaderImage.style.display = 'block';
    //             }
    //             const xhr = new XMLHttpRequest();
    //             xhr.open('POST', freightmate.ajaxURL);
    //             xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    //             xhr.onload = function () {
    //                 if (xhr.status === 200) {
    //                     const responseData = JSON.parse(xhr.responseText);
    //                     if (responseData.status_code != 200 && responseData.data && responseData.data.validationErrors) {
    //                         let allMessages = [];
    //                         if (responseData.data.validationErrors && responseData.data.validationErrors.length > 0) {
    //                             responseData.data.validationErrors.forEach(error => {
    //                                 allMessages.push(error.message);
    //                             });
    //                         }
    //                         showToast(allMessages, 'error');
    //                         return false;
    //                     }
    //                     if (responseData.status_code == 200 && responseData.data) {
    //                         const offers = responseData.data.offers;
    //                         let offerHTML = createOfferHTML(offers);
    //                         document.querySelector('div#freightmate-carrier-items').innerHTML = offerHTML;
    //                         if (selectedValue === 'OFFERS') {
    //                             document.querySelector('input#submit-consignment').removeAttribute('disabled');
    //                         }
    //                     }
    //                     //const responseData = JSON.parse(xhr.responseText);
    //                     if (loaderImage) {
    //                         loaderImage.style.display = 'none';
    //                     }
    //                     resolve();
    //                 } else {
    //                     reject(Error('Error fetching suggestions'));
    //                 }
    //                 return false;
    //             };
    //             xhr.onerror = function () {
    //                 reject(Error('Network error'));
    //             };
    //             xhr.send(urlEncodedData.toString());
    //             return false;
    //         });
    //     });
    // }
    //Item type Dimentions
    if (document.querySelector('#freightmate_item_type')) {
        document.querySelector('#freightmate_item_type').addEventListener('change', function () {
            //document.querySelector('.freightmate-dimentions-fields').innerHTML = '';
            const selectedValue = this.value;
            const post_id = document.getElementById('post_ID').value;
            const postData = {
                action: 'wp_populate_dimentions_ajax_action',
                item_id: selectedValue,
                post_id: post_id
            };
            const urlEncodedData = new URLSearchParams(postData).toString();
            return new Promise((resolve, reject) => {
                if (document.querySelector('.freightmate-product-config img.freightmate-img')) {
                    document.querySelector('.freightmate-product-config img.freightmate-img').style.display = 'inline-block';
                }
                const xhr = new XMLHttpRequest();
                xhr.open('POST', freightmate.ajaxURL);
                xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                xhr.onload = function () {
                    const responseData = JSON.parse(xhr.responseText);
                    if (xhr.status === 200) {
                        if (responseData.data) {
                            document.querySelector('.freightmate-dimentions-fields').innerHTML = responseData.data;

                        }
                        if (document.querySelector('.freightmate-product-config img.freightmate-img')) {
                            document.querySelector('.freightmate-product-config img.freightmate-img').style.display = 'none';
                        }
                        resolve();
                    } else {
                        reject(Error('Error fetching suggestions'));
                    }
                    return false;
                };
                xhr.onerror = function () {
                    reject(Error('Network error'));
                };
                xhr.send(urlEncodedData);
                return false;
            });
        })
    }
    if (document.querySelector('#freightmate_item_type')) {
        document.querySelector('#freightmate_item_type').addEventListener('change', function () {
            const item_id = this.value;
            if (document.querySelector('.freightmate-product-config img.freightmate-img')) {
                document.querySelector('.freightmate-product-config img.freightmate-img').style.display = 'inline-block';
            }
            if (freightmate.items) {
                let myItems = freightmate.items;
                myItems = myItems.filter((value) => value.id == item_id);
                myItems = myItems.length > 0 ? myItems[0] : null;
                console.log('====================================');
                console.log('myItems', myItems);
                console.log('====================================');
                if (myItems) {
                    const isMutable = myItems.isMutable;
                    const itemLength = document.querySelector(`input[name="freightmate_product_length"]`);
                    const height = document.querySelector(`input[name="freightmate_product_height"]`);
                    const weight = document.querySelector(`input[name="freightmate_product_weight"]`);
                    const width = document.querySelector(`input[name="freightmate_product_width"]`);
                    // Set values with default of 0 if not found
                    console.log('myItems.itemTemplate?.length', myItems.itemTemplate?.length);
                    
                    if (itemLength) itemLength.value = myItems.itemTemplate?.length || 0;
                    if (height) height.value = myItems.itemTemplate?.height || 0;
                    if (weight) weight.value = myItems.itemTemplate?.weight || 0;
                    if (width) width.value = myItems.itemTemplate?.width || 0;

                    // Disable or enable elements based on isMutable
                    if (itemLength) itemLength.disabled = !isMutable;
                    if (height) height.disabled = !isMutable;
                    if (weight) weight.disabled = !isMutable;
                    if (width) width.disabled = !isMutable;
                }
            }
            if (document.querySelector('.freightmate-product-config img.freightmate-img')) {
                document.querySelector('.freightmate-product-config img.freightmate-img').style.display = 'none';
            }
        })
    }
    if( document.getElementById('freightmate-items-container') ){
        document.getElementById('freightmate-items-container').addEventListener('change', function(event) {
            if (event.target && event.target.matches('select[data-name="Items"]')) {
                if (event.target && event.target.matches('.freightmate-select select[data-name="Items"]')) {
                    const select = event.target;
                    const item_id = select.value;
                    const targetId = select.getAttribute('data-targetId');
            
                    const imgElement = document.querySelector('.freightmate-product-config img.freightmate-img');
                    if (imgElement) {
                        imgElement.style.display = 'inline-block';
                    }
            
                    if (freightmate.items) {
                        let myItems = freightmate.items;
                        myItems = myItems.filter((value) => value.id == item_id);
                        myItems = myItems.length > 0 ? myItems[0] : null;
                        console.log(myItems);
            
                        if (myItems) {
                            const isMutable = myItems.isMutable;
                            const itemLength = document.querySelector(`input[name="item-type[${targetId}][length]"]`);
                            const height = document.querySelector(`input[name="item-type[${targetId}][height]"]`);
                            const weight = document.querySelector(`input[name="item-type[${targetId}][weight]"]`);
                            const width = document.querySelector(`input[name="item-type[${targetId}][width]"]`);
                            const itemTypeName = document.querySelector(`input[name="item-type[${targetId}][itemTypeName]"]`);
                            const dataImutable = document.querySelector(`.freightmate-wc-items-values-main[data-item='${targetId}']`);
                            console.log(myItems.type);
            
                            if (dataImutable) {
                                dataImutable.setAttribute('data-ismutable', isMutable);
                            }
            
                            // Set values with default of 0 if not found
                            if (itemLength) itemLength.value = myItems.itemTemplate?.length || '';
                            if (height) height.value = myItems.itemTemplate?.height || '';
                            if (weight) weight.value = myItems.itemTemplate?.weight || '';
                            if (width) width.value = myItems.itemTemplate?.width || '';
                            if (itemTypeName) itemTypeName.value = myItems?.type || '';
            
                            // Disable or enable elements based on isMutable
                            if (itemLength) itemLength.disabled = !isMutable;
                            if (height) height.disabled = !isMutable;
                            if (weight) weight.disabled = !isMutable;
                            if (width) width.disabled = !isMutable;
                        }
                    }
            
                    if (imgElement) {
                        imgElement.style.display = 'none';
                    }
                }
            }
        });
        document.getElementById('freightmate-items-container').addEventListener('click', function (event) {
            // Check if the clicked element or its child is the delete icon
            if (event.target && (event.target.matches('.freightmate-delete-item') || event.target.closest('.freightmate-delete-item'))) {
                // Find the closest .freightmate-wc-items-values-main to remove
                const itemToRemove = event.target.closest('.freightmate-wc-items-values-main');
                if (itemToRemove) {
                    itemToRemove.remove();
                    console.log('Item removed:', itemToRemove.getAttribute('data-item'));
                }
            }
        });
    }
    
    //Item type Dimentions update on create consignment module when change item Types
    const itemsSelects = document.querySelectorAll('.freightmate-select select[data-name="Items"]');
    if (itemsSelects.length > 0) {
        itemsSelects.forEach(select => {
            select.addEventListener('change', function () {
                const item_id = this.value;
                const targetId = this.getAttribute('data-targetId');

                if (document.querySelector('.freightmate-product-config img.freightmate-img')) {
                    document.querySelector('.freightmate-product-config img.freightmate-img').style.display = 'inline-block';
                }

                if (freightmate.items) {
                    let myItems = freightmate.items;
                    myItems = myItems.filter((value) => value.id == item_id);
                    myItems = myItems.length > 0 ? myItems[0] : null;
                    console.log(myItems);

                    if (myItems) {
                        const isMutable = myItems.isMutable;
                        const itemLength = document.querySelector(`input[name="item-type[${targetId}][length]"]`);
                        const height = document.querySelector(`input[name="item-type[${targetId}][height]"]`);
                        const weight = document.querySelector(`input[name="item-type[${targetId}][weight]"]`);
                        const width = document.querySelector(`input[name="item-type[${targetId}][width]"]`);
                        const itemTypeName = document.querySelector(`input[name="item-type[${targetId}][itemTypeName]"]`);
                        const dataImutable = document.querySelector(`.freightmate-wc-items-values-main[data-item='${targetId}']`);
                        console.log(myItems.type);
                        if (dataImutable) {
                            dataImutable.setAttribute('data-ismutable', isMutable);
                        }

                        // Set values with default of 0 if not found
                        if (itemLength) itemLength.value = myItems.itemTemplate?.length || '';
                        if (height) height.value = myItems.itemTemplate?.height || '';
                        if (weight) weight.value = myItems.itemTemplate?.weight || '';
                        if (width) width.value = myItems.itemTemplate?.width || '';
                        if (itemTypeName) itemTypeName.value = myItems?.type || '';

                        // Disable or enable elements based on isMutable
                        if (itemLength) itemLength.disabled = !isMutable;
                        if (height) height.disabled = !isMutable;
                        if (weight) weight.disabled = !isMutable;
                        if (width) width.disabled = !isMutable;
                    }
                }

                if (document.querySelector('.freightmate-product-config img.freightmate-img')) {
                    document.querySelector('.freightmate-product-config img.freightmate-img').style.display = 'none';
                }
            });
        });
    }

    // const itemsSelects = document.querySelectorAll('.freightmate-select select[data-name="Items"]');
    // if (itemsSelects.length > 0) {
    //     itemsSelects.forEach(select => {
    //         select.addEventListener('change', function () {
    //             const selectedValue = this.value;
    //             const targetId = this.getAttribute('data-targetId');
    //             const item_id = this.getAttribute('data-itemtId');
    //             const post_id = this.getAttribute('data-productId');
    //             const postData = {
    //                 action: 'item_update_dimentions_ajax_action',
    //                 item_id: selectedValue,
    //                 post_id: post_id
    //             };
    //             const urlEncodedData = new URLSearchParams(postData).toString();

    //             return new Promise((resolve, reject) => {
    //                 if (document.querySelector('.freightmate-product-config img.freightmate-img')) {
    //                     document.querySelector('.freightmate-product-config img.freightmate-img').style.display = 'inline-block';
    //                 }
    //                 const xhr = new XMLHttpRequest();
    //                 xhr.open('POST', freightmate.ajaxURL);
    //                 xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
    //                 xhr.onload = function () {
    //                     if (xhr.status === 200) {
    //                         const responseData = JSON.parse(xhr.responseText);
    //                         console.log('responseData', responseData);
    //                         if (responseData.data) {
    //                             const isMutable = responseData.data.isMutable;
    //                             const itemLength = document.querySelector(`input[name="item-type[${targetId}][length]"]`);
    //                             const height = document.querySelector(`input[name="item-type[${targetId}][height]"]`);
    //                             const weight = document.querySelector(`input[name="item-type[${targetId}][weight]"]`);
    //                             const width = document.querySelector(`input[name="item-type[${targetId}][width]"]`);
    //                             const itemTypeName = document.querySelector(`input[name="item-type[${targetId}][itemTypeName]"]`);
    //                             const dataImutable = document.querySelector(`.freightmate-wc-items-values-main[data-item='${targetId}']`);
    //                             if (dataImutable) {
    //                                 dataImutable.setAttribute('data-ismutable', isMutable);
    //                             }
    //                             // Set values if elements exist
    //                             if (itemLength) itemLength.value = responseData.data.length;
    //                             if (height) height.value = responseData.data.height;
    //                             if (weight) weight.value = responseData.data.weight;
    //                             if (width) width.value = responseData.data.width;
    //                             if (itemTypeName) itemTypeName.value = responseData.data.itemTypeName;

    //                             // Disable or enable elements based on isMutable
    //                             if (itemLength) itemLength.disabled = !isMutable;
    //                             if (height) height.disabled = !isMutable;
    //                             if (weight) weight.disabled = !isMutable;
    //                             if (width) width.disabled = !isMutable;
    //                         }

    //                         if (document.querySelector('.freightmate-product-config img.freightmate-img')) {
    //                             document.querySelector('.freightmate-product-config img.freightmate-img').style.display = 'none';
    //                         }
    //                         resolve();
    //                     } else {
    //                         reject(Error('Error fetching suggestions'));
    //                     }
    //                 };
    //                 xhr.onerror = function () {
    //                     reject(Error('Network error'));
    //                 };
    //                 xhr.send(urlEncodedData);
    //             });
    //         });
    //     });
    // }
    // Confirmation Diolog script
    function showConfirmationDialog(message, onConfirm, onCancel) {
        const dialog = document.getElementById('freightmate-confirmationDialog');
        const dialogMessage = document.getElementById('freightmate-dialogMessage');
        const confirmBtn = document.getElementById('freightmate-confirmBtn');
        const cancelBtn = document.getElementById('freightmate-cancelBtn');

        dialogMessage.textContent = message;

        const closeDialog = () => {
            dialog.style.display = 'none';
            confirmBtn.removeEventListener('click', handleConfirm);
            cancelBtn.removeEventListener('click', handleCancel);
        };

        const handleConfirm = () => {
            onConfirm();
            closeDialog();
        };

        const handleCancel = () => {
            if (onCancel) onCancel();
            closeDialog();
        };

        confirmBtn.addEventListener('click', handleConfirm);
        cancelBtn.addEventListener('click', handleCancel);

        dialog.style.display = 'flex';
    }

    //Delete Account event functions
    if (document.getElementById('uninstall-freightmate')) {
        document.getElementById('uninstall-freightmate').addEventListener('click', () => {
            showConfirmationDialog(
                'Are you sure you want to proceed?',
                () => {
                    console.log('Confirmed');
                    document.getElementById('freightmate_uninstall_form').submit();
                },
                () => {
                    console.log('Cancelled');
                }
            );
        });
    }

    //For woo dreafult shiping option uncheck
    const wooDefaultCheckbox = document.querySelector('input[name="woo_defaultshipping"]');
    const wooCommerceRadio = document.querySelector('input[value="woocommerce_default"]');

    if (wooDefaultCheckbox && wooCommerceRadio) {
        wooDefaultCheckbox.addEventListener('change', function() {
            if (this.checked) {
                wooCommerceRadio.checked = false; // uncheck WooCommerce Calculated
            }
        });

        // Optional: If WooCommerce Calculated is selected, uncheck the Woo Default checkbox
        wooCommerceRadio.addEventListener('change', function() {
            if (this.checked) {
                wooDefaultCheckbox.checked = false;
            }
        });
    }


});
