// Check if pdfData is defined and call the download function
if (typeof pdfData !== 'undefined') {
    downloadPdf(pdfData.pdfContent, pdfData.fileName);
}

function downloadPdf(pdfBase64, fileName) {
    const linkSource = `data:application/pdf;base64,${pdfBase64}`;
    const downloadLink = document.createElement('a');
    downloadLink.href = linkSource;
    downloadLink.download = fileName + ".pdf";
    
    // Trigger the download
    document.body.appendChild(downloadLink);
    downloadLink.click();
    document.body.removeChild(downloadLink); // Clean up
}