<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 
class Freightmate_wp_hooks
{
    public function __construct()
    {
        add_action('wp_enqueue_scripts', [$this, 'freighmate_wp_enqueue_script']);
        add_filter('woocommerce_package_rates', [$this, 'custom_woocommerce_shipping_display'], 10, 2);
        add_action('woocommerce_after_order_notes', [$this, 'freightmate_custom_checkout_field']);
        add_action('woocommerce_checkout_process', [$this, 'freightmate_custom_checkout_field_process']);
        add_action('woocommerce_checkout_update_order_meta', [$this, 'freightmate_custom_checkout_field_update_order_meta']);
        add_action('woocommerce_admin_order_data_after_billing_address', [$this, 'freightmate_custom_checkout_field_display_admin_order_meta'], 10, 1);
        add_filter('woocommerce_email_order_meta_fields', [$this, 'freightmate_custom_checkout_field_email_order_meta_fields'], 10, 3);
    }
    public function freighmate_wp_enqueue_script()
    {
        if (is_checkout() || is_cart()) {
            wp_enqueue_script('freightmate-front-script', FREIGHTMATE_APP_PLUGIN_URL . '/js/freightmate-front-script.js', array('jquery'), time(), true);
            wp_localize_script('freightmate-front-script', 'freightmate', array(
                'ajax_url' => admin_url('admin-ajax.php'),
            ));
        }
    }
/*    public function custom_woocommerce_shipping_display($rates, $package)
    {
        $cost = freightmateCommonMethods::calculateShipingCharges();
        $freightmate_shipping = get_option(FREIGHTMATE_OPTION_PREFIX . 'freightmate_shipping');
        $freightmate_shipping_charges = get_option(FREIGHTMATE_OPTION_PREFIX . 'freightmate_shipping_charges');
        $freightmate_shipping_charges = intval($freightmate_shipping_charges);
        $allowed = ['freightmate_percentage', 'freightmate_flat', 'freightmate_default'];
        if (in_array($freightmate_shipping, $allowed) && $cost !== NULL) {
            // Clear existing rates
            $rates = array();
            if ($freightmate_shipping == 'freightmate_percentage') {
                $percentageAmount = $cost * ($freightmate_shipping_charges / 100);
                $cost = $cost + $percentageAmount;
            }
            if ($freightmate_shipping == 'freightmate_flat') {
                $cost = $cost + $freightmate_shipping_charges;
            }
            // Add custom shipping rate
            $custom_rate = array(
                'id'    => 'freightmate_shipping',
                'label' => 'Freightmate Shipping',
                'cost'  => $cost,
                'package' => $package,
            );

            // Add the custom rate to the rates array
            $rates['freightmate_shipping'] = new WC_Shipping_Rate(
                $custom_rate['id'],
                $custom_rate['label'],
                $custom_rate['cost'],
                array(),
                'freightmate_shipping'
            );
        }
        return $rates;
    }*/

// public function custom_woocommerce_shipping_display($rates, $package)
// {
//     // Get offers from Freightmate API
//     $offers = freightmateCommonMethods::calculateShipingCharges();

//     // If offers are empty, return default WooCommerce shipping methods
//     if (empty($offers)) {
//         return $rates;
//     }

//     // Clear existing rates
//     $rates = array();
//     $lowest_price = PHP_INT_MAX; // Set to a very high number to find the lowest price
//     $default_rate_id = ''; // Will store the rate id of the lowest price option

//     // If offers exist, add them as separate rates
//     foreach ($offers as $offer) {
//         // Extract details from the offer
//         $carrier_name = $offer['carrierDetails']['carrierDisplayName'] ?? 'Freightmate Shipping';
//         $service_type = $offer['carrierDetails']['serviceTypeDisplayName'] ?? 'Standard Service';
//         $offer_price = $offer['costs']['totalCost'] ?? 0;

//         // Apply additional charges if necessary (percentage/flat)
//         $freightmate_shipping = get_option(FREIGHTMATE_OPTION_PREFIX . 'freightmate_shipping');
//         $freightmate_shipping_charges = get_option(FREIGHTMATE_OPTION_PREFIX . 'freightmate_shipping_charges');
//         $freightmate_shipping_charges = intval($freightmate_shipping_charges);

//         if ($freightmate_shipping == 'freightmate_percentage') {
//             $percentageAmount = $offer_price * ($freightmate_shipping_charges / 100);
//             $offer_price = $offer_price + $percentageAmount;
//         }

//         if ($freightmate_shipping == 'freightmate_flat') {
//             $offer_price = $offer_price + $freightmate_shipping_charges;
//         }

//         // Track lowest price rate
//         if ($offer_price < $lowest_price) {
//             $lowest_price = $offer_price;
//             $default_rate_id = 'freightmate_shipping_' . $carrier_name . '_' . $service_type;
//         }

//         // Prepare custom rate information
//         $custom_rate = array(
//             'id'    => 'freightmate_shipping_' . $carrier_name . '_' . $service_type,
//             'label' => $carrier_name . ' - ' . $service_type,
//             'cost'  => $offer_price,
//             'package' => $package,
//         );

//         // Add the custom rate to the rates array
//         $rates['freightmate_shipping_' . $carrier_name . '_' . $service_type] = new WC_Shipping_Rate(
//             $custom_rate['id'],
//             $custom_rate['label'],
//             $custom_rate['cost'],
//             array(),
//             'freightmate_shipping'
//         ); 
//     }

//     return $rates;
// }

    public function custom_woocommerce_shipping_display($rates, $package)
    {  
        // Get Freightmate shipping type setting (percentage, flat, or default)
        $freightmate_shipping = get_option(FREIGHTMATE_OPTION_PREFIX . 'freightmate_shipping');
        $woo_defaultshipping  = get_option(FREIGHTMATE_OPTION_PREFIX . 'woo_defaultshipping', 0);

        // If admin has selected 'woocommerce_default', return original WooCommerce rates
        if ($freightmate_shipping === 'woocommerce_default') { 
            return $rates;
        }

        // Get offers from Freightmate API
        $offers = freightmateCommonMethods::calculateShipingCharges();

        // If offers are empty, return default WooCommerce shipping methods
        if (empty($offers)) {
            return $rates;
        }

        // Keep WooCommerce default rates and append Freightmate rates
        $freightmate_rates = array();

        // Add each Freightmate offer as a shipping option
        foreach ($offers as $offer) {
            $carrier_name = $offer['carrierDetails']['carrierDisplayName'] ?? 'Freightmate Shipping';
            $service_type = $offer['carrierDetails']['serviceTypeDisplayName'] ?? 'Standard Service';
            $offer_price = $offer['costs']['totalCost'] ?? 0;

            // Get additional charges from backend setting
            $freightmate_shipping_charges = intval(get_option(FREIGHTMATE_OPTION_PREFIX . 'freightmate_shipping_charges'));

            if ($freightmate_shipping === 'freightmate_percentage') {
                $percentageAmount = $offer_price * ($freightmate_shipping_charges / 100);
                $offer_price += $percentageAmount;
            }

            if ($freightmate_shipping === 'freightmate_flat') {
                $offer_price += $freightmate_shipping_charges;
            }

            // Create rate ID and shipping label
            $rate_id = 'freightmate_shipping_' . sanitize_title($carrier_name . '_' . $service_type);

            $freightmate_rates[$rate_id] = new WC_Shipping_Rate(
                $rate_id,
                $carrier_name . ' - ' . $service_type,
                $offer_price,
                array(),
                'freightmate_shipping'
            );
        }

        //  If Woo Default Shipping is enabled → merge both
        if ($woo_defaultshipping) {
            return array_merge($rates, $freightmate_rates);
        }

        //  Otherwise, only show Freightmate rates
        return $freightmate_rates;

        // Merge WooCommerce default + Freightmate rates
       // return array_merge($rates, $freightmate_rates);
    }




    public function freightmate_custom_checkout_field($checkout)
    {
        echo '<div id="freightmate_custom_checkout_field">';
        woocommerce_form_field('authority_to_leave', array(
            'type' => 'checkbox',
            'class' => array('form-row-wide'),
            'label' => __('Authority to leave', 'freightmate-for-woocommerce'),
            'required' => false,
        ), $checkout->get_value('authority_to_leave'));
        echo '</div>';
    }
    public function freightmate_custom_checkout_field_process()
    {
        if (!isset($_POST['authority_to_leave'])) {
            $_POST['authority_to_leave'] = 0; // Set to 0 if not checked
        }
    }
    public function freightmate_custom_checkout_field_update_order_meta($order_id)
    {
        if (isset($_POST['authority_to_leave'])) {
            update_post_meta($order_id, 'authority_to_leave', sanitize_text_field(wp_unslash($_POST['authority_to_leave'])));
        }
    }
    public function freightmate_custom_checkout_field_display_admin_order_meta($order)
    {
        $authority_to_leave = get_post_meta($order->get_id(), 'authority_to_leave', true);
        if ($authority_to_leave) {
            echo '<p><strong>' . esc_html_e('Authority to leave', 'freightmate-for-woocommerce') . ':</strong> ' . ($authority_to_leave ? 'Yes' : 'No') . '</p>';
        }
    }
    public function freightmate_custom_checkout_field_email_order_meta_fields($fields, $sent_to_admin, $order)
    {
        $authority_to_leave = get_post_meta($order->get_id(), 'authority_to_leave', true);
        if ($authority_to_leave) {
            $fields['authority_to_leave'] = array(
                'label' => __('Authority to leave', 'freightmate-for-woocommerce'),
                'value' => $authority_to_leave ? 'Yes' : 'No',
            );
        }
        return $fields;
    }
}
new Freightmate_wp_hooks;
