<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 
class Freightmate_Product_Configuration implements Freightmate_Product_Configuration_Interface
{

    public function __construct()
    {
        // Hook into WooCommerce actions
        add_action('woocommerce_product_options_shipping', [$this, 'addFields']);
        add_action('woocommerce_process_product_meta', [$this, 'saveFields']);
        add_action('woocommerce_admin_process_product_object', [$this, 'loadFields']);
    }

    public function addFields()
    {
        global $post;
        $post_id = $post->ID;
        $freightmate_item_type = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'item_type', true);
        $is_tailgate = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_tailgate', true);
        $items = freightmateCommonMethods::getItems();
        $isMutable = true;
        $itemTypeName = '';
        $length = $width = $height = $weight = 0;
        $freightmate_item_type = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'item_type', true) ?? '';
        if ($freightmate_item_type && $isMutable === true) {
            $weight = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_weight', true) ?? 0;
            $length = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_length', true) ?? 0;
            $width = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_width', true) ?? 0;
            $height = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_height', true) ?? 0;
            $isMutable = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_isMutable', true) ?? true;
            $itemTypeName = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_item_type_name', true) ?? '';
        } elseif ($freightmate_item_type && $isMutable === false) {
            $itemData = freightmateCommonMethods::getItems($freightmate_item_type);
            $length = $itemData['itemTemplate']['length'] ?? 0;
            $width = $itemData['itemTemplate']['width'] ?? 0;
            $height = $itemData['itemTemplate']['height'] ?? 0;
            $weight = $itemData['itemTemplate']['weight'] ?? 0;
            $isMutable = $itemData['isMutable'] ?? true;
            $itemTypeName = $itemData['type'] ?? '';
        }
        $item_opts = '';
        
?>
        <div class="freightmate-product-config">
            <hr>
            <h4>Freightmate product configuration</h4>
            <div class="freightmate-product-config-fields">
                <p class=" form-field freightmate_item_type_field">
                    <label for="freightmate_item_type">Item Type</label>
                    <select id="freightmate_item_type" name="freightmate_item_type" class="select short">
                        <?php 
                            if ($items) {
                                ?><option value="">Select Item</option><?php
                                foreach ($items as $item) {
                                    $id = isset($item['id']) ? $item['id'] : '';
                                    $itemName = isset($item['type']) && $item['type'] ? $item['type'] : '';
                                    if (!isset($item['type']) && $itemName == '' && isset($item['name'])) {
                                        $itemName = $item['name'];
                                    }
                                    if ($id && $itemName) {
                                    
                                        if( $freightmate_item_type == $id ){
                                            ?><option value="<?php echo esc_html($id); ?>" selected ><?php echo esc_html($itemName); ?></option><?php
                                        }
                                        else{
                                            ?><option value="<?php echo esc_html($id); ?>" ><?php echo esc_html($itemName); ?></option><?php
                                        }
                                        
                                    }
                                }
                            }
                        ?>
                    </select>
                    <img class="freightmate-img img-w-40" src="<?php echo esc_html(FREIGHTMATE_APP_PLUGIN_URL) . '/images/freightmate-ajax-loader.gif' ?>" style="display: none;">
                </p>
                <div class="freightmate-dimentions-fields">
                    <?php if ($freightmate_item_type) {
                        if ($isMutable == true) { ?>
                            <p class="form-field _weight_field ">
                                <label for="freightmate_product_weight">Weight (kg)</label><input type="text" class="short wc_input_decimal" name="freightmate_product_weight" id="freightmate_product_weight" value="<?php echo esc_html($weight); ?>" placeholder="Weight">
                            </p>
                            <p class="form-field dimensions_field">
                                <label for="freightmate_product_length">
                                    Dimensions (mtr) </label>
                                <span class="wrap">
                                    <input id="freightmate_product_length" placeholder="Length" class="input-text wc_input_decimal" size="6" type="text" name="freightmate_product_length" value="<?php echo esc_html($length); ?>">
                                    <input id="product_width" placeholder="Width" class="input-text wc_input_decimal" size="6" type="text" name="freightmate_product_width" value="<?php echo esc_html($width); ?>">
                                    <input id="product_height" placeholder="Height" class="input-text wc_input_decimal last" size="6" type="text" name="freightmate_product_height" value="<?php echo esc_html($height); ?>">
                                    <input type="hidden" name="freightmate_isMutable" value="<?php echo esc_html($isMutable); ?>">
                                    <input type="hidden" name="freightmate_product_item_type_name" value="<?php echo esc_html($itemTypeName); ?>">
                                </span>
                            </p>
                        <?php } else { ?>
                            <p class="form-field _weight_field ">
                                <label for="freightmate_product_weight">Weight (kg)</label><input type="text" class="short wc_input_decimal" name="freightmate_product_weight" id="freightmate_product_weight" value="<?php echo esc_html($weight); ?>" placeholder="Weight" disabled>
                            </p>
                            <p class="form-field dimensions_field">
                                <label for="freightmate_product_length">
                                    Dimensions (mtr) </label>
                                <span class="wrap">
                                    <input id="freightmate_product_length" placeholder="Length" class="input-text wc_input_decimal" size="6" type="text" name="freightmate_product_length" value="<?php echo esc_html($length); ?>" disabled>
                                    <input id="product_width" placeholder="Width" class="input-text wc_input_decimal" size="6" type="text" name="freightmate_product_width" value="<?php echo esc_html($width); ?>" disabled>
                                    <input id="product_height" placeholder="Height" class="input-text wc_input_decimal last" size="6" type="text" name="freightmate_product_height" value="<?php echo esc_html($height); ?>" disabled>
                                    <input type="hidden" name="freightmate_isMutable" value="<?php echo esc_html($isMutable); ?>">
                                    <input type="hidden" name="freightmate_product_weight" value="<?php echo esc_html($weight); ?>">
                                    <input type="hidden" name="freightmate_product_length" value="<?php echo esc_html($length); ?>">
                                    <input type="hidden" name="freightmate_product_width" value="<?php echo esc_html($width); ?>">
                                    <input type="hidden" name="freightmate_product_height" value="<?php echo esc_html($height); ?>">
                                    <input type="hidden" name="freightmate_product_item_type_name" value="<?php echo esc_html($itemTypeName); ?>">
                                </span>
                            </p>
                    <?php }
                    } ?>
                </div>
                <p class="form-field _weight_field ">
                    <label for="freightmate_tailgate">Tailgate required</label><input type="checkbox" name="freightmate_product_tailgate" id="freightmate_product_tailgate" <?php echo (esc_html($is_tailgate) == 'on' ? 'checked' : ''); ?>>
                </p>
            </div>
        </div>
<?php
    }
    public function saveFields($post_id)
    {
        $item_type = isset($_POST['freightmate_item_type']) ? sanitize_text_field(wp_unslash($_POST['freightmate_item_type'])) : '';
        update_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'item_type', $item_type);
        //Update product weight
        $product_weight = isset($_POST['freightmate_product_weight']) ? sanitize_text_field(wp_unslash($_POST['freightmate_product_weight'])) : '';
        update_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_weight', $product_weight);
        //Update product Length
        $product_length = isset($_POST['freightmate_product_length']) ? sanitize_text_field(wp_unslash($_POST['freightmate_product_length'])) : '';
        update_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_length', $product_length);
        //Update product Width
        $product_width = isset($_POST['freightmate_product_width']) ? sanitize_text_field(wp_unslash($_POST['freightmate_product_width'])) : '';
        update_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_width', $product_width);
        //Update product Height
        $product_height = isset($_POST['freightmate_product_height']) ? sanitize_text_field(wp_unslash($_POST['freightmate_product_height'])) : '';
        update_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_height', $product_height);
        //Update product Mutable
        $product_isMutable = isset($_POST['freightmate_isMutable']) ? sanitize_text_field(wp_unslash($_POST['freightmate_isMutable'])) : '';
        update_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_isMutable', $product_isMutable);
        //Update product Item Type name
        $itemTypeName = isset($_POST['freightmate_product_item_type_name']) ? sanitize_text_field(wp_unslash($_POST['freightmate_product_item_type_name'])) : '';
        update_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_item_type_name', $itemTypeName);
        //Update freightmate_product_tailgate
        $is_tailgate = isset($_POST['freightmate_product_tailgate']) ? sanitize_text_field(wp_unslash($_POST['freightmate_product_tailgate'])) : '';
        update_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_tailgate', $is_tailgate);
    }

    public function loadFields($product)
    {
        //$product->update_meta_data(FREIGHTMATE_META_PREFIX.'item_type', get_post_meta($product->get_id(), FREIGHTMATE_META_PREFIX.'item_type', true));
    }
}
// Instantiate the class
new Freightmate_Product_Configuration();
