<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 
if (!class_exists('WP_List_Table')) {
    require_once(ABSPATH . 'wp-admin/includes/screen.php');
    require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}
class Freightmate_Manifest_List_Table extends WP_List_Table
{

    public function __construct()
    {
        parent::__construct(array(
            'singular' => 'order',
            'plural'   => 'orders',
            'ajax'     => false
        ));
    }

    public function no_items()
    {
        esc_html_e('No Manifests found.', 'freightmate-for-woocommerce');
    }

    public function column_default($item, $column_name)
    {
        return $item[$column_name];
    }

    public function column_order_id($item)
    {
        $actions = array(
            'view' => sprintf(
                '<a href="?page=%s&action=%s&order_id=%s">%s</a>',
                ( isset($_REQUEST['page']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_REQUEST['page'])) ) ) ? wp_verify_nonce(esc_attr(sanitize_text_field(wp_unslash($_REQUEST['page'])))) : '',
                'view',
                isset($item['order_id']) ? esc_attr($item['order_id']) : '',
                __('View', 'freightmate-for-woocommerce')
            ),
        );
        return sprintf('%1$s %2$s', esc_html($item['order_id']), $this->row_actions($actions));        
    }

    public function prepare_items()
    {
        $columns = $this->get_columns();
        $hidden = array();
        $sortable = $this->get_sortable_columns();

        $this->_column_headers = array($columns, $hidden, $sortable);

        $data = $this->list_orders_data(); // Function to get order data
        //usort($data, array(&$this, 'usort_reorder'));

        $per_page = 10;
        $current_page = $this->get_pagenum();
        $total_items = count($data);

        $data = array_slice($data, (($current_page - 1) * $per_page), $per_page);

        $this->items = $data;

        $this->set_pagination_args(array(
            'total_items' => $total_items,
            'per_page'    => $per_page,
            'total_pages' => ceil($total_items / $per_page)
        ));
    }

    public function get_columns()
    {
        $columns = array(
            'date_submitted'       => __('Date Submitted', 'freightmate-for-woocommerce'),
            'manifest_number'  => __('Manifest Number', 'freightmate-for-woocommerce'),
            'carrier'  => __('Carrier', 'freightmate-for-woocommerce'),
            'pickup_booking'  => __('Pickup Booking', 'freightmate-for-woocommerce'),
            'connote'  => __('Connote', 'freightmate-for-woocommerce'),
            'sender_company'  => __('Sender Company', 'freightmate-for-woocommerce'),
            'receiver_company'  => __('Receiver Company', 'freightmate-for-woocommerce'),
            'print_manifest'  => __('Print Manifest', 'freightmate-for-woocommerce'),
            'print_labels'  => __('Print Labels', 'freightmate-for-woocommerce'),
            'tracking'  => __('Tracking', 'freightmate-for-woocommerce'),
        );
        return $columns;
    }

    public function get_sortable_columns()
    {
        $sortable_columns = array(
            'order'      => array('order', false)
        );
        return [];
    }

    private function list_orders_data()
    {
        $orderData = $this->get_manifest_column_data_by_order();
        return $orderData;
    }

    function usort_reorder($a, $b)
    {
        $orderby = !empty($_REQUEST['orderby']) ? esc_attr(sanitize_text_field(wp_unslash($_REQUEST['orderby']))) : 'order_id';
        $order = !empty($_REQUEST['order']) ? esc_attr(sanitize_text_field(wp_unslash($_REQUEST['order']))) : 'asc';        
        $result = strcmp($a[$orderby], $b[$orderby]);
        return ($order === 'asc') ? $result : -$result;
    }
    function get_manifest_column_data_by_order()
    {
        $manifest_array = [];
        $freightmate_connection = new Freightmate_API_Connection(FREIGHTMATE_API_URL);
        $freightmate_api = new Freightmate_Rest_Api($freightmate_connection);
        $manifest = $freightmate_api->manifest_list($freightmate_connection);
        $success = isset($manifest['success']) && $manifest['success'] == 1 ? true : false;
        $totalCount = isset($manifest['data']) && isset($manifest['data']['totalCount']) ? $manifest['data']['totalCount'] : 0;
        $manifest_data = isset($manifest['data']) && isset($manifest['data']['results']) && $manifest['data']['results'] ? $manifest['data']['results'] : [];
        if ($success == true && $totalCount > 0 && $manifest_data) {
            foreach ($manifest_data as $manifest_info) {
                $manifestNumber = isset($manifest_info['manifestNumber']) ? $manifest_info['manifestNumber'] : '';
                $carrierName = isset($manifest_info['carrierName']) ? $manifest_info['carrierName'] : '';
                $createdAt = isset($manifest_info['createdAt']) ? $manifest_info['createdAt'] : '';
                $bookingStatus = isset($manifest_info['bookingStatus']) ? $manifest_info['bookingStatus'] : '';
				$consignments = isset($manifest_info['consignments']) ? $manifest_info['consignments'] : [];
                $date = new DateTime($createdAt);
                $createdAt = $date->format('M d, Y');
                if( $consignments ){
                    foreach( $consignments as $consignment){
                        $connoteNumber = $consignment['connoteNumber'] ?? '';
						$order_id = freightmateCommonMethods::getOrderIdByConnoteNumber($connoteNumber);
						$consignmentInfo = get_post_meta($order_id, FREIGHTMATE_META_PREFIX.'consignment_result', true);
                        $sender_company = isset($consignmentInfo['data']) && isset($consignmentInfo['data']['senderAddress']) ? $consignmentInfo['data']['senderAddress']['company'] : '';
						$receiver_company = isset($consignmentInfo['data']) && isset($consignmentInfo['data']['deliveryAddress']) ? $consignmentInfo['data']['deliveryAddress']['company'] : '';
                        $track_link = add_query_arg( ['consignment_number'=>$connoteNumber], admin_url('admin.php?page=freightmate-track-and-trace') );
                        $print_label = add_query_arg( ['action' => 'print_label', 'manifestNumber'=>$manifestNumber,'connoteNumber'=>$connoteNumber], admin_url('admin.php?page=freightmate-manifested-consignment') );
                        $print_manifest = add_query_arg( ['action' => 'print_manifest', 'manifestNumber'=>$manifestNumber], admin_url('admin.php?page=freightmate-manifested-consignment') );
                        $manifest_array[] = [
                            'date_submitted' => $createdAt,
                            'manifest_number' => $manifestNumber,
                            'carrier' => $carrierName,
                            'pickup_booking' => $bookingStatus,
                            'connote'  => $connoteNumber,
                            'sender_company'  => $sender_company,
                            'receiver_company'  => $receiver_company,
                            'print_manifest' => '<a target="_blank" href="'.$print_manifest.'"><span class="dashicons dashicons-printer"></span></a>',
                            'print_labels'  => '<a target="_blank" href="'.$print_label.'"><span class="dashicons dashicons-printer"></span></a>',
                            'tracking'  => '<a href="'.$track_link.'" target="_blank"><span class="dashicons dashicons-car"></span></a>',
                        ];
                    }
                }
            }
        }
        return $manifest_array;
    }
}
