<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly 
/**
 * Freightmate_Logs_Table_Manager Class
 *
 * A class to manage logs related to Freightmate operations.
 */
class Freightmate_Logs_Table_Manager
{

    /**
     * Create Table
     *
     * Creates the database table to store Freightmate logs if it doesn't exist already.
     */
    public static function create_table()
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'freightmate_logs';

        // Define a cache key for this specific check
	    $cache_key = 'freightmate_logs_tbl_exists';

        // Try to get the cached result first
	    $table_exists_1 = wp_cache_get( $cache_key );

        // Check if table already exists
        $check_tbl = $wpdb->get_var( $wpdb->prepare("SHOW TABLE LIKE %s",$table_name));

        // Cache the result to avoid future database hits
		wp_cache_set( $cache_key, $table_exists_1 );

        if ( $check_tbl != $table_name) {
            $charset_collate = $wpdb->get_charset_collate();

            // Define table structure
            $sql = "CREATE TABLE $table_name (
                id INT NOT NULL AUTO_INCREMENT,
                message TEXT NOT NULL,
                level VARCHAR(50) NOT NULL,
                timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (id)
                ) $charset_collate";

            // Create the table
            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
            dbDelta($sql);
        }
    }

    /**
     * Insert Log
     *
     * Inserts a log entry into the Freightmate logs table.
     *
     * @param string $message The log message to be inserted.
     * @param string $level Optional. The log level (e.g., INFO, ERROR). Default is "INFO".
     */
    public static function insert_log($message, $level = "INFO")
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'freightmate_logs';
        $data = [
            'message' => $message,
            'level' => $level
        ];

        // Insert log into the database
        $wpdb->insert($table_name, $data);
    }

    /**
     * Get Logs
     *
     * Retrieves logs from the Freightmate logs table.
     *
     * @param int|null $limit Optional. The maximum number of logs to retrieve. Default is null (retrieve all logs).
     * @return array An array of log entries.
     */
    public static function get_logs($limit = null)
    {
        global $wpdb;
        $table_name = $wpdb->prefix . 'freightmate_logs';
        $sql_query = "SELECT * FROM $table_name";

        // Define a cache key for this specific check
	    $cache_key = 'freightmate_logs_tbl_select';

        // Try to get the cached result first
	    $table_exists_1 = wp_cache_get( $cache_key );

        // Append limit to SQL query if specified
        if ($limit) {
            
            // Retrieve logs from the database
            //$wpdb->prepare("SELECT * FROM %s LIMIT %d", array($table_name,$limit));
            $output_qry = $wpdb->get_results($wpdb->prepare("SELECT * FROM %s LIMIT %d", array($table_name,$limit)), ARRAY_A);
            wp_cache_set( $cache_key, $table_exists_1 );
            
        }
        else{
            // Retrieve logs from the database
            //$wpdb->prepare("SELECT * FROM %s",  array($table_name));
            $output_qry = $wpdb->get_results($wpdb->prepare("SELECT * FROM %s",  array($table_name)), ARRAY_A);
            wp_cache_set( $cache_key, $table_exists_1 );
        }

        
        return $output_qry;
    }

}
