<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 
if (!class_exists('WP_List_Table')) {
    require_once(ABSPATH . 'wp-admin/includes/screen.php');
    require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}
class Freightmate_Consignment_List_Table extends WP_List_Table
{

    public function __construct()
    {
        parent::__construct(array(
            'singular' => 'order',
            'plural'   => 'orders',
            'ajax'     => false
        ));
    }

    public function no_items()
    {
        esc_html_e('No Consignments found.', 'freightmate-for-woocommerce');
    }

    public function column_default($item, $column_name)
    {
        return $item[$column_name];
    }

    public function column_order_id($item)
    {
        $actions = array(
            'view' => sprintf(
                '<a href="?page=%s&action=%s&order_id=%s">%s</a>',
                (isset($_REQUEST['page']) && wp_verify_nonce(esc_attr(sanitize_text_field(wp_unslash($_REQUEST['page']))) ) ) ? wp_verify_nonce(esc_attr(sanitize_text_field(wp_unslash($_REQUEST['page']) ) )) : '',
                'view',
                isset($item['order_id']) ? esc_attr($item['order_id']) : '',
                __('View', 'freightmate-for-woocommerce')
            ),
        );
        return sprintf('%1$s %2$s', esc_html($item['order_id']), $this->row_actions($actions));        
    }

    public function prepare_items()
    {
        $columns = $this->get_columns();
        $hidden = array();
        $sortable = $this->get_sortable_columns();

        $this->_column_headers = array($columns, $hidden, $sortable);

        $data = $this->list_orders_data(); // Function to get order data
        //usort($data, array(&$this, 'usort_reorder'));

        $per_page = 10;
        $current_page = $this->get_pagenum();
        $total_items = count($data);

        $data = array_slice($data, (($current_page - 1) * $per_page), $per_page);

        $this->items = $data;

        $this->set_pagination_args(array(
            'total_items' => $total_items,
            'per_page'    => $per_page,
            'total_pages' => ceil($total_items / $per_page)
        ));
    }

    public function get_columns()
    {
        $columns = array(
            'connote_number'       => __('Connote No.', 'freightmate-for-woocommerce'),
            'order_id'  => __('Order ID', 'freightmate-for-woocommerce'),
            'consignment_type'  => __('Consignment Type', 'freightmate-for-woocommerce'),
            'dispatch_date'  => __('Dispatch Date', 'freightmate-for-woocommerce'),
            // 'references'  => __('References', 'freightmate-for-woocommerce'),
            'reciever_company'  => __('Reciever Company', 'freightmate-for-woocommerce'),
            'suburb'  => __('Suburb', 'freightmate-for-woocommerce'),
            'eta'  => __('ETA', 'freightmate-for-woocommerce'),
            'status'  => __('Status', 'freightmate-for-woocommerce'),
            'total'  => __('Total', 'freightmate-for-woocommerce'),
            'action'  => __('Action', 'freightmate-for-woocommerce'),
            // Add more columns as needed
        );
        return $columns;
    }

    public function get_sortable_columns()
    {
        $sortable_columns = array(
            'order'      => array('order', false)
        );
        return [];
    }

    private function list_orders_data()
    {
        $orderData = $this->get_consignment_column_data_by_order();
        return $orderData;
    }

    function usort_reorder($a, $b)
    {
        $orderby = ( !empty($_REQUEST['orderby']) && wp_verify_nonce(esc_attr(sanitize_text_field(wp_unslash($_REQUEST['orderby']) ) )) ) ?  wp_verify_nonce(esc_attr(sanitize_text_field(wp_unslash($_REQUEST['orderby']) ) )) : 'order_id';
        $order = ( !empty($_REQUEST['order']) && wp_verify_nonce(esc_attr(sanitize_text_field(wp_unslash($_REQUEST['order']) ) )) ) ? wp_verify_nonce(esc_attr(sanitize_text_field(wp_unslash($_REQUEST['order']) ) )) : 'asc';
        $result = strcmp($a[$orderby], $b[$orderby]);
        return ($order === 'asc') ? $result : -$result;
    }
    function get_consignment_column_data_by_order()
    {
        $consignment_array = [];
        $freightmate_connection = new Freightmate_API_Connection(FREIGHTMATE_API_URL);
        $freightmate_api = new Freightmate_Rest_Api($freightmate_connection);
        $consignment = $freightmate_api->get_consignment($freightmate_connection, ['state' => 'OPEN', 'sort' => 'DESC']);
        $success = isset($consignment['success']) && $consignment['success'] == 1 ? true : false;
        $totalCount = isset($consignment['data']) && isset($consignment['data']['totalCount']) ? $consignment['data']['totalCount'] : 0;
        $consignment_data = isset($consignment['data']) && isset($consignment['data']['results']) && $consignment['data']['results'] ? $consignment['data']['results'] : [];
        if ($success == true && $totalCount > 0 && $consignment_data) {
            foreach ($consignment_data as $consignment_info) {
                $connoteNumber = isset($consignment_info['connoteNumber']) ? $consignment_info['connoteNumber'] : '';
                $connoteId = isset($consignment_info['id']) ? $consignment_info['id'] : '';
                $consignmentType = isset($consignment_info['consignmentType']) ? $consignment_info['consignmentType'] : '';
                $references = isset($consignment_info['consignmentReferences']) ? implode(',', $consignment_info['consignmentReferences']) : '';
                $suburb = isset($consignment_info['deliveryAddress']['suburb']['name']) ? $consignment_info['deliveryAddress']['suburb']['name'] : '';
                $company = isset($consignment_info['deliveryAddress']['company']) ? $consignment_info['deliveryAddress']['company'] : '';
                $dispatchedAt = isset($consignment_info['dispatchedAt']) ? $consignment_info['dispatchedAt'] : '';
                $status = isset($consignment_info['status']) ? $consignment_info['status'] : '';
                $eta = isset($consignment_info['eta']) ? $consignment_info['eta'] : '';
                $totalCost = isset($consignment_info['totalCost']) ? $consignment_info['totalCost'] : '';
                $CutOff = isset($consignment_info['carrierCutOffDateTime']) ? $consignment_info['carrierCutOffDateTime'] : '';
                $order_id = freightmateCommonMethods::getOrderIdByConnoteNumber($connoteNumber);
                //$order = wc_get_order($order_id);
                $consignment_link = admin_url('admin.php?page=freightmate-consignment');
                $order_edit_link = esc_url(add_query_arg(['cut_off'=> $CutOff, 'order_id' => $order_id, 'action' => 'create-order-manifest', 'connoteNumber' => $connoteId, 'consignment_id' => $connoteNumber ], $consignment_link));
                $order_delete_link = esc_url(add_query_arg(['order_id' => $order_id, 'action' => 'delete-order-consignment','connoteNumber' => $connoteNumber, 'freightmate_action' => 'submit'], $consignment_link));
                $create_manifests = '<div class="create-order-manifest-wrap"><a href="' . $order_edit_link . '" class="create-order-manifest">Manifest</a><a href="' . $order_delete_link . '" class="delete-order-consignment" data-id="'.$connoteNumber.'"><span>&#11199;</span></a></div>';
                $date = new DateTime($dispatchedAt);
                $dispatchedAt = $date->format('M d, Y');
                $consignment_array[] = [
                    'connote_number' => $connoteNumber,
                    'order_id' => $order_id,
                    'consignment_type' => $consignmentType,
                    'dispatch_date' => $dispatchedAt,
                    // 'references' => $references,
                    'reciever_company' => $company,
                    'suburb' => $suburb,
                    'eta' => $eta,
                    'status' => $status,
                    'total' => $totalCost,
                    'action' => $create_manifests
                ];
            }
        }
        return $consignment_array;
    }
}
