<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 
class freightmateCommonMethods
{
    static function freightmateFormatDateTimeInUTC($date, $time)
    {
        $datetime = new DateTime("$date $time", new DateTimeZone('UTC'));
        return $datetime->format('Y-m-d\TH:i:s.v\Z');
    }
    static function freightmateTimeZone()
    {
        $timezone_string = get_option('timezone_string');
        if (empty($timezone_string)) {
            $gmt_offset = get_option('gmt_offset');
            $timezone_string = $gmt_offset ? "Etc/GMT" . sprintf('%+d', $gmt_offset) : 'UTC';
        }
        return $timezone_string;
    }
    /**
     * Convert a custom date to WordPress timezone if it includes time.
     *
     * @param string $custom_date The custom date in 'Y-m-d' or 'Y-m-d H:i:s' format.
     * @return string The date converted to the WordPress timezone if it includes time, or the original date if not.
     */
    static function freightmateConvert_to_wp_timezone($custom_date)
    {
        $date_format = (strpos($custom_date, ':') !== false) ? 'Y-m-d H:i:s' : 'Y-m-d';
        $timezone_string = get_option('timezone_string');
        if (empty($timezone_string)) {
            $gmt_offset = get_option('gmt_offset');
            $timezone_string = $gmt_offset ? "Etc/GMT" . sprintf('%+d', $gmt_offset) : 'UTC';
        }
        $date = new DateTime($custom_date, new DateTimeZone('UTC'));
        $date->setTimezone(new DateTimeZone($timezone_string));
        return $date->format($date_format);
    }
    /**
     * Retrieve the order ID based on the consignment connote number.
     *
     * @param string $connoteNumber The consignment connote number.
     * @return int|false The post ID if found, false otherwise.
     */
  /*  static function getOrderIdByConnoteNumber($connoteNumber)
    {
        global $wpdb;
        $prefix = $wpdb->prefix;
        $table_name = $prefix . 'postmeta';
        $meta_key = FREIGHTMATE_META_PREFIX . 'consignment_connoteNumber';
        
        // Define a cache key for this specific check
	    $cache_key = 'postmeta_pid_tbl_select';

        // Try to get the cached result first
	    $table_exists_1 = wp_cache_get( $cache_key );

        $result = $wpdb->get_results($wpdb->prepare(
            "SELECT post_id FROM %s WHERE meta_key = %s AND meta_value = %s",
            $table_name,
            $meta_key,
            $connoteNumber
        ), ARRAY_A);

        // Cache the result to avoid future database hits
		wp_cache_set( $cache_key, $table_exists_1 );
        
        if (!empty($result) && isset($result[0]['post_id'])) {
            return $result[0]['post_id'];
        } else {
            return false;
        }
    }*/

      static function getOrderIdByConnoteNumber($connoteNumber)
    {
        global $wpdb;
        $prefix = $wpdb->prefix;
        $table_name = $prefix . 'postmeta';
        $meta_key = FREIGHTMATE_META_PREFIX . 'consignment_connoteNumber';

        // Define a cache key for this specific check
        $cache_key = 'postmeta_pid_tbl_select_' . $connoteNumber;

        // Try to get the cached result first
        $cached_result = wp_cache_get($cache_key);

        if ($cached_result !== false) {
            return $cached_result;
        }

        // Execute the query to fetch the post_id
        $query = $wpdb->prepare(
            "SELECT post_id FROM $table_name WHERE meta_key = %s AND meta_value = %s",
            $meta_key,
            $connoteNumber
        );

        $result = $wpdb->get_results($query, ARRAY_A); 

        // Cache the result to avoid future database hits
        if (!empty($result) && isset($result[0]['post_id'])) {
            wp_cache_set($cache_key, $result[0]['post_id']);
            return $result[0]['post_id'];
        } else {
            wp_cache_set($cache_key, false);
            return false;
        }
    }
    /**
     * Retrieve the order ID based on the manifest number.
     *
     * @param string $connoteNumber The manifest number.
     * @return int|false The post ID if found, false otherwise.
     */
    static function getOrderIdByManifestNumber($manifestNumber)
    {
        global $wpdb;
        $prefix = $wpdb->prefix;
        $table_name = $prefix . 'postmeta';
        $meta_key = FREIGHTMATE_META_PREFIX . 'manifest_number';

        
        // Define a cache key for this specific check
	    $cache_key = 'postmeta_tbl_select1';

        // Try to get the cached result first
	    $table_exists_1 = wp_cache_get( $cache_key );
        
        $result = $wpdb->get_results($wpdb->prepare("SELECT post_id FROM %s WHERE meta_key = %s AND meta_value = %s",
            $table_name,    
            $meta_key,
            $manifestNumber
        ), ARRAY_A);

        // Cache the result to avoid future database hits
		wp_cache_set( $cache_key, $table_exists_1 );

        if (!empty($result) && isset($result[0]['post_id'])) {
            return $result[0]['post_id'];
        } else {
            return false;
        }
    }
    public static function getEligibleOrderIdsConsignment()
    {
        global $wpdb;
        $meta_key = FREIGHTMATE_META_PREFIX . 'is_consignment_created';

        // Define a cache key for this specific check
	    $cache_key = 'freightmate_posts_tb_select1';

        // Try to get the cached result first
	    $table_exists_1 = wp_cache_get( $cache_key );

        $order_ids = $wpdb->get_col($wpdb->prepare("
        SELECT p.ID 
        FROM {$wpdb->posts} p
        JOIN {$wpdb->postmeta} pm 
        ON p.ID = pm.post_id 
        AND pm.meta_key = %s  
        AND pm.meta_value = '1'", $meta_key));

        // Cache the result to avoid future database hits
		wp_cache_set( $cache_key, $table_exists_1 );

        return $order_ids;
    }
    public static function freightmateHasConsignment($order_id)
    {
        $is_consignment_created = get_post_meta($order_id, FREIGHTMATE_META_PREFIX . 'is_consignment_created', true);
        $connoteNumber = get_post_meta($order_id, FREIGHTMATE_META_PREFIX . 'consignment_connoteNumber', true);
        $is_consignment_created && $is_consignment_created == 1 ? true : false;
        return [
            'status' => $is_consignment_created,
            'connoteNumber' => $connoteNumber
        ];
    }
    public static function getItems($id = null)
    {
        // Initialize Freightmate API connection
        $freightmate_connection = new Freightmate_API_Connection(FREIGHTMATE_API_URL);
        $freightmate_api = new Freightmate_Rest_Api($freightmate_connection);
        $items = $freightmate_api->get_items($freightmate_connection);
        $itemsData = isset($items['data']) ? $items['data'] : [];
        if ($id && $id != null) {
            foreach ($itemsData as $item) {
                if ($item['id'] === intval($id)) {
                    return $item;
                }
            }
        }
        return $itemsData;
    }
    public static function calculateShipingCharges()
    {
        // Initialize Freightmate API connection
        $freightmate_connection = new Freightmate_API_Connection(FREIGHTMATE_API_URL);
        $freightmate_api = new Freightmate_Rest_Api($freightmate_connection);
        $client_address = $freightmate_api->get_client_address($freightmate_connection, true);
        $items = [];
        // Get shipping or billing suburb and zip code
        $shipping_city = WC()->customer->get_shipping_city();
        $shipping_postcode = WC()->customer->get_shipping_postcode();
        $billing_city = WC()->customer->get_billing_city();
        $billing_postcode = WC()->customer->get_billing_postcode();
        // Determine which values to use
        $city = !empty($shipping_city) ? $shipping_city : $billing_city;
        $postcode = !empty($shipping_postcode) ? $shipping_postcode : $billing_postcode;
        foreach (WC()->cart->get_cart() as $cart_item) {
            $product_id = $cart_item['product_id'];
            $quantity = $cart_item['quantity'];
            //Items meta data
            $weight = get_post_meta($product_id, FREIGHTMATE_META_PREFIX . 'product_weight', true) ?? 0;
            $length = get_post_meta($product_id, FREIGHTMATE_META_PREFIX . 'product_length', true) ?? 0;
            $width = get_post_meta($product_id, FREIGHTMATE_META_PREFIX . 'product_width', true) ?? 0;
            $height = get_post_meta($product_id, FREIGHTMATE_META_PREFIX . 'product_height', true) ?? 0;
            $itemTypeName = get_post_meta($product_id, FREIGHTMATE_META_PREFIX . 'product_item_type_name', true) ?? '';
            $items[] = [
                'quantity' => $quantity,
                'weight' => $weight,
                'length' => $length,
                'width' => $width,
                'height' => $height,
                'itemTypeName' => $itemTypeName
            ];
        }

        $offerArrayData = [
            "isDeliverySuburbResidential" => true,
            "authorityToLeave" => false,
            "tailgateRequired" => false,
            "items" => []
        ];
        $clientId = isset($client_address['clientId']) ? $client_address['clientId'] : '';
        $authorityToLeave = (isset($_REQUEST['authority-to-leave']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_REQUEST['authority-to-leave']))) ) ? wp_verify_nonce(sanitize_text_field(wp_unslash($_REQUEST['authority-to-leave']))) : false;
        $tailgate = ( isset($_REQUEST['tailgate']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_REQUEST['tailgate']))) ) ? wp_verify_nonce(sanitize_text_field(wp_unslash($_REQUEST['tailgate']))) : '';

        $offerArrayData['authorityToLeave'] = $authorityToLeave == 'on' ? true : false;
        $offerArrayData['tailgateRequired'] = $tailgate == 'on' ? true : false;
        $offerArrayData['senderAddressId'] = $clientId;

        $offerArrayData['deliverySuburb']['name'] = strtoupper($city);
        $offerArrayData['deliverySuburb']['postcode'] = intval($postcode);
        $offerArrayData['items'] = $items;
        //Search for Address
        $offerJsonData = isset($offerArrayData) ? wp_json_encode($offerArrayData) : '{}';
        if ($offerJsonData) {
            $offers = $freightmate_api->get_offers($freightmate_connection, $offerJsonData);
        }
        $status_code = isset($offers['status_code']) ? $offers['status_code'] : '';
        if ($status_code != 200) {
            return NULL;
        }
        return $offers['data']['offers'] ?? [];
       /* $result = isset($offers['data']) && isset($offers['data']['offers']) ? $offers['data']['offers'] : [];
        usort($result, function ($a, $b) {
            return $a['costs']['totalCost'] <=> $b['costs']['totalCost'];
        });

        return $result[0]['costs']['totalCost'] ?? NULL;*/
    }
    static function print_manifest_link($manifestNumber)
    {
        $freightmate_connection = new Freightmate_API_Connection(FREIGHTMATE_API_URL);
        $freightmate_api = new Freightmate_Rest_Api($freightmate_connection);
        $print_manifest = $freightmate_api->print_manifest($freightmate_connection, ['manifestId' => $manifestNumber]);
        $print_manifest = isset($print_manifest['data']) ? $print_manifest['data'] : [];
        $result = ['status' => false];
        if ($print_manifest) {
            $encodedPDF = $print_manifest['content'] ?? '';
            $filename = $print_manifest['filename'] ?? 'manifest.pdf';
            $result['pdf'] = $encodedPDF;
            $result['name'] = $filename;
        }
        return $result;
    }
    static function print_manifest_label_link($manifestNumber)
    {
        // Initialize Freightmate API connection
        $freightmate_connection = new Freightmate_API_Connection(FREIGHTMATE_API_URL);
        $freightmate_api = new Freightmate_Rest_Api($freightmate_connection);
        $print_manifest = $freightmate_api->print_manifest_label($freightmate_connection, ['manifestId' => $manifestNumber]); 
        $print_manifest = isset($print_manifest['data']) ? $print_manifest['data'] : [];
        $result = ['status' => false];
        if ($print_manifest) {
            $encodedPDF = $print_manifest['content'] ?? '';
            $filename = $print_manifest['filename'] ?? 'manifest_label.pdf';
            $result = ['status' => true];
            $result['pdf'] = $encodedPDF;
            $result['name'] = $filename;
        }
        return $result;
    }
    static function track_consignment_template($consignment_number)
    {
        if ($consignment_number) {
            // Initialize Freightmate API connection
            $freightmate_connection = new Freightmate_API_Connection(FREIGHTMATE_API_URL);
            $freightmate_api = new Freightmate_Rest_Api($freightmate_connection);
            $track_consignment = $freightmate_api->track_consignment($freightmate_connection, ['connote_number' => $consignment_number]);
            if ($track_consignment['status_code'] == 200) {
                $response['status'] = true;
                $response['data'] = $track_consignment['data'] ?? [];
                // Load and include the template HTML content
                ob_start();
                include FREIGHTMATE_APP_PLUGIN_DIR . 'pages/freightmate-track-consignment-status.php';
                $response['template'] = ob_get_clean();
            } else {
                $apiError = isset($track_consignment['error']) ? $track_consignment['error'] : '';
                $errorStatus = $track_consignment['data']['status'] ?? '';
                $validationErrors = $track_consignment['data']['validationErrors'] ?? '';
                $error_message = isset($validationErrors[0]['message']) ? $validationErrors[0]['message'] : '';
                $error_message = $error_message ? $error_message : $apiError;
                $response['message'] = '<strong>' . $errorStatus . '</strong>: ' . $error_message . '';
                $response['status'] = false;
            }
            return $response;
        }
    }
    static function is_step_active($tracks, $current){
        $is_active = '';
        if($tracks){
            foreach($tracks as $track){
                if( $track['UpdateStatus'] == $current ){
                    $is_active = 'active';
                }
            }
        }
        return $is_active;
    }
    static function tracking_steps_html($tracks){
        $statues = [
            'MANIFESTED' => 'MANIFESTED', 
            'PICKUP_BOOKED' => 'PICKUP BOOKED',
            'IN_TRANSIT' => 'IN TRANSIT',
            'OUT_FOR_DELIVERY' => 'OUT FOR DELIVERY',
            'DELIVERED' => 'DELIVERED'
        ];
        $output = '<div class="tracking-steps"><ul>';
        if($statues){
            foreach($statues as $status_key => $status_label){
                $active = self::is_step_active($tracks,$status_key);
                $output .= '<li class="'.$active.'">'.$status_label.'</li>';
            }
        }
        $output .= '</div></ul>';
        return $output;
    }
    static function  get_freightmate_meta_key_count($meta_key, $meta_value) {
        global $wpdb;

        // Define a cache key for this specific check
	    $cache_key = 'freightmate_postmeta_tbl_cnt';

        // Try to get the cached result first
	    $table_exists_1 = wp_cache_get( $cache_key );

        $count = $wpdb->get_var(
            $wpdb->prepare(
                "SELECT COUNT(*) FROM {$wpdb->postmeta} WHERE meta_key = %s AND meta_value = %s",
                $meta_key, $meta_value
            )
        );

        // Cache the result to avoid future database hits
		wp_cache_set( $cache_key, $table_exists_1 );
        
        return $count;
    }
    static function get_processing_order_count() {
        if ( ! class_exists( 'WC_Order_Query' ) ) {
            return 0;
        }
        $query = new WC_Order_Query( array(
            'status' => 'processing',
            'return' => 'ids',
        ) );
    
        $orders = $query->get_orders();
    
        return count( $orders );
    }
    static function is_freightmate_active(){
        $freightmate_connection = new Freightmate_API_Connection(FREIGHTMATE_API_URL);
        $freightmate_api = new Freightmate_Rest_Api($freightmate_connection);
        $is_freightmate_connected = $freightmate_api->get_items($freightmate_connection);
        if( FREIGHTMATE_API_KEY == '' || FREIGHTMATE_API_SECRET == '' || FREIGHTMATE_ENV == '' || FREIGHTMATE_API_URL == '' ){
            return false;
        }
        if( isset($is_freightmate_connected['status_code']) && $is_freightmate_connected['status_code'] && $is_freightmate_connected['status_code'] != 200 ){
            return false;
        }
        return true;
    }
    static function  is_utc_iso8601($timestamp) {
        // Regular expression to match ISO 8601 format with 'Z' at the end
        $regex = '/^(\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:\.\d{3})?Z)$/';
        
        // Check if the timestamp matches the regex
        if (preg_match($regex, $timestamp)) {
            // Try to parse the timestamp with DateTime
            try {
                $datetime = new DateTime($timestamp);
                // Check if the timezone is UTC
                if ($datetime->getTimezone()->getName() === 'UTC') {
                    return true;
                }
            } catch (Exception $e) {
                return false;
            }
        }
        
        return false;
    }
    static function convert_iso8601_to_wp_timezone($iso_timestamp) {
        // Get the WordPress timezone setting
        $timezone = get_option('timezone_string');
        
        // Convert the ISO 8601 timestamp to a DateTime object
        $datetime = new DateTime($iso_timestamp);
        
        // If the timezone is set in WordPress, apply it to the DateTime object
        if ($timezone) {
            $wp_timezone = new DateTimeZone($timezone);
            $datetime->setTimezone($wp_timezone);
        }
        
        // Format the DateTime object to separate date and time
        $date = $datetime->format('Y-m-d');
        $time = $datetime->format('H:i:s');
        
        return array('date' => $date, 'time' => $time);
    }

    static function freightmate_load_template_part($template_name, $var_data = array()) {
        ob_start();
        get_template_part($template_name, "" , $var_data);
        $var = ob_get_contents();
        ob_end_clean();
        return $var;
    }
}
