<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 
add_action('wp_ajax_wp_searchKeyword_ajax_action', 'freightmate_searchKeyword_ajax_action_cb');
add_action('wp_ajax_nopriv_wp_searchKeyword_ajax_action', 'freightmate_searchKeyword_ajax_action_cb');
function freightmate_searchKeyword_ajax_action_cb()
{
    // Initialize Freightmate API connection
    $freightmate_connection = new Freightmate_API_Connection(FREIGHTMATE_API_URL);
    $freightmate_api = new Freightmate_Rest_Api($freightmate_connection);

    // Verify and sanitize the nonce
    $nonce = isset($_REQUEST['nonce']) ? sanitize_text_field(wp_unslash($_REQUEST['nonce'])) : '';
    if (!wp_verify_nonce($nonce, 'wp_searchKeyword_ajax_action')) {
        wp_send_json_error(['message' => 'Invalid nonce']);
        exit;
    }

    // Retrieve and sanitize the search keyword
    $searchKeyword = isset($_REQUEST['searchKeyword']) ? sanitize_text_field(wp_unslash($_REQUEST['searchKeyword'])) : '';
    if (empty($searchKeyword)) {
        wp_send_json_error(['message' => 'Search keyword is empty']);
        exit;
    }

    // Search for address if the keyword is valid
    $resultAddress = $freightmate_api->search_address($freightmate_connection, ['filter' => $searchKeyword]);
    echo wp_json_encode($resultAddress);
    exit;
}

add_action('wp_ajax_wp_searchSuburb_ajax_action', 'freightmate_searchSuburb_ajax_action_cb');
function freightmate_searchSuburb_ajax_action_cb()
{
    // Initialize Freightmate API connection
    $freightmate_connection = new Freightmate_API_Connection(FREIGHTMATE_API_URL);
    $freightmate_api = new Freightmate_Rest_Api($freightmate_connection);
    //Search for Address
    $searchSuburb = (isset($_REQUEST['searchSuburb']) && sanitize_text_field(wp_unslash($_REQUEST['searchSuburb']))  ) ? sanitize_text_field(wp_unslash($_REQUEST['searchSuburb'])) : '';
    if ($searchSuburb) {
        $resultAddress = $freightmate_api->search_suburb($freightmate_connection, ['filter' => $searchSuburb]);
    }
    echo wp_json_encode($resultAddress);
    exit;
}
add_action('wp_ajax_wp_createConsignment_ajax_action', 'freightmate_createConsignment_ajax_action_cb');
function freightmate_createConsignment_ajax_action_cb()
{
    $consignmentPayload = [
        "consignmentType" => 'DEFAULT',
        "items" => []
    ];
    $order_id = isset($_REQUEST['order_id']) ? absint($_REQUEST['order_id']) : '';
    $freightmateHasConsignment = freightmateCommonMethods::freightmateHasConsignment($order_id);
    if (isset($freightmateHasConsignment['status']) && $freightmateHasConsignment['status'] == true) {
        $reponse = [
            'status_code' => 400,
            'data' => [
                'validationErrors' => [
                    [
                        'message' => 'The consignment number <code>' . $freightmateHasConsignment['connoteNumber'] . '</code> for Order #' . $order_id . ' is already exists.'
                    ]
                ]
            ]
        ];
        echo wp_json_encode($reponse);
        exit;
    }

   // $items = isset($_REQUEST['item-type']) ? $_REQUEST['item-type'] : []; 
    
    $items = []; // Default to an empty array
    if (isset($_REQUEST['item-type'])) {
        // Fetch and sanitize the raw input
        $raw_items = filter_input(INPUT_POST, 'item-type', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY);

        if ($raw_items !== null && is_array($raw_items)) {
            // Remove slashes if magic quotes are applied (wp_unslash equivalent)
            $items = array_map('wp_unslash', $raw_items);
        }
    }
 
    $company = isset($_REQUEST['company']) ? sanitize_text_field(wp_unslash($_REQUEST['company'])) : '';
    $name = isset($_REQUEST['contact-name']) ? sanitize_text_field(wp_unslash($_REQUEST['contact-name'])) : '';
    $address_1 = isset($_REQUEST['address-1']) ? sanitize_text_field(wp_unslash($_REQUEST['address-1'])) : '';
    $phone = isset($_REQUEST['phone']) ? sanitize_text_field(wp_unslash($_REQUEST['phone'])) : '';
    $email = isset($_REQUEST['email']) ? sanitize_email(wp_unslash($_REQUEST['email'])) : '';
   // $suburb_postcode = isset($_REQUEST['suburb-postcode']) ? explode(', ', $_REQUEST['suburb-postcode'] ) : [];
    $raw_suburb_postcode = isset($_REQUEST['suburb-postcode']) ? sanitize_text_field(wp_unslash($_REQUEST['suburb-postcode'])) : '';
    $suburb_postcode = $raw_suburb_postcode 
    ? array_map('sanitize_text_field', explode(', ', $raw_suburb_postcode)) 
    : [];

    $specialInstructions = isset($_REQUEST['special-instructions']) ? sanitize_text_field(wp_unslash($_REQUEST['special-instructions'])) : '';
    $authorityToLeave = isset($_REQUEST['authority-to-leave']) ? sanitize_text_field(wp_unslash($_REQUEST['authority-to-leave'])) : false;
    $tailgate = isset($_REQUEST['tailgate']) ? sanitize_text_field(wp_unslash($_REQUEST['tailgate'])) : false;
    $offerSelection = isset($_REQUEST['carrier-type']) ? sanitize_text_field(wp_unslash($_REQUEST['carrier-type'])) : 'CHEAPEST';
   // $selected_offer = isset($_REQUEST['select_offer']) ? explode('#', $_REQUEST['select_offer']) : [];
    $raw_select_offer = isset($_REQUEST['select_offer']) ? sanitize_text_field(wp_unslash($_REQUEST['select_offer'])) : '';
    $selected_offer = $raw_select_offer 
    ? array_map('sanitize_text_field', explode('#', $raw_select_offer)) 
    : [];


    if ($offerSelection ==  'OFFERS' && $selected_offer) {
        $consignmentPayload['carrierName'] = $selected_offer[0] ? $selected_offer[0] : '';
        $consignmentPayload['serviceTypeName'] = $selected_offer[1] ? $selected_offer[1] : '';
    }
    $inputDispatchDateString = isset($_REQUEST['dispatch-date']) ? sanitize_text_field(wp_unslash($_REQUEST['dispatch-date'])) : '';
    $inputDispatchDateObj = new DateTime($inputDispatchDateString);
    $dispatchDate = $inputDispatchDateObj->format('Y-m-d\TH:i:s') . '.000Z';
    $consignmentPayload['dispatchedAt'] = $dispatchDate;
    $consignmentPayload['authorityToLeave'] = $authorityToLeave == 'on' ? true : false;
    $consignmentPayload['tailgateRequired'] = $tailgate == 'on' ? true : false;
    $consignmentPayload['specialInstructions'] = $specialInstructions;
    $consignmentPayload['consignmentReferences'][] = 'Order#' . $order_id;
    $consignmentPayload['deliveryAddress'] = [
        'company' => $company,
        'addressLine1' => $address_1,
        'contactName' => $name,
        'phoneNumber' => $phone,
        'email' => $email,
        'specialInstructions' => $specialInstructions,
        'addressClass' => 'RESIDENTIAL',
        'suburb' => [
            'name' => $suburb_postcode[0],
            'postcode' => intval($suburb_postcode[1])
        ]
    ];
    $consignmentPayload['items'] = $items;
    $isCreated = true;
    $retryLimit = 5;
    $retry = 1;
    do{
        // Initialize Freightmate API connection
        $freightmate_connection = new Freightmate_API_Connection(FREIGHTMATE_API_URL);
        $freightmate_api = new Freightmate_Rest_Api($freightmate_connection);
        $consignmentResult = $freightmate_api->create_consignment($freightmate_connection, wp_json_encode($consignmentPayload));
        $connoteNumber = (isset($consignmentResult['data']) && isset($consignmentResult['data']['connoteNumber'])) ? $consignmentResult['data']['connoteNumber'] : null;
        if( $connoteNumber != null ){
            $isCreated = false;
        }
        $retry++;
        sleep(2);
    }while($isCreated && $retry < $retryLimit );
    $consignmentResult['retry'] = $retry;
    $connoteId = isset($consignmentResult['data']) && isset($consignmentResult['data']['id']) ?  $consignmentResult['data']['id'] : '';
    if ($order_id && $connoteNumber != null ) {
        update_post_meta($order_id, FREIGHTMATE_META_PREFIX . 'consignment_result', $consignmentResult);
        update_post_meta($order_id, FREIGHTMATE_META_PREFIX . 'consignment_connoteNumber', $connoteNumber);
        update_post_meta($order_id, FREIGHTMATE_META_PREFIX . 'consignment_connoteId', $connoteId);
        if ($connoteNumber) {
            update_post_meta($order_id, FREIGHTMATE_META_PREFIX . 'is_consignment_created', true);
            update_post_meta($order_id, FREIGHTMATE_META_PREFIX . 'consignment_created_at', gmdate('Y-m-d h:i:s', time()));
        }
        update_post_meta($order_id, FREIGHTMATE_META_PREFIX . 'create_consignment_api_response', wp_json_encode($consignmentResult));
    }
    $consignmentResult['isCreated'] = $connoteNumber != null ? true : false;
    echo wp_json_encode($consignmentResult);
    exit;
}
add_action('wp_ajax_wp_checkOffers_ajax_action', 'freightmate_checkOffers_ajax_action_cb');
function freightmate_checkOffers_ajax_action_cb()
{
    $offerArrayData = [
        "isDeliverySuburbResidential" => true,
        "authorityToLeave" => false,
        "tailgateRequired" => false,
        "items" => []
    ];

   // $items = isset($_REQUEST['item-type']) ? $_REQUEST['item-type'] : []; 

    $items = []; // Default to an empty array

    if (isset($_REQUEST['item-type'])) {
        // Fetch and sanitize the raw input
        $raw_items = filter_input(INPUT_POST, 'item-type', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY);

        if ($raw_items !== null && is_array($raw_items)) {
            // Remove slashes if magic quotes are applied (wp_unslash equivalent)
            $items = array_map('wp_unslash', $raw_items);
        }
    }

    $clientId = isset($_REQUEST['sender-clientId']) ? sanitize_text_field(wp_unslash($_REQUEST['sender-clientId'])) : '';
   // $suburb_postcode = isset($_REQUEST['suburb-postcode']) ? explode(', ', $_REQUEST['suburb-postcode']) : [];
    $raw_suburb_postcode = isset($_REQUEST['suburb-postcode']) ? sanitize_text_field(wp_unslash($_REQUEST['suburb-postcode'])) : '';
    $suburb_postcode = $raw_suburb_postcode 
    ? array_map('sanitize_text_field', explode(', ', $raw_suburb_postcode)) 
    : [];

    $authorityToLeave = ( isset($_REQUEST['authority-to-leave']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_REQUEST['authority-to-leave']))) ) ? wp_verify_nonce(sanitize_text_field(wp_unslash($_REQUEST['authority-to-leave']))) : false;
    $tailgate = ( isset($_REQUEST['tailgate']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_REQUEST['tailgate']))) )  ? wp_verify_nonce(sanitize_text_field(wp_unslash($_REQUEST['tailgate']))) : '';

    $offerArrayData['authorityToLeave'] = $authorityToLeave == 'on' ? true : false;
    $offerArrayData['tailgateRequired'] = $tailgate == 'on' ? true : false;
    $offerArrayData['senderAddressId'] = $clientId;

    $offerArrayData['deliverySuburb']['name'] = isset($suburb_postcode[0]) ? $suburb_postcode[0] : '';
    $offerArrayData['deliverySuburb']['postcode'] = isset($suburb_postcode[1]) ? intval($suburb_postcode[1]) : '';
    $offerArrayData['items'] = $items;
    // Initialize Freightmate API connection
    $freightmate_connection = new Freightmate_API_Connection(FREIGHTMATE_API_URL);
    $freightmate_api = new Freightmate_Rest_Api($freightmate_connection);
    //Search for Address
    $offerJsonData = isset($offerArrayData) ? wp_json_encode($offerArrayData) : '{}';
    if ($offerJsonData) {
        $offers = $freightmate_api->get_offers($freightmate_connection, $offerJsonData);
    }
    $isOffers = true;
    $retryLimit = 5;
    $retry = 1;
    do{
        $offers = $freightmate_api->get_offers($freightmate_connection, $offerJsonData);
        if( isset($offers['status_code']) && $offers['status_code'] == 200 ){
            $isOffers = false;
        }
        $retry++;
        sleep(2);
    }while($isOffers && $retry < $retryLimit);
    $offers['retry'] = $retry;
    echo wp_json_encode($offers);
    exit;
}

add_action('wp_ajax_wp_populate_dimentions_ajax_action', 'freightmate_populate_dimentions_ajax_action_cb');
function freightmate_populate_dimentions_ajax_action_cb()
{
    $post_id = isset($_REQUEST['post_id']) ? absint($_REQUEST['post_id']) : '';
    $freightmate_item_type = isset($_REQUEST['item_id']) ? sanitize_text_field(wp_unslash($_REQUEST['item_id'])) : '';
    $meta_item_type = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'item_type', true) ?? '';
    $isMutable = false;
    $length = $width = $height = $weight = 0;
    if ($freightmate_item_type && $isMutable == false) {
        $itemData = freightmateCommonMethods::getItems($freightmate_item_type);
        $length = isset($itemData['itemTemplate']['length']) ? $itemData['itemTemplate']['length'] : 0;
        $width = isset($itemData['itemTemplate']['width']) ? $itemData['itemTemplate']['width'] : 0;
        $height = isset($itemData['itemTemplate']['height']) ? $itemData['itemTemplate']['height'] : 0;
        $weight = isset($itemData['itemTemplate']['weight']) ? $itemData['itemTemplate']['weight'] : 0;
        $isMutable = isset($itemData['isMutable']) ? $itemData['isMutable'] : false;
        $itemTypeName = $itemData['type'] ?? '';
    }
    if ($freightmate_item_type == $meta_item_type && $isMutable == true) {
        $weight = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_weight', true) ?? 0;
        $length = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_length', true) ?? 0;
        $width = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_width', true) ?? 0;
        $height = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_height', true) ?? 0;
        $isMutable = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_isMutable', true) ?? true;
        $itemTypeName = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_item_type_name', true) ?? '';
    }
    $output = '';
    if ($isMutable == true) {
        $output .= '<p class="form-field _weight_field ">
                        <label for="freightmate_product_weight">Weight (kg)</label><input type="text" class="short wc_input_decimal"  name="freightmate_product_weight" id="freightmate_product_weight" value="' . $weight . '" placeholder="0" data-name="Items weight">
                    </p>
                    <p class="form-field dimensions_field">
                        <label for="freightmate_product_length">
                            Dimensions (mtr) </label>
                        <span class="wrap">
                            <input id="freightmate_product_length" placeholder="Length" class="input-text wc_input_decimal" size="6" type="text" name="freightmate_product_length" value="' . $length . '" data-name="Items length">
                            <input id="product_width" placeholder="Width" class="input-text wc_input_decimal" size="6" type="text" name="freightmate_product_width" value="' . $width . '" data-name="Items width">
                            <input id="product_height" placeholder="Height" class="input-text wc_input_decimal last" size="6" type="text" name="freightmate_product_height" value="' . $height . '" data-name="Items height">
                            <input type="hidden" name="freightmate_isMutable" value="' . $isMutable . '">
                            <input type="hidden" name="freightmate_product_item_type_name" value="' . $itemTypeName . '">
                        </span>
                    </p>';
    } else {
        $output .= '<p class="form-field _weight_field ">
                        <label for="freightmate_product_weight">Weight (kg)</label><input type="text" class="short wc_input_decimal"  name="freightmate_product_weight" id="freightmate_product_weight" value="' . $weight . '" placeholder="0" disabled>
                    </p>
                    <p class="form-field dimensions_field">
                        <label for="freightmate_product_length">
                            Dimensions (mtr) </label>
                        <span class="wrap">
                            <input id="freightmate_product_length" placeholder="Length" class="input-text wc_input_decimal" size="6" type="text" name="freightmate_product_length" value="' . $length . '" disabled>
                            <input id="product_width" placeholder="Width" class="input-text wc_input_decimal" size="6" type="text" name="freightmate_product_width" value="' . $width . '" disabled>
                            <input id="product_height" placeholder="Height" class="input-text wc_input_decimal last" size="6" type="text" name="freightmate_product_height" value="' . $height . '" disabled>
                            <input type="hidden" name="freightmate_isMutable" value="' . $isMutable . '">
                            <input type="hidden" name="freightmate_product_weight" value="' . $weight . '">
                            <input type="hidden" name="freightmate_product_length" value="' . $length . '">
                            <input type="hidden" name="freightmate_product_width" value="' . $width . '">
                            <input type="hidden" name="freightmate_product_height" value="' . $height . '">
                            <input type="hidden" name="freightmate_product_item_type_name" value="' . $itemTypeName . '">
                        </span>
                    </p>';
    }
    echo wp_json_encode(['status' => true, 'data' => $output]);
    exit;
}
add_action('wp_ajax_item_update_dimentions_ajax_action', 'item_update_dimentions_ajax_action_cb');
function item_update_dimentions_ajax_action_cb()
{
    $post_id = isset($_REQUEST['post_id']) ? absint($_REQUEST['post_id']) : '';
    $freightmate_item_type = isset($_REQUEST['item_id']) ? sanitize_text_field(wp_unslash($_REQUEST['item_id'])) : '';
    $meta_item_type = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'item_type', true) ?? '';
    // Initialize Freightmate API connection
    // $freightmate_connection = new Freightmate_API_Connection(FREIGHTMATE_API_URL);
    // $freightmate_api = new Freightmate_Rest_Api($freightmate_connection);
    $isMutable = false;
    $length = $width = $height = $weight = 0;
    if ($freightmate_item_type && $isMutable == false) {
        
        $itemData = freightmateCommonMethods::getItems($freightmate_item_type);
        $length = isset($itemData['itemTemplate']['length']) ? $itemData['itemTemplate']['length'] : 0;
        $width = isset($itemData['itemTemplate']['width']) ? $itemData['itemTemplate']['width'] : 0;
        $height = isset($itemData['itemTemplate']['height']) ? $itemData['itemTemplate']['height'] : 0;
        $weight = isset($itemData['itemTemplate']['weight']) ? $itemData['itemTemplate']['weight'] : 0;
        $isMutable = isset($itemData['isMutable']) ? $itemData['isMutable'] : false;
        $itemTypeId = isset($itemData['id']) ? $itemData['id'] : '';
        $itemTypeName = isset($itemData['type']) ? $itemData['type'] : '';
    }
    if ($freightmate_item_type == $meta_item_type && $isMutable == true) {
        $weight = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_weight', true) ?? 0;
        $length = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_length', true) ?? 0;
        $width = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_width', true) ?? 0;
        $height = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_height', true) ?? 0;
        $isMutable = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_isMutable', true) ?? true;
        $itemTypeName = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'product_item_type_name', true) ?? '';
        $itemTypeId = get_post_meta($post_id, FREIGHTMATE_META_PREFIX . 'item_type', true) ?? '';
    }
    echo wp_json_encode(['status' => true, 'data' => [
        'length' => $length,
        'width' => $width,
        'weight' => $weight,
        'height' => $height,
        'itemTypeName' => $itemTypeName,
        'isMutable' => $isMutable,
        'itemTypeId' => $itemTypeId
    ]]);
    exit;
}
