<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 
class WooCommerceOrderRepository implements FreightmateOrderRepositoryInterface
{
    public function getOrderById($order_id)
    {
        return wc_get_order($order_id);
    }
    public function getOrderShippingData($order_id)
    {
        $order = $this->getOrderById($order_id);
        $shipping_data = [];
        $order_tailgate = false;
        foreach ($order->get_items() as $item_id => $item) {
            $product_id = $item->get_product_id();
            $product = wc_get_product($product_id);
            //Items meta data
            $weight = get_post_meta($product_id, FREIGHTMATE_META_PREFIX . 'product_weight', true) ?? 0;
            $length = get_post_meta($product_id, FREIGHTMATE_META_PREFIX . 'product_length', true) ?? 0;
            $width = get_post_meta($product_id, FREIGHTMATE_META_PREFIX . 'product_width', true) ?? 0;
            $height = get_post_meta($product_id, FREIGHTMATE_META_PREFIX . 'product_height', true) ?? 0;
            $isMutable = get_post_meta($product_id, FREIGHTMATE_META_PREFIX . 'product_isMutable', true) ?? true;
            $itemTypeName = get_post_meta($product_id, FREIGHTMATE_META_PREFIX . 'product_item_type_name', true) ?? '';
            $itemTypeId = get_post_meta($product_id, FREIGHTMATE_META_PREFIX . 'item_type', true) ?? '';
            $pm_tailgate = get_post_meta($product_id, FREIGHTMATE_META_PREFIX . 'product_tailgate', true);
            if( $pm_tailgate == 'on' ){
                $order_tailgate = true;
            }
            $shipping_data[] = [
                'item_id' => $item_id,
                'product_id' => $product_id,
                'name' => $item->get_name(),
                'quantity' => $item->get_quantity(),
                'weight' => $weight,
                'length' => $length,
                'width' => $width,
                'height' => $height,
                'isMutable' => $isMutable,
                'itemTypeName' => $itemTypeName,
                'itemTypeId' => $itemTypeId,
                'tailgate' => $pm_tailgate
            ];
        }

        // Add shipping details to the array
        $full_name = trim($order->get_shipping_first_name() . ' ' . $order->get_shipping_last_name());
        $shipping_details = [
            'name' => $full_name,
            'company' => $order->get_shipping_company(),
            'address_1' => $order->get_shipping_address_1(),
            'address_2' => $order->get_shipping_address_2(),
            'city' => $order->get_shipping_city(),
            'state' => $order->get_shipping_state(),
            'postcode' => $order->get_shipping_postcode(),
            'country' => $order->get_shipping_country(),
            'shipping_method' => $order->get_shipping_method(),
            'email' => $order->get_billing_email(),
            'phone' => $order->get_shipping_phone(),
            'tailgate' => $order_tailgate
        ];
        return [
            'data' => $shipping_data,
            'address' => $shipping_details,
        ];
    }
}
