<?php
/*
Plugin Name: Freightmate for WooCommerce
Plugin URI: https://www.freightmate.com/
Description: Extend WooCommerce functionality with Freightmate for WooCommerce.
Author: Freightmate Systems Pty Ltd
Author URI: https://profiles.wordpress.org/freightmate/
Version: 1.0.4
Text Domain: freightmate-for-woocommerce
License: GPL v2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Requires Plugins: woocommerce
*/
// If this file is called directly, abort.
if (!defined('ABSPATH')) {
    exit;
}
// Define plugin constants
define('FREIGHTMATE_APP_VERSION', '1.0.0');
define('FREIGHTMATE_APP_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('FREIGHTMATE_APP_PLUGIN_URL', plugin_dir_url(__FILE__));
define('FREIGHTMATE_META_PREFIX', 'freightmate_meta_');
define('FREIGHTMATE_OPTION_PREFIX', 'freightmate_option_');
$api_key = get_option(FREIGHTMATE_OPTION_PREFIX . 'client_api_key');
$password = get_option(FREIGHTMATE_OPTION_PREFIX . 'client_password');
$environment_type = get_option(FREIGHTMATE_OPTION_PREFIX . 'environment_type');
$live_api_url = get_option(FREIGHTMATE_OPTION_PREFIX . 'live_api_url');
$stage_api_url = get_option(FREIGHTMATE_OPTION_PREFIX . 'stage_api_url');
$environment_type = $environment_type ? $environment_type : '';
$api_url = $stage_api_url ? $stage_api_url : ''; //https://api.sit.staging.freightmate.com/
if( $environment_type == 'LIVE' ){
    $api_url = $live_api_url;
}
$freightmate_tracking_url = 'https://sit.staging.freightmate.com';
if( $environment_type == 'LIVE' ){
    $freightmate_tracking_url = 'https://freightmate.com';
}
define('FREIGHTMATE_ENV', $environment_type);
define('FREIGHTMATE_API_KEY', $api_key);
define('FREIGHTMATE_API_SECRET', base64_decode($password));
define('FREIGHTMATE_API_URL', $api_url);
define('FREIGHTMATE_TRACKING_URL', $freightmate_tracking_url);

require_once FREIGHTMATE_APP_PLUGIN_DIR . 'includes/class-freightmate-logger.php';
require_once FREIGHTMATE_APP_PLUGIN_DIR . 'class-freightmate-activator.php';
require_once FREIGHTMATE_APP_PLUGIN_DIR . 'includes/class-freightmate-wp-hooks.php';
require_once FREIGHTMATE_APP_PLUGIN_DIR . 'includes/OrderRepositoryInterface.php';
require_once FREIGHTMATE_APP_PLUGIN_DIR . 'includes/WooCommerceOrderRepository.php';
require_once FREIGHTMATE_APP_PLUGIN_DIR . 'includes/OrderService.php';
require_once FREIGHTMATE_APP_PLUGIN_DIR . 'includes/class-freightmate-order-list-table.php';
require_once FREIGHTMATE_APP_PLUGIN_DIR . 'includes/class-freightmate-consignment-list-table.php';
require_once FREIGHTMATE_APP_PLUGIN_DIR . 'includes/class-freightmate-manifest-list-table.php';
require_once FREIGHTMATE_APP_PLUGIN_DIR . 'includes/class-freightmate-option-page.php';
require_once FREIGHTMATE_APP_PLUGIN_DIR . 'includes/class-freightmate-connect.php';
require_once FREIGHTMATE_APP_PLUGIN_DIR . 'includes/class-freightmate-rest-api.php';
require_once FREIGHTMATE_APP_PLUGIN_DIR . 'includes/class-freightmate-ajax-actions.php';
require_once FREIGHTMATE_APP_PLUGIN_DIR . 'includes/class-freightmate-common-methods.php';
require_once FREIGHTMATE_APP_PLUGIN_DIR . 'includes/interface-freightmate-product-configuration-interface.php';
require_once FREIGHTMATE_APP_PLUGIN_DIR . 'includes/class-freightmate-product-configuration.php';




add_action('admin_notices', 'freightmate_admin_notice_woocomerce_missing');
function freightmate_admin_notice_woocomerce_missing()
{
    $freightmate_connection = new Freightmate_API_Connection(FREIGHTMATE_API_URL);
    $freightmate_api = new Freightmate_Rest_Api($freightmate_connection);
    $is_freightmate_connected = $freightmate_api->get_items($freightmate_connection);
    if (!class_exists('WooCommerce')) {
        deactivate_plugins(plugin_basename(__FILE__));
        $search_term = "woocommerce";
        $plugin_search_url = add_query_arg(
            array(
                's'    => $search_term,
                'tab'  => 'search',
                'type' => 'term'
            ),
            admin_url('plugin-install.php')
        );
        echo '<div class="freightmat-admin-pages"><div class="freightmat-error"><p><strong>';
        printf(
            /* translators: %s WooCommerce download URL link. */
            esc_html__('Freightmate WooCommerce App requires WooCommerce to be installed and active. You can download %s here.', 'freightmate-for-woocommerce'),
            '<a href="'.esc_html($plugin_search_url).'" target="_blank">WooCommerce</a>'
        );
        echo '</strong></p></div></div>';
    }elseif( FREIGHTMATE_API_KEY == '' || FREIGHTMATE_API_SECRET == '' || FREIGHTMATE_ENV == '' || FREIGHTMATE_API_URL == '' ){
        echo '<div class="freightmat-admin-pages"><div class="freightmat-error"><p><strong>';
        printf(
            esc_html__('Please configure the API Key, API URL, Environment type and Password to connect with Freightmate and utilize the features of this Freightmate extension for WooCommerce.', 'freightmate-for-woocommerce'),
            ''
        );
        echo '</strong></p></div></div>';
    }elseif( isset($is_freightmate_connected['status_code']) && $is_freightmate_connected['status_code'] && $is_freightmate_connected['status_code'] != 200 ){
        $error_message = isset($is_freightmate_connected['error']) ? $is_freightmate_connected['error'] : '';
        echo '<div class="freightmat-admin-pages"><div class="freightmat-error"><p><strong>';
        /*printf(
            esc_html__($error_message, 'freightmate-for-woocommerce'),
            ''
        );*/

        /* translators: %1$s is the error message */
        printf( esc_html__( 'Error: %1$s', 'freightmate-for-woocommerce'), esc_html( $error_message ) );

        echo '</strong></p></div></div>';
    }
}
register_activation_hook(__FILE__, array('Freightmate_WooCommerce_Activator', 'activate'));
