=== Freightmate for WooCommerce ===
Contributors: freightmate
Tags: WooCommerce, shipping, freight, consignment, tracking
Requires at least: 6.5
Tested up to: 6.7.1
Requires PHP: 8.0.30
Stable tag: 1.0.4
License: GPLv2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html

This plugin allows you to create consignments and manifests for WooCommerce orders, track orders, and apply various shipping options during checkout.

== Description ==

The Freightmate for WooCommerce enables you to streamline your shipping process by creating consignments and manifests for your WooCommerce orders. You can track orders using the consignment number via a tracking page created in the admin panel. The plugin provides three shipping options: "WooCommerce calculated", "Freightmate Calculated", and "Freightmate Charges + Markup", which are applied during the WooCommerce checkout process.

### API Usage

When using this plugin, you may need to create a Freightmate account to access its services. Here are key functionalities supported by the plugin:

- **Tracking Consignment Status:** The plugin allows you to track your consignments in real-time by retrieving information from the Freightmate servers.
- **Proof of Delivery (POD):** Consignment details, including links to Proof of Delivery images, are fetched from the Freightmate API. For example:
"https://freightmate.com/customerassets/241/pod/2024/06/13/YTOZ00028293-054527.png"


== Installation ==

1. Download the plugin from wordpress.org.
2. Upload the zip file from WP admin by clicking on "Add New Plugin".
3. Activate the plugin through the 'Plugins' screen in WordPress.
4. Create a Freightmate account if you do not have one.
5. Create a client account within Freightmate to start using the plugin.

== Frequently Asked Questions ==

= How do I track my orders? =

You can track your orders using the consignment number on the tracking page created in the admin panel.

= What are the shipping options provided by the plugin? =

The plugin provides three shipping options: "WooCommerce calculated", "Freightmate Calculated", and "Freightmate Charges + Markup".

= Do I need a Freightmate account to use the plugin? =

Yes, you need a Freightmate account and you must create a client account within Freightmate to use the plugin.

== Screenshots ==

1. Configure your Freightmate account to access features for WooCommerce.
2. Freightmate dashboard displaying the count of WooCommerce orders, consignments, and manifests.
3. WooCommerce orders listing page screen.
4. Example of the consignment creation screen.
5. Example of the consignments listing page screen.
6. Example of the manifest creation screen.
7. Settings for Freightmate shipping options for WooCommerce checkout and uninstall/revoke Freightmate account.
8. Example of the manifests listing page screen.
9. Example of the track and trace page screen.


== Changelog ==

= 1.0.0 =
* Initial release.

= 1.0.1 =
* Initial release changes.

= 1.0.2 =
* Price fall back changes
* Validation corrections.

== Upgrade Notice ==

= 1.0.1 =
Initial release changes.

= 1.0.2 =
* Price fall back changes
* Validation corrections.

= 1.0.3 =
* shipping price changes.

= 1.0.4 =
* Manifest List fixes.

== Features ==

* Create consignments and manifests for WooCommerce orders.
* Track orders using consignment numbers.
* Three shipping options: "WooCommerce calculated", "Freightmate Calculated", and "Freightmate Charges + Markup".
* Seamless integration with WooCommerce checkout process.

== Further Reading ==

For more information, visit [documentation](https://www.freightmate.com/login) and [link to support forum](https://www.freightmate.com/login).
