<?php
/**
 * Uninstall script for FreedomReader
 *
 * @package FreedomReader
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Check if user wants to keep data.
$keep_data = get_option( 'freedomreader_keep_data_on_uninstall', 0 );
if ( $keep_data ) {
	// User wants to keep data, only remove plugin options but preserve transaction data.
	$plugin_options = array(
		'freedomreader_paypal_mode',
		'freedomreader_paypal_client_id',
		'freedomreader_paypal_client_secret',
		'freedomreader_currency',
		'freedomreader_trial_days',
		'freedomreader_unlock_button_text',
		'freedomreader_teaser_message',
		'freedomreader_auto_cleanup',
		'freedomreader_export_format',
		'freedomreader_backup_frequency',
		'freedomreader_support_notice_dismissed',
		'freedomreader_version',
	);

	foreach ( $plugin_options as $option ) {
		delete_option( $option );
	}

	// Keep the data preservation setting for future reinstalls.
	// Keep all transaction tables and content locks.
	return;
}

// Check if user has permission to delete plugins.
if ( ! current_user_can( 'delete_plugins' ) ) {
	exit;
}

// Get option to keep data on uninstall.
$keep_data = get_option( 'freedomreader_keep_data_on_uninstall', false );

if ( ! $keep_data ) {
	global $wpdb;

	// Delete plugin tables.
	$tables = array(
		$wpdb->prefix . 'freedo_purchases',
		$wpdb->prefix . 'freedo_subscriptions',
		$wpdb->prefix . 'freedo_content_locks',
		$wpdb->prefix . 'freedo_payment_logs',
	);

	foreach ( $tables as $table ) {
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Plugin uninstall cleanup, table names cannot be prepared
		$wpdb->query( "DROP TABLE IF EXISTS `{$table}`" );
	}

	// Delete plugin options.
	$options = array(
		'freedomreader_paypal_mode',
		'freedomreader_paypal_client_id',
		'freedomreader_paypal_client_secret',
		'freedomreader_currency',
		'freedomreader_trial_days',
		'freedomreader_unlock_button_text',
		'freedomreader_teaser_message',
		'freedomreader_subscription_plans',
		'freedomreader_db_version',
		'freedomreader_keep_data_on_uninstall',
	);

	foreach ( $options as $option ) {
		delete_option( $option );
	}

	// Delete user meta related to plugin.
	// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Plugin uninstall cleanup with prepared statement
	$wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->usermeta} WHERE meta_key LIKE %s", 'freedomreader_%' ) );

	// Delete post meta related to plugin.
	// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Plugin uninstall cleanup with prepared statement
	$wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE %s", 'freedomreader_%' ) );

	// Clear any cached data.
	wp_cache_flush();
}
