<?php
/**
 * Subscription Success Template
 *
 * @package FreedomReader
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="fr-subscription-success-page">
	<div class="fr-success-container">
		<div class="fr-success-icon">
			✅
		</div>
		
		<h1><?php esc_html_e( 'Subscription Successful!', 'freedomreader' ); ?></h1>

		<div class="fr-success-message">
			<p><?php esc_html_e( 'Thank you for subscribing! Your subscription has been activated and you now have access to all premium content.', 'freedomreader' ); ?></p>
			
			<?php if ( $subscription_id ) : ?>
				<p class="fr-subscription-id">
					<?php
					/* translators: %s: subscription ID */
					printf( esc_html__( 'Subscription ID: %s', 'freedomreader' ), '<code>' . esc_html( $subscription_id ) . '</code>' );
					?>
				</p>
			<?php endif; ?>
		</div>
		
		<div class="fr-success-actions">
			<a href="<?php echo esc_url( home_url( '/freedomreader/dashboard/' ) ); ?>" class="fr-btn fr-btn-primary">
				<?php esc_html_e( 'Go to Dashboard', 'freedomreader' ); ?>
			</a>

			<a href="<?php echo esc_url( home_url() ); ?>" class="fr-btn fr-btn-secondary">
				<?php esc_html_e( 'Browse Content', 'freedomreader' ); ?>
			</a>
		</div>
		
		<div class="fr-next-steps">
			<h3><?php esc_html_e( 'What\'s Next?', 'freedomreader' ); ?></h3>
			<ul>
				<li><?php esc_html_e( 'Access all premium content on the site', 'freedomreader' ); ?></li>
				<li><?php esc_html_e( 'Manage your subscription from your dashboard', 'freedomreader' ); ?></li>
				<li><?php esc_html_e( 'Download invoices for your records', 'freedomreader' ); ?></li>
				<li><?php esc_html_e( 'Cancel anytime from your account settings', 'freedomreader' ); ?></li>
			</ul>
		</div>
	</div>
</div>

<?php
// Enqueue subscription success page styles
$subscription_success_css = '
.fr-subscription-success-page {
	max-width: 600px;
	margin: 40px auto;
	padding: 20px;
	text-align: center;
}

.fr-success-container {
	background: #fff;
	border: 1px solid #e9ecef;
	border-radius: 12px;
	padding: 40px;
	box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

.fr-success-icon {
	font-size: 64px;
	margin-bottom: 20px;
}

.fr-success-container h1 {
	color: #28a745;
	margin-bottom: 20px;
	font-size: 28px;
}

.fr-success-message {
	margin-bottom: 30px;
	color: #495057;
	line-height: 1.6;
}

.fr-subscription-id {
	background: #f8f9fa;
	padding: 10px;
	border-radius: 6px;
	font-size: 14px;
	margin-top: 15px;
}

.fr-success-actions {
	margin-bottom: 30px;
}

.fr-btn {
	display: inline-block;
	padding: 12px 24px;
	margin: 0 10px;
	text-decoration: none;
	border-radius: 6px;
	font-weight: 600;
	transition: all 0.3s ease;
}

.fr-btn-primary {
	background: #007cba;
	color: #fff;
}

.fr-btn-primary:hover {
	background: #005a87;
	transform: translateY(-1px);
}

.fr-btn-secondary {
	background: #6c757d;
	color: #fff;
}

.fr-btn-secondary:hover {
	background: #545b62;
	transform: translateY(-1px);
}

.fr-next-steps {
	background: #f8f9fa;
	border-radius: 8px;
	padding: 20px;
	text-align: left;
}

.fr-next-steps h3 {
	margin: 0 0 15px 0;
	color: #495057;
	text-align: center;
}

.fr-next-steps ul {
	list-style: none;
	padding: 0;
	margin: 0;
}

.fr-next-steps li {
	padding: 8px 0;
	border-bottom: 1px solid #e9ecef;
	position: relative;
	padding-left: 25px;
}

.fr-next-steps li:last-child {
	border-bottom: none;
}

.fr-next-steps li::before {
	content: "✓";
	position: absolute;
	left: 0;
	color: #28a745;
	font-weight: bold;
}

@media (max-width: 768px) {
	.fr-subscription-success-page {
		margin: 20px auto;
		padding: 15px;
	}

	.fr-success-container {
		padding: 30px 20px;
	}

	.fr-success-container h1 {
		font-size: 24px;
	}

	.fr-btn {
		display: block;
		margin: 10px 0;
	}
}';
wp_add_inline_style( 'freedomreader-frontend', $subscription_success_css );
?>
