<?php
/**
 * Subscription Cancelled Template
 *
 * @package FreedomReader
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="fr-subscription-cancelled-page">
	<div class="fr-cancelled-container">
		<div class="fr-cancelled-icon">
			❌
		</div>
		
		<h1><?php esc_html_e( 'Subscription Cancelled', 'freedomreader' ); ?></h1>

		<div class="fr-cancelled-message">
			<p><?php esc_html_e( 'Your subscription process was cancelled. No charges have been made to your account.', 'freedomreader' ); ?></p>
			<p><?php esc_html_e( 'If you changed your mind, you can still subscribe to access premium content.', 'freedomreader' ); ?></p>
		</div>
		
		<div class="fr-cancelled-actions">
			<a href="<?php echo esc_url( home_url( '/freedomreader/subscription/' ) ); ?>" class="fr-btn fr-btn-primary">
				<?php esc_html_e( 'Try Again', 'freedomreader' ); ?>
			</a>

			<a href="<?php echo esc_url( home_url() ); ?>" class="fr-btn fr-btn-secondary">
				<?php esc_html_e( 'Browse Content', 'freedomreader' ); ?>
			</a>
		</div>
		
		<div class="fr-help-section">
			<h3><?php esc_html_e( 'Need Help?', 'freedomreader' ); ?></h3>
			<p><?php esc_html_e( 'If you experienced any issues during the subscription process, please contact our support team.', 'freedomreader' ); ?></p>
			<a href="mailto:support@example.com" class="fr-contact-link">
				<?php esc_html_e( 'Contact Support', 'freedomreader' ); ?>
			</a>
		</div>
	</div>
</div>


