<?php
/**
 * User Dashboard Template
 *
 * @package FreedomReader
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="fr-user-dashboard-page">
	<div class="fr-dashboard-header">
		<h1><?php esc_html_e( 'My Dashboard', 'freedomreader' ); ?></h1>
		<p>
		<?php
		/* translators: %s: user display name */
		printf( esc_html__( 'Welcome back, %s!', 'freedomreader' ), esc_html( $user->display_name ) );
		?>
		</p>
	</div>
	
	<div class="fr-dashboard-grid">
		
		<!-- Account Overview -->
		<div class="fr-dashboard-section fr-account-overview">
			<h2><?php esc_html_e( 'Account Overview', 'freedomreader' ); ?></h2>
			
			<div class="fr-account-stats">
				<div class="fr-stat-item">
					<div class="fr-stat-label"><?php esc_html_e( 'Total Purchases', 'freedomreader' ); ?></div>
					<div class="fr-stat-value"><?php echo esc_html( count( $purchases ) ); ?></div>
				</div>
				
				<div class="fr-stat-item">
					<div class="fr-stat-label"><?php esc_html_e( 'Account Status', 'freedomreader' ); ?></div>
					<div class="fr-stat-value">
						<?php
						if ( $subscription ) {
							echo '<span class="fr-status-' . esc_attr( $subscription->status ) . '">' . esc_html( ucfirst( $subscription->status ) ) . '</span>';
						} else {
							echo '<span class="fr-status-basic">' . esc_html__( 'Basic', 'freedomreader' ) . '</span>';
						}
						?>
					</div>
				</div>
				
				<div class="fr-stat-item">
					<div class="fr-stat-label"><?php esc_html_e( 'Member Since', 'freedomreader' ); ?></div>
					<div class="fr-stat-value"><?php echo esc_html( gmdate( 'M Y', strtotime( $user->user_registered ) ) ); ?></div>
				</div>
			</div>
		</div>
		
		<!-- Subscription Status -->
		<?php if ( $subscription ) : ?>
		<div class="fr-dashboard-section fr-subscription-status">
			<h2><?php esc_html_e( 'Subscription Status', 'freedomreader' ); ?></h2>
			
			<div class="fr-subscription-card">
				<div class="fr-subscription-info">
					<div class="fr-subscription-plan">
						<?php
						$subscription_plans = get_option( 'freedomreader_subscription_plans', array() );
						$plan_name          = isset( $subscription_plans[ $subscription->plan_id ] )
							? $subscription_plans[ $subscription->plan_id ]['name']
							: $subscription->plan_id;
						echo esc_html( $plan_name );
						?>
					</div>
					
					<div class="fr-subscription-status-badge fr-status-<?php echo esc_attr( $subscription->status ); ?>">
						<?php echo esc_html( ucfirst( $subscription->status ) ); ?>
					</div>
				</div>
				
				<?php if ( 'trial' === $subscription->status && $subscription->trial_ends_at ) : ?>
					<div class="fr-trial-info">
						<?php
						$days_left = ceil( ( strtotime( $subscription->trial_ends_at ) - time() ) / ( 60 * 60 * 24 ) );
						if ( $days_left > 0 ) {
							/* translators: %d: number of days left in trial */
							printf( esc_html__( 'Your free trial ends in %d days', 'freedomreader' ), intval( $days_left ) );
						} else {
							esc_html_e( 'Your free trial has ended', 'freedomreader' );
						}
						?>
					</div>
				<?php endif; ?>
				
				<?php if ( $subscription->next_billing_date ) : ?>
					<div class="fr-billing-info">
						<?php
						/* translators: %s: next billing date */
						printf( esc_html__( 'Next billing date: %s', 'freedomreader' ), esc_html( gmdate( 'F j, Y', strtotime( $subscription->next_billing_date ) ) ) );
						?>
					</div>
				<?php endif; ?>
				
				<?php if ( 'active' === $subscription->status ) : ?>
					<div class="fr-subscription-actions">
						<button class="fr-cancel-subscription fr-btn-danger" data-subscription-id="<?php echo esc_attr( $subscription->id ); ?>">
							<?php esc_html_e( 'Cancel Subscription', 'freedomreader' ); ?>
						</button>
					</div>
				<?php endif; ?>
			</div>
		</div>
		<?php else : ?>
		<div class="fr-dashboard-section fr-no-subscription">
			<h2><?php esc_html_e( 'Upgrade Your Account', 'freedomreader' ); ?></h2>
			<p><?php esc_html_e( 'Subscribe to get unlimited access to all premium content.', 'freedomreader' ); ?></p>

			<?php
				$subscription_plans = get_option( 'freedomreader_subscription_plans', array() );
			if ( ! empty( $subscription_plans ) ) :
				?>
				<div class="fr-upgrade-plans">
				<?php foreach ( $subscription_plans as $plan_id => $plan ) : ?>
						<div class="fr-upgrade-plan">
							<h3><?php echo esc_html( $plan['name'] ); ?></h3>
							<div class="fr-plan-price">$<?php echo esc_html( $plan['price'] ); ?>/<?php echo esc_html( $plan['interval'] ); ?></div>
							<button class="fr-subscribe-btn" data-plan-id="<?php echo esc_attr( $plan_id ); ?>">
								<?php esc_html_e( 'Subscribe Now', 'freedomreader' ); ?>
							</button>
						</div>
					<?php endforeach; ?>
				</div>
			<?php endif; ?>
		</div>
		<?php endif; ?>
		
		<!-- Recent Purchases -->
		<div class="fr-dashboard-section fr-recent-purchases">
			<h2><?php esc_html_e( 'Recent Purchases', 'freedomreader' ); ?></h2>
			
			<?php if ( ! empty( $purchases ) ) : ?>
				<div class="fr-purchases-list">
					<?php foreach ( array_slice( $purchases, 0, 5 ) as $purchase ) : ?>
						<div class="fr-purchase-item">
							<div class="fr-purchase-content">
								<div class="fr-purchase-title">
									<?php
									if ( $purchase->post_id ) {
										$post_title = get_the_title( $purchase->post_id );
										$post_url   = get_permalink( $purchase->post_id );
										echo '<a href="' . esc_url( $post_url ) . '">' . esc_html( $post_title ) . '</a>';
									} else {
										echo esc_html( 'subscription' === $purchase->purchase_type ? esc_html__( 'Subscription', 'freedomreader' ) : esc_html__( 'Content Purchase', 'freedomreader' ) );
									}
									?>
								</div>
								<div class="fr-purchase-meta">
									<span class="fr-purchase-date"><?php echo esc_html( gmdate( 'M j, Y', strtotime( $purchase->created_at ) ) ); ?></span>
									<span class="fr-purchase-type"><?php echo esc_html( ucfirst( $purchase->purchase_type ) ); ?></span>
								</div>
							</div>
							<div class="fr-purchase-amount">
								$<?php echo esc_html( number_format( $purchase->amount, 2 ) ); ?>
							</div>
							<div class="fr-purchase-actions">
								<a href="<?php echo esc_url( wp_nonce_url( admin_url( 'admin-ajax.php?action=freedomreader_download_invoice&purchase_id=' . intval( $purchase->id ) ), 'freedomreader_nonce', 'nonce' ) ); ?>"
									class="fr-download-invoice" target="_blank">
									<?php esc_html_e( 'Invoice', 'freedomreader' ); ?>
								</a>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
				
				<?php if ( count( $purchases ) > 5 ) : ?>
					<div class="fr-view-all">
						<a href="<?php echo esc_url( home_url( '/freedomreader/purchases/' ) ); ?>" class="fr-btn-secondary">
							<?php esc_html_e( 'View All Purchases', 'freedomreader' ); ?>
						</a>
					</div>
				<?php endif; ?>
				
			<?php else : ?>
				<div class="fr-no-purchases">
					<p><?php esc_html_e( 'You haven\'t made any purchases yet.', 'freedomreader' ); ?></p>
					<a href="<?php echo esc_url( home_url() ); ?>" class="fr-btn-primary">
						<?php esc_html_e( 'Browse Content', 'freedomreader' ); ?>
					</a>
				</div>
			<?php endif; ?>
		</div>
		
		<!-- Quick Actions -->
		<div class="fr-dashboard-section fr-quick-actions">
			<h2><?php esc_html_e( 'Quick Actions', 'freedomreader' ); ?></h2>

			<div class="fr-actions-grid">
				<a href="<?php echo esc_url( home_url( '/freedomreader/purchases/' ) ); ?>" class="fr-action-item">
					<div class="fr-action-icon">📄</div>
					<div class="fr-action-label"><?php esc_html_e( 'View All Purchases', 'freedomreader' ); ?></div>
				</a>

				<a href="<?php echo esc_url( home_url( '/freedomreader/subscription/' ) ); ?>" class="fr-action-item">
					<div class="fr-action-icon">⚙️</div>
					<div class="fr-action-label"><?php esc_html_e( 'Manage Subscription', 'freedomreader' ); ?></div>
				</a>

				<a href="<?php echo esc_url( wp_get_current_user()->user_email ? 'mailto:' . antispambot( wp_get_current_user()->user_email ) : '#' ); ?>" class="fr-action-item">
					<div class="fr-action-icon">📧</div>
					<div class="fr-action-label"><?php esc_html_e( 'Contact Support', 'freedomreader' ); ?></div>
				</a>

				<a href="<?php echo esc_url( wp_logout_url( home_url() ) ); ?>" class="fr-action-item">
					<div class="fr-action-icon">🚪</div>
					<div class="fr-action-label"><?php esc_html_e( 'Logout', 'freedomreader' ); ?></div>
				</a>
			</div>
		</div>
		
	</div>
</div>

<style>
.fr-user-dashboard-page {
	max-width: 1200px;
	margin: 0 auto;
	padding: 20px;
}

.fr-dashboard-header {
	text-align: center;
	margin-bottom: 40px;
	padding-bottom: 20px;
	border-bottom: 1px solid #e9ecef;
}

.fr-dashboard-header h1 {
	margin: 0 0 10px 0;
	color: #212529;
}

.fr-dashboard-grid {
	display: grid;
	grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
	gap: 30px;
}

.fr-dashboard-section {
	background: #fff;
	border: 1px solid #e9ecef;
	border-radius: 8px;
	padding: 25px;
}

.fr-dashboard-section h2 {
	margin: 0 0 20px 0;
	font-size: 20px;
	color: #212529;
	border-bottom: 1px solid #f8f9fa;
	padding-bottom: 10px;
}

.fr-account-stats {
	display: grid;
	grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
	gap: 20px;
}

.fr-stat-item {
	text-align: center;
}

.fr-stat-label {
	font-size: 12px;
	color: #6c757d;
	text-transform: uppercase;
	letter-spacing: 0.5px;
	margin-bottom: 5px;
}

.fr-stat-value {
	font-size: 24px;
	font-weight: bold;
	color: #007cba;
}

.fr-status-active { color: #28a745; }
.fr-status-trial { color: #ffc107; }
.fr-status-cancelled { color: #dc3545; }
.fr-status-basic { color: #6c757d; }

.fr-subscription-card {
	background: #f8f9fa;
	border-radius: 6px;
	padding: 20px;
}

.fr-subscription-info {
	display: flex;
	justify-content: space-between;
	align-items: center;
	margin-bottom: 15px;
}

.fr-subscription-plan {
	font-size: 18px;
	font-weight: 600;
	color: #212529;
}

.fr-subscription-status-badge {
	padding: 4px 12px;
	border-radius: 20px;
	font-size: 12px;
	font-weight: 600;
	text-transform: uppercase;
}

.fr-subscription-status-badge.fr-status-active {
	background: #d4edda;
	color: #155724;
}

.fr-subscription-status-badge.fr-status-trial {
	background: #fff3cd;
	color: #856404;
}

.fr-trial-info, .fr-billing-info {
	font-size: 14px;
	color: #6c757d;
	margin-bottom: 10px;
}

.fr-subscription-actions {
	margin-top: 15px;
}

.fr-btn-danger {
	background: #dc3545;
	color: #fff;
	border: none;
	padding: 8px 16px;
	border-radius: 4px;
	cursor: pointer;
	font-size: 14px;
}

.fr-btn-danger:hover {
	background: #c82333;
}

.fr-upgrade-plans {
	display: grid;
	grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
	gap: 20px;
	margin-top: 20px;
}

.fr-upgrade-plan {
	background: #f8f9fa;
	border: 1px solid #e9ecef;
	border-radius: 6px;
	padding: 20px;
	text-align: center;
}

.fr-upgrade-plan h3 {
	margin: 0 0 10px 0;
	color: #212529;
}

.fr-plan-price {
	font-size: 20px;
	font-weight: bold;
	color: #007cba;
	margin-bottom: 15px;
}

.fr-purchases-list {
	margin-bottom: 15px;
}

.fr-purchase-item {
	display: flex;
	justify-content: space-between;
	align-items: center;
	padding: 15px;
	background: #f8f9fa;
	border-radius: 6px;
	margin-bottom: 10px;
}

.fr-purchase-content {
	flex: 1;
}

.fr-purchase-title {
	font-weight: 500;
	margin-bottom: 5px;
}

.fr-purchase-title a {
	color: #007cba;
	text-decoration: none;
}

.fr-purchase-title a:hover {
	text-decoration: underline;
}

.fr-purchase-meta {
	font-size: 12px;
	color: #6c757d;
}

.fr-purchase-amount {
	font-weight: 600;
	color: #007cba;
	margin: 0 15px;
}

.fr-download-invoice {
	font-size: 12px;
	color: #007cba;
	text-decoration: none;
}

.fr-actions-grid {
	display: grid;
	grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
	gap: 15px;
}

.fr-action-item {
	display: flex;
	flex-direction: column;
	align-items: center;
	padding: 20px;
	background: #f8f9fa;
	border-radius: 6px;
	text-decoration: none;
	color: #495057;
	transition: all 0.3s ease;
}

.fr-action-item:hover {
	background: #e9ecef;
	transform: translateY(-2px);
}

.fr-action-icon {
	font-size: 24px;
	margin-bottom: 10px;
}

.fr-action-label {
	font-size: 12px;
	text-align: center;
	font-weight: 500;
}

@media (max-width: 768px) {
	.fr-dashboard-grid {
		grid-template-columns: 1fr;
	}
	
	.fr-purchase-item {
		flex-direction: column;
		align-items: flex-start;
		gap: 10px;
	}
	
	.fr-subscription-info {
		flex-direction: column;
		align-items: flex-start;
		gap: 10px;
	}
}
</style>
