<?php
/**
 * Plugin Name: FreedomReader
 * Description: A comprehensive content monetization plugin with subscription and à la carte purchase options via PayPal. Requires PayPal Business Account.
 * Version: 1.0.2
 * Author: Kiran RS
 * Author URI: https://github.com/kiranrs
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: freedomreader
 * Requires at least: 5.0
 * Tested up to: 6.4
 * Requires PHP: 7.4
 *
 * @package FreedomReader
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'add_action' ) ) {
	exit;
}

define( 'FREEDOMREADER_VERSION', '1.0.2' );
define( 'FREEDOMREADER_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'FREEDOMREADER_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'FREEDOMREADER_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

require_once FREEDOMREADER_PLUGIN_PATH . 'includes/class-freedomreader.php';

FreedomReader::get_instance();

register_activation_hook( __FILE__, array( 'FreedomReader', 'activate' ) );
register_deactivation_hook( __FILE__, array( 'FreedomReader', 'deactivate' ) );
