/**
 * FreedomReader Reading Progress JavaScript
 */

jQuery(document).ready(function($) {
	// Reading progress bar
	if ($('#fr-reading-progress').length) {
		$(window).scroll(function() {
			var scrollTop = $(window).scrollTop();
			var docHeight = $(document).height();
			var winHeight = $(window).height();
			var scrollPercent = (scrollTop) / (docHeight - winHeight);
			var scrollPercentRounded = Math.round(scrollPercent * 100);
			$('#fr-reading-progress').css('width', scrollPercentRounded + '%');
		});
	}

	// Social sharing modal
	$('.fr-share-btn').click(function(e) {
		e.preventDefault();
		$('#fr-share-modal').show();
	});

	$('.fr-modal-close, .fr-modal-overlay').click(function() {
		$('#fr-share-modal').hide();
	});

	// Copy link functionality
	$('.fr-copy-link').click(function(e) {
		e.preventDefault();
		var url = window.location.href;
		
		if (navigator.clipboard) {
			navigator.clipboard.writeText(url).then(function() {
				alert(freedomreader_reading.link_copied);
			});
		} else {
			// Fallback for older browsers
			var textArea = document.createElement('textarea');
			textArea.value = url;
			document.body.appendChild(textArea);
			textArea.select();
			document.execCommand('copy');
			document.body.removeChild(textArea);
			alert(freedomreader_reading.link_copied);
		}
	});

	// Social sharing links
	$('.fr-share-facebook').click(function(e) {
		e.preventDefault();
		var url = encodeURIComponent(window.location.href);
		var title = encodeURIComponent(document.title);
		window.open('https://www.facebook.com/sharer/sharer.php?u=' + url, 'facebook-share', 'width=580,height=296');
	});

	$('.fr-share-twitter').click(function(e) {
		e.preventDefault();
		var url = encodeURIComponent(window.location.href);
		var title = encodeURIComponent(document.title);
		window.open('https://twitter.com/intent/tweet?url=' + url + '&text=' + title, 'twitter-share', 'width=550,height=235');
	});

	$('.fr-share-linkedin').click(function(e) {
		e.preventDefault();
		var url = encodeURIComponent(window.location.href);
		var title = encodeURIComponent(document.title);
		window.open('https://www.linkedin.com/sharing/share-offsite/?url=' + url, 'linkedin-share', 'width=550,height=235');
	});

	// Email unlock functionality
	$('.fr-email-unlock-form').submit(function(e) {
		e.preventDefault();
		var $form = $(this);
		var $button = $form.find('button[type="submit"]');
		var $email = $form.find('input[type="email"]');
		var originalText = $button.text();

		$button.prop('disabled', true).text(freedomreader_reading.sending_text);

		$.ajax({
			url: freedomreader_reading.ajax_url,
			type: 'POST',
			data: {
				action: 'freedomreader_request_email_unlock',
				email: $email.val(),
				post_id: freedomreader_reading.post_id,
				nonce: freedomreader_reading.nonce
			},
			success: function(response) {
				if (response.success) {
					$form.html('<div class="fr-success-message">' + response.data.message + '</div>');
				} else {
					alert(freedomreader_reading.error_text + ': ' + response.data.message);
				}
			},
			error: function() {
				alert(freedomreader_reading.error_occurred);
			},
			complete: function() {
				$button.prop('disabled', false).text(originalText);
			}
		});
	});

	// Expandable notes functionality
	$('.fr-note-toggle').click(function(e) {
		e.preventDefault();
		var $note = $(this).closest('.fr-note');
		var $content = $note.find('.fr-note-content');
		
		if ($content.is(':visible')) {
			$content.slideUp();
			$(this).text(freedomreader_reading.show_note);
		} else {
			$content.slideDown();
			$(this).text(freedomreader_reading.hide_note);
		}
	});

	// Reading time mode toggle (admin)
	$('#fr_reading_time_mode').change(function() {
		var mode = $(this).val();
		if (mode === 'manual' || mode === 'hybrid') {
			$('.fr-manual-time').show();
		} else {
			$('.fr-manual-time').hide();
		}
	});
});
