<?php
/**
 * Admin Subscriptions View
 *
 * @package FreedomReader
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="wrap">
	<h1><?php esc_html_e( 'Subscriptions', 'freedomreader' ); ?></h1>
	
	<div class="fr-subscriptions-stats">
		<div class="fr-stat-cards">
			<?php
			// Get subscription stats with caching.
			$cache_key = 'freedo_subscription_stats';
			$stats     = wp_cache_get( $cache_key );

			if ( false === $stats ) {
				global $wpdb;
				$subscriptions_table = $wpdb->prefix . 'freedo_subscriptions';

				// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Custom table queries for admin stats display
				$stats = array(
					// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Custom table query for admin stats display
					'active_count'    => $wpdb->get_var( $wpdb->prepare( "SELECT COUNT(*) FROM {$wpdb->prefix}freedo_subscriptions WHERE status = %s", 'active' ) ),
					// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Custom table query for admin stats display
					'trial_count'     => $wpdb->get_var( $wpdb->prepare( "SELECT COUNT(*) FROM {$wpdb->prefix}freedo_subscriptions WHERE status = %s", 'trial' ) ),
					// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Custom table query for admin stats display
					'cancelled_count' => $wpdb->get_var( $wpdb->prepare( "SELECT COUNT(*) FROM {$wpdb->prefix}freedo_subscriptions WHERE status = %s", 'cancelled' ) ),
					// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Custom table query for admin stats display
					'total_count'     => $wpdb->get_var( "SELECT COUNT(*) FROM {$wpdb->prefix}freedo_subscriptions" ),
				);

				wp_cache_set( $cache_key, $stats, '', 300 ); // Cache for 5 minutes.
			}

			$active_count    = $stats['active_count'];
			$trial_count     = $stats['trial_count'];
			$cancelled_count = $stats['cancelled_count'];
			$total_count     = $stats['total_count'];
			?>
			
			<div class="fr-stat-card">
				<h3><?php esc_html_e( 'Active Subscriptions', 'freedomreader' ); ?></h3>
				<div class="fr-stat-value"><?php echo number_format( $active_count ); ?></div>
			</div>
			
			<div class="fr-stat-card">
				<h3><?php esc_html_e( 'Trial Subscriptions', 'freedomreader' ); ?></h3>
				<div class="fr-stat-value"><?php echo number_format( $trial_count ); ?></div>
			</div>
			
			<div class="fr-stat-card">
				<h3><?php esc_html_e( 'Cancelled Subscriptions', 'freedomreader' ); ?></h3>
				<div class="fr-stat-value"><?php echo number_format( $cancelled_count ); ?></div>
			</div>
			
			<div class="fr-stat-card">
				<h3><?php esc_html_e( 'Total Subscriptions', 'freedomreader' ); ?></h3>
				<div class="fr-stat-value"><?php echo number_format( $total_count ); ?></div>
			</div>
		</div>
	</div>
	
	<div class="fr-subscriptions-table-container">
		<table class="fr-admin-table">
			<thead>
				<tr>
					<th><?php esc_html_e( 'ID', 'freedomreader' ); ?></th>
					<th><?php esc_html_e( 'Customer', 'freedomreader' ); ?></th>
					<th><?php esc_html_e( 'Plan', 'freedomreader' ); ?></th>
					<th><?php esc_html_e( 'Status', 'freedomreader' ); ?></th>
					<th><?php esc_html_e( 'Trial Ends', 'freedomreader' ); ?></th>
					<th><?php esc_html_e( 'Next Billing', 'freedomreader' ); ?></th>
					<th><?php esc_html_e( 'Created', 'freedomreader' ); ?></th>
					<th><?php esc_html_e( 'Actions', 'freedomreader' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php if ( ! empty( $subscriptions ) ) : ?>
					<?php
					$subscription_plans = get_option( 'freedomreader_subscription_plans', array() );
					foreach ( $subscriptions as $subscription ) :
						?>
						<tr>
							<td><?php echo esc_html( $subscription->id ); ?></td>
							<td>
								<strong><?php echo esc_html( $subscription->display_name ? $subscription->display_name : 'Unknown' ); ?></strong><br>
								<small><?php echo esc_html( $subscription->user_email ? $subscription->user_email : 'N/A' ); ?></small>
							</td>
							<td>
								<?php
								$plan_name = isset( $subscription_plans[ $subscription->plan_id ] )
									? $subscription_plans[ $subscription->plan_id ]['name']
									: $subscription->plan_id;
								echo esc_html( $plan_name );
								?>
							</td>
							<td>
								<span class="fr-status fr-status-<?php echo esc_attr( $subscription->status ); ?>">
									<?php echo esc_html( ucfirst( $subscription->status ) ); ?>
								</span>
							</td>
							<td>
								<?php
								if ( $subscription->trial_ends_at ) {
									echo esc_html( gmdate( 'M j, Y', strtotime( $subscription->trial_ends_at ) ) );
								} else {
									echo '—';
								}
								?>
							</td>
							<td>
								<?php
								if ( $subscription->next_billing_date ) {
									echo esc_html( gmdate( 'M j, Y', strtotime( $subscription->next_billing_date ) ) );
								} else {
									echo '—';
								}
								?>
							</td>
							<td>
								<?php echo esc_html( gmdate( 'M j, Y', strtotime( $subscription->created_at ) ) ); ?>
							</td>
							<td>
								<div class="fr-actions">
									<?php if ( $subscription->paypal_subscription_id ) : ?>
										<a href="#" class="fr-view-paypal-subscription" 
											data-subscription-id="<?php echo esc_attr( $subscription->paypal_subscription_id ); ?>"
											title="<?php esc_attr_e( 'View PayPal Subscription', 'freedomreader' ); ?>">
											<?php esc_html_e( 'View', 'freedomreader' ); ?>
										</a>
									<?php endif; ?>
									
									<?php if ( 'active' === $subscription->status ) : ?>
										<a href="#" class="fr-cancel-subscription" 
											data-subscription-id="<?php echo esc_attr( $subscription->id ); ?>"
											title="<?php esc_attr_e( 'Cancel Subscription', 'freedomreader' ); ?>">
											<?php esc_html_e( 'Cancel', 'freedomreader' ); ?>
										</a>
									<?php endif; ?>
								</div>
							</td>
						</tr>
					<?php endforeach; ?>
				<?php else : ?>
					<tr>
						<td colspan="8" style="text-align: center; padding: 40px;">
							<?php esc_html_e( 'No subscriptions found.', 'freedomreader' ); ?>
						</td>
					</tr>
				<?php endif; ?>
			</tbody>
		</table>
	</div>
	
	<?php if ( $total_pages > 1 ) : ?>
		<div class="fr-pagination">
			<?php
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Pagination parameter for admin page
			$current_page = isset( $_GET['paged'] ) ? max( 1, intval( $_GET['paged'] ) ) : 1;

			// Previous page.
			if ( $current_page > 1 ) {
				echo '<a href="' . esc_url( admin_url( 'admin.<?php?page=freedomreader-subscriptions&paged=' . ( $current_page - 1 ) ) ) . '">&laquo; ' . esc_html__( 'Previous', 'freedomreader' ) . '</a>';
			}

			// Page numbers.
			for ( $i = 1; $i <= $total_pages; $i++ ) {
				if ( $i === $current_page ) {
					echo '<span class="current">' . esc_html( $i ) . '</span>';
				} else {
					echo '<a href="' . esc_url( admin_url( 'admin.php?page=freedomreader-subscriptions&paged=' . $i ) ) . '">' . esc_html( $i ) . '</a>';
				}
			}

			// Next page.
			if ( $current_page < $total_pages ) {
				echo '<a href="' . esc_url( admin_url( 'admin.php?page=freedomreader-subscriptions&paged=' . ( $current_page + 1 ) ) ) . '">' . esc_html__( 'Next', 'freedomreader' ) . ' &raquo;</a>';
			}
			?>
		</div>
	<?php endif; ?>
</div>

<!-- Scripts are now properly enqueued via wp_enqueue_script -->
