<?php
/**
 * Admin Settings View
 *
 * @package FreedomReader
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get current settings.
$paypal_mode          = get_option( 'freedomreader_paypal_mode', 'sandbox' );
$paypal_client_id     = get_option( 'freedomreader_paypal_client_id', '' );
$paypal_client_secret = get_option( 'freedomreader_paypal_client_secret', '' );
$currency             = get_option( 'freedomreader_currency', 'USD' );
$trial_days           = get_option( 'freedomreader_trial_days', 7 );
$unlock_button_text   = get_option( 'freedomreader_unlock_button_text', esc_html__( 'Unlock Content', 'freedomreader' ) );
$teaser_message       = get_option( 'freedomreader_teaser_message', esc_html__( 'This content is locked. Purchase to unlock.', 'freedomreader' ) );
$subscription_plans   = get_option(
	'freedomreader_subscription_plans',
	array(
		'monthly' => array(
			'name'     => esc_html__( 'Monthly Plan', 'freedomreader' ),
			'price'    => 9.99,
			'interval' => 'month',
		),
		'yearly'  => array(
			'name'     => esc_html__( 'Yearly Plan', 'freedomreader' ),
			'price'    => 99.99,
			'interval' => 'year',
		),
	)
);
?>

<div class="wrap">
	<h1><?php esc_html_e( 'FreedomReader Settings', 'freedomreader' ); ?></h1>
	
	<?php settings_errors( 'freedomreader_settings' ); ?>
	
	<form method="post" action="">
		<?php wp_nonce_field( 'freedomreader_settings', 'freedomreader_settings_nonce' ); ?>
		
		<div class="fr-settings-tabs">
			<nav class="nav-tab-wrapper">
				<a href="#paypal" class="nav-tab nav-tab-active"><?php esc_html_e( 'PayPal Settings', 'freedomreader' ); ?></a>
				<a href="#general" class="nav-tab"><?php esc_html_e( 'General Settings', 'freedomreader' ); ?></a>
				<a href="#subscriptions" class="nav-tab"><?php esc_html_e( 'Subscription Plans', 'freedomreader' ); ?></a>
				<a href="#content" class="nav-tab"><?php esc_html_e( 'Content Settings', 'freedomreader' ); ?></a>
				<a href="#data-management" class="nav-tab"><?php esc_html_e( 'Data Management', 'freedomreader' ); ?></a>
			</nav>
			
			<!-- PayPal Settings Tab -->
			<div id="paypal" class="fr-tab-content active">
				<h2><?php esc_html_e( 'PayPal Configuration', 'freedomreader' ); ?></h2>
				<p><?php esc_html_e( 'Configure your PayPal integration settings. You can get your API credentials from the PayPal Developer Dashboard.', 'freedomreader' ); ?></p>
				
				<table class="form-table">
					<tr>
						<th scope="row">
							<label for="freedomreader_paypal_mode"><?php esc_html_e( 'PayPal Mode', 'freedomreader' ); ?></label>
						</th>
						<td>
							<select name="freedomreader_paypal_mode" id="freedomreader_paypal_mode">
								<option value="sandbox" <?php selected( $paypal_mode, 'sandbox' ); ?>><?php esc_html_e( 'Sandbox', 'freedomreader' ); ?></option>
								<option value="live" <?php selected( $paypal_mode, 'live' ); ?>><?php esc_html_e( 'Live (Production)', 'freedomreader' ); ?></option>
							</select>
							<p class="description"><?php esc_html_e( 'Use Sandbox mode for development, Live mode for production.', 'freedomreader' ); ?></p>
						</td>
					</tr>
					
					<tr>
						<th scope="row">
							<label for="freedomreader_paypal_client_id"><?php esc_html_e( 'PayPal Client ID', 'freedomreader' ); ?></label>
						</th>
						<td>
							<input type="text" name="freedomreader_paypal_client_id" id="freedomreader_paypal_client_id" 
									value="<?php echo esc_attr( $paypal_client_id ); ?>" class="regular-text" />
							<p class="description"><?php esc_html_e( 'Your PayPal application Client ID.', 'freedomreader' ); ?></p>
						</td>
					</tr>
					
					<tr>
						<th scope="row">
							<label for="freedomreader_paypal_client_secret"><?php esc_html_e( 'PayPal Client Secret', 'freedomreader' ); ?></label>
						</th>
						<td>
							<input type="password" name="freedomreader_paypal_client_secret" id="freedomreader_paypal_client_secret" 
									value="<?php echo esc_attr( $paypal_client_secret ); ?>" class="regular-text" />
							<p class="description"><?php esc_html_e( 'Your PayPal application Client Secret.', 'freedomreader' ); ?></p>
						</td>
					</tr>
				</table>
				
				<div class="fr-paypal-help">
					<h3><?php esc_html_e( 'How to get PayPal API Credentials', 'freedomreader' ); ?></h3>
					<ol>
						<li><?php esc_html_e( 'Go to the PayPal Developer Dashboard', 'freedomreader' ); ?></li>
						<li><?php esc_html_e( 'Create a new application or select an existing one', 'freedomreader' ); ?></li>
						<li><?php esc_html_e( 'Copy the Client ID and Client Secret', 'freedomreader' ); ?></li>
						<li><?php esc_html_e( 'Paste them in the fields above', 'freedomreader' ); ?></li>
					</ol>
					<p><a href="https://developer.paypal.com/dashboard/applications" target="_blank" class="button"><?php esc_html_e( 'PayPal Developer Dashboard', 'freedomreader' ); ?></a></p>
				</div>
			</div>
			
			<!-- General Settings Tab -->
			<div id="general" class="fr-tab-content" style="display: none;">
				<h2><?php esc_html_e( 'General Settings', 'freedomreader' ); ?></h2>
				
				<table class="form-table">
					<tr>
						<th scope="row">
							<label for="freedomreader_currency"><?php esc_html_e( 'Currency', 'freedomreader' ); ?></label>
						</th>
						<td>
							<select name="freedomreader_currency" id="freedomreader_currency">
								<option value="USD" <?php selected( $currency, 'USD' ); ?>>USD - US Dollar</option>
								<option value="EUR" <?php selected( $currency, 'EUR' ); ?>>EUR - Euro</option>
								<option value="INR" <?php selected( $currency, 'INR' ); ?>>INR - Indian Rupees</option>
								<option value="CAD" <?php selected( $currency, 'CAD' ); ?>>CAD - Canadian Dollar</option>
							</select>
							<p class="description"><?php esc_html_e( 'The currency for all transactions.', 'freedomreader' ); ?></p>
						</td>
					</tr>
					
					<tr>
						<th scope="row">
							<label for="freedomreader_trial_days"><?php esc_html_e( 'Free Trial Days', 'freedomreader' ); ?></label>
						</th>
						<td>
							<input type="number" name="freedomreader_trial_days" id="freedomreader_trial_days" 
									value="<?php echo esc_attr( $trial_days ); ?>" min="0" max="30" />
							<p class="description"><?php esc_html_e( 'Number of days for free trial (0 to disable).', 'freedomreader' ); ?></p>
						</td>
					</tr>
				</table>
			</div>
			
			<!-- Subscription Plans Tab -->
			<div id="subscriptions" class="fr-tab-content" style="display: none;">
				<h2><?php esc_html_e( 'Subscription Plans', 'freedomreader' ); ?></h2>
				<p><?php esc_html_e( 'Configure your subscription plans. Users can subscribe to these plans for unlimited access to premium content.', 'freedomreader' ); ?></p>
				
				<div id="fr-subscription-plans">
					<?php foreach ( $subscription_plans as $plan_id => $plan ) : ?>
						<div class="fr-plan-row" data-plan-id="<?php echo esc_attr( $plan_id ); ?>">
							<table class="form-table">
								<tr>
									<th scope="row">
										<label><?php esc_html_e( 'Plan Name', 'freedomreader' ); ?></label>
									</th>
									<td>
										<input type="text" name="subscription_plans[<?php echo esc_attr( $plan_id ); ?>][name]" 
												value="<?php echo esc_attr( $plan['name'] ); ?>" class="regular-text" />
									</td>
								</tr>
								
								<tr>
									<th scope="row">
										<label><?php esc_html_e( 'Price', 'freedomreader' ); ?></label>
									</th>
									<td>
										<input type="number" name="subscription_plans[<?php echo esc_attr( $plan_id ); ?>][price]" 
												value="<?php echo esc_attr( $plan['price'] ); ?>" step="0.01" min="0" />
									</td>
								</tr>
								
								<tr>
									<th scope="row">
										<label><?php esc_html_e( 'Billing Interval', 'freedomreader' ); ?></label>
									</th>
									<td>
										<select name="subscription_plans[<?php echo esc_attr( $plan_id ); ?>][interval]">
											<option value="month" <?php selected( $plan['interval'], 'month' ); ?>><?php esc_html_e( 'Monthly', 'freedomreader' ); ?></option>
											<option value="year" <?php selected( $plan['interval'], 'year' ); ?>><?php esc_html_e( 'Yearly', 'freedomreader' ); ?></option>
										</select>
									</td>
								</tr>
							</table>
							
							<button type="button" class="button fr-remove-plan"><?php esc_html_e( 'Remove Plan', 'freedomreader' ); ?></button>
							<hr>
						</div>
					<?php endforeach; ?>
				</div>
				
				<button type="button" id="fr-add-plan" class="button"><?php esc_html_e( 'Add New Plan', 'freedomreader' ); ?></button>
			</div>
			
			<!-- Content Settings Tab -->
			<div id="content" class="fr-tab-content" style="display: none;">
				<h2><?php esc_html_e( 'Content Settings', 'freedomreader' ); ?></h2>
				<p><?php esc_html_e( 'Customize the appearance and messages for locked content.', 'freedomreader' ); ?></p>
				
				<table class="form-table">
					<tr>
						<th scope="row">
							<label for="freedomreader_unlock_button_text"><?php esc_html_e( 'Unlock Button Text', 'freedomreader' ); ?></label>
						</th>
						<td>
							<input type="text" name="freedomreader_unlock_button_text" id="freedomreader_unlock_button_text" 
									value="<?php echo esc_attr( $unlock_button_text ); ?>" class="regular-text" />
							<p class="description"><?php esc_html_e( 'Default text for the unlock button.', 'freedomreader' ); ?></p>
						</td>
					</tr>
					
					<tr>
						<th scope="row">
							<label for="freedomreader_teaser_message"><?php esc_html_e( 'Teaser Message', 'freedomreader' ); ?></label>
						</th>
						<td>
							<textarea name="freedomreader_teaser_message" id="freedomreader_teaser_message"
										rows="3" class="large-text"><?php echo esc_textarea( $teaser_message ); ?></textarea>
							<p class="description"><?php esc_html_e( 'Message shown to users when content is locked.', 'freedomreader' ); ?></p>
						</td>
					</tr>
				</table>

				<h3><?php esc_html_e( 'Content Enhancement Features', 'freedomreader' ); ?></h3>
				<table class="form-table">
					<tr>
						<th scope="row"><?php esc_html_e( 'Show Reading Progress Bar', 'freedomreader' ); ?></th>
						<td>
							<label>
								<input type="checkbox" name="freedomreader_show_progress_bar" value="1"
										<?php checked( get_option( 'freedomreader_show_progress_bar', true ) ); ?> />
								<?php esc_html_e( 'Display reading progress bar at top of posts', 'freedomreader' ); ?>
							</label>
						</td>
					</tr>

					<tr>
						<th scope="row"><?php esc_html_e( 'Show Reading Time', 'freedomreader' ); ?></th>
						<td>
							<label>
								<input type="checkbox" name="freedomreader_show_reading_time" value="1"
										<?php checked( get_option( 'freedomreader_show_reading_time', true ) ); ?> />
								<?php esc_html_e( 'Display estimated reading time on posts', 'freedomreader' ); ?>
							</label>
						</td>
					</tr>

					<tr>
						<th scope="row">
							<label for="freedomreader_reading_time_mode"><?php esc_html_e( 'Reading Time Mode', 'freedomreader' ); ?></label>
						</th>
						<td>
							<select name="freedomreader_reading_time_mode" id="freedomreader_reading_time_mode">
								<option value="auto" <?php selected( get_option( 'freedomreader_reading_time_mode', 'auto' ), 'auto' ); ?>><?php esc_html_e( 'Auto Calculate', 'freedomreader' ); ?></option>
								<option value="manual" <?php selected( get_option( 'freedomreader_reading_time_mode', 'auto' ), 'manual' ); ?>><?php esc_html_e( 'Manual Only', 'freedomreader' ); ?></option>
								<option value="hybrid" <?php selected( get_option( 'freedomreader_reading_time_mode', 'auto' ), 'hybrid' ); ?>><?php esc_html_e( 'Hybrid (Auto + Manual Override)', 'freedomreader' ); ?></option>
							</select>
							<p class="description"><?php esc_html_e( 'How reading time should be calculated.', 'freedomreader' ); ?></p>
						</td>
					</tr>

					<tr>
						<th scope="row">
							<label for="freedomreader_reading_speed"><?php esc_html_e( 'Reading Speed (WPM)', 'freedomreader' ); ?></label>
						</th>
						<td>
							<input type="number" name="freedomreader_reading_speed" id="freedomreader_reading_speed"
									value="<?php echo esc_attr( get_option( 'freedomreader_reading_speed', 200 ) ); ?>"
									min="100" max="500" />
							<p class="description"><?php esc_html_e( 'Average reading speed in words per minute for auto-calculation.', 'freedomreader' ); ?></p>
						</td>
					</tr>

					<tr>
						<th scope="row"><?php esc_html_e( 'Show Ask Author Button', 'freedomreader' ); ?></th>
						<td>
							<label>
								<input type="checkbox" name="freedomreader_show_ask_author" value="1"
										<?php checked( get_option( 'freedomreader_show_ask_author', true ) ); ?> />
								<?php esc_html_e( 'Display "Ask the Author" button on posts (only visible to users with access to premium content)', 'freedomreader' ); ?>
							</label>
						</td>
					</tr>

					<tr>
						<th scope="row"><?php esc_html_e( 'Auto Internal Linking', 'freedomreader' ); ?></th>
						<td>
							<label>
								<input type="checkbox" name="freedomreader_auto_internal_links" value="1"
										<?php checked( get_option( 'freedomreader_auto_internal_links', false ) ); ?> />
								<?php esc_html_e( 'Automatically link keywords to internal posts', 'freedomreader' ); ?>
							</label>
							<p class="description"><?php esc_html_e( 'Configure keywords in the Auto Linking section below.', 'freedomreader' ); ?></p>
						</td>
					</tr>
				</table>

				<h3><?php esc_html_e( 'Auto Internal Linking Keywords', 'freedomreader' ); ?></h3>
				<div id="fr-auto-link-keywords">
					<?php
					$keywords = get_option( 'freedomreader_auto_link_keywords', array() );
					if ( empty( $keywords ) ) {
						$keywords = array( '' => '' );
					}

					foreach ( $keywords as $keyword => $linked_post_id ) :
						?>
						<div class="fr-keyword-row">
							<input type="text" name="auto_link_keywords[]" value="<?php echo esc_attr( $keyword ); ?>"
									placeholder="<?php esc_html_e( 'Keyword', 'freedomreader' ); ?>" class="regular-text" />
							<input type="number" name="auto_link_post_ids[]" value="<?php echo esc_attr( $linked_post_id ); ?>"
									placeholder="<?php esc_html_e( 'Post ID', 'freedomreader' ); ?>" min="1" />
							<button type="button" class="button fr-remove-keyword"><?php esc_html_e( 'Remove', 'freedomreader' ); ?></button>
						</div>
					<?php endforeach; ?>
				</div>
				<button type="button" id="fr-add-keyword" class="button"><?php esc_html_e( 'Add Keyword', 'freedomreader' ); ?></button>
				<p class="description"><?php esc_html_e( 'Map keywords to specific post IDs for automatic internal linking.', 'freedomreader' ); ?></p>
			</div>
		</div>
		
		<!-- Data Management Tab -->
		<div id="data-management" class="fr-tab-content" style="display: none;">
			<h2><?php esc_html_e( 'Data Management', 'freedomreader' ); ?></h2>
			<p><?php esc_html_e( 'Configure how your plugin data is handled during uninstallation and other data management options.', 'freedomreader' ); ?></p>

			<table class="form-table">
				<tr>
					<th scope="row">
						<label for="freedomreader_keep_data_on_uninstall"><?php esc_html_e( 'Data Preservation', 'freedomreader' ); ?></label>
					</th>
					<td>
						<fieldset>
							<legend class="screen-reader-text"><span><?php esc_html_e( 'Data Preservation Options', 'freedomreader' ); ?></span></legend>
							<label>
								<input type="radio" name="freedomreader_keep_data_on_uninstall" value="1"
									<?php checked( get_option( 'freedomreader_keep_data_on_uninstall', 0 ), 1 ); ?> />
								<?php esc_html_e( 'Keep all data when uninstalling (Recommended)', 'freedomreader' ); ?>
							</label>
							<br>
							<label>
								<input type="radio" name="freedomreader_keep_data_on_uninstall" value="0"
									<?php checked( get_option( 'freedomreader_keep_data_on_uninstall', 0 ), 0 ); ?> />
								<?php esc_html_e( 'Delete all data when uninstalling', 'freedomreader' ); ?>
							</label>
						</fieldset>
						<p class="description">
							<?php esc_html_e( 'Choose whether to preserve your purchases, subscriptions, and settings when uninstalling the plugin. Keeping data allows for easy reinstallation without losing transaction history.', 'freedomreader' ); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="freedomreader_auto_cleanup"><?php esc_html_e( 'Automatic Cleanup', 'freedomreader' ); ?></label>
					</th>
					<td>
						<label>
							<input type="checkbox" name="freedomreader_auto_cleanup" id="freedomreader_auto_cleanup" value="1"
								<?php checked( get_option( 'freedomreader_auto_cleanup', 0 ), 1 ); ?> />
							<?php esc_html_e( 'Automatically clean up expired transactions older than 2 years', 'freedomreader' ); ?>
						</label>
						<p class="description">
							<?php esc_html_e( 'This helps keep your database clean by removing very old transaction records. Active subscriptions and recent purchases are never deleted.', 'freedomreader' ); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="freedomreader_export_format"><?php esc_html_e( 'Export Format', 'freedomreader' ); ?></label>
					</th>
					<td>
						<select name="freedomreader_export_format" id="freedomreader_export_format">
							<option value="csv" <?php selected( get_option( 'freedomreader_export_format', 'csv' ), 'csv' ); ?>>
								<?php esc_html_e( 'CSV (Comma Separated Values)', 'freedomreader' ); ?>
							</option>
							<option value="xlsx" <?php selected( get_option( 'freedomreader_export_format', 'csv' ), 'xlsx' ); ?>>
								<?php esc_html_e( 'Excel (XLSX)', 'freedomreader' ); ?>
							</option>
							<option value="json" <?php selected( get_option( 'freedomreader_export_format', 'csv' ), 'json' ); ?>>
								<?php esc_html_e( 'JSON', 'freedomreader' ); ?>
							</option>
						</select>
						<p class="description">
							<?php esc_html_e( 'Choose the default format for data exports from the Reports page.', 'freedomreader' ); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="freedomreader_auto_backup"><?php esc_html_e( 'Automatic Backups', 'freedomreader' ); ?></label>
					</th>
					<td>
						<label>
							<input type="checkbox" name="freedomreader_auto_backup" id="freedomreader_auto_backup" value="1"
								<?php checked( get_option( 'freedomreader_auto_backup', 0 ), 1 ); ?> />
							<?php esc_html_e( 'Enable automatic data backups', 'freedomreader' ); ?>
						</label>
						<p class="description">
							<?php esc_html_e( 'Automatically create backup files of your FreedomReader data based on the schedule below.', 'freedomreader' ); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="freedomreader_backup_frequency"><?php esc_html_e( 'Backup Schedule', 'freedomreader' ); ?></label>
					</th>
					<td>
						<select name="freedomreader_backup_frequency" id="freedomreader_backup_frequency">
							<option value="daily" <?php selected( get_option( 'freedomreader_backup_frequency', 'weekly' ), 'daily' ); ?>>
								<?php esc_html_e( 'Daily', 'freedomreader' ); ?>
							</option>
							<option value="weekly" <?php selected( get_option( 'freedomreader_backup_frequency', 'weekly' ), 'weekly' ); ?>>
								<?php esc_html_e( 'Weekly (Recommended)', 'freedomreader' ); ?>
							</option>
							<option value="monthly" <?php selected( get_option( 'freedomreader_backup_frequency', 'weekly' ), 'monthly' ); ?>>
								<?php esc_html_e( 'Monthly', 'freedomreader' ); ?>
							</option>
						</select>
						<p class="description">
							<?php esc_html_e( 'How often to create automatic backups. Backups are stored in /wp-content/uploads/freedomreader-backups/', 'freedomreader' ); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="freedomreader_backup_retention"><?php esc_html_e( 'Backup Retention', 'freedomreader' ); ?></label>
					</th>
					<td>
						<select name="freedomreader_backup_retention" id="freedomreader_backup_retention">
							<option value="7" <?php selected( get_option( 'freedomreader_backup_retention', '30' ), '7' ); ?>>
								<?php esc_html_e( '7 days', 'freedomreader' ); ?>
							</option>
							<option value="30" <?php selected( get_option( 'freedomreader_backup_retention', '30' ), '30' ); ?>>
								<?php esc_html_e( '30 days (Recommended)', 'freedomreader' ); ?>
							</option>
							<option value="90" <?php selected( get_option( 'freedomreader_backup_retention', '30' ), '90' ); ?>>
								<?php esc_html_e( '90 days', 'freedomreader' ); ?>
							</option>
							<option value="365" <?php selected( get_option( 'freedomreader_backup_retention', '30' ), '365' ); ?>>
								<?php esc_html_e( '1 year', 'freedomreader' ); ?>
							</option>
						</select>
						<p class="description">
							<?php esc_html_e( 'How long to keep backup files before automatically deleting them.', 'freedomreader' ); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="freedomreader_performance_monitoring"><?php esc_html_e( 'Performance Monitoring', 'freedomreader' ); ?></label>
					</th>
					<td>
						<label>
							<input type="checkbox" name="freedomreader_performance_monitoring" id="freedomreader_performance_monitoring" value="1"
								<?php checked( get_option( 'freedomreader_performance_monitoring', 1 ), 1 ); ?> />
							<?php esc_html_e( 'Enable performance monitoring and metrics collection', 'freedomreader' ); ?>
						</label>
						<p class="description">
							<?php esc_html_e( 'Track plugin performance, database query times, and user interaction metrics to optimize performance.', 'freedomreader' ); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="freedomreader_user_activity_logs"><?php esc_html_e( 'User Activity Logs', 'freedomreader' ); ?></label>
					</th>
					<td>
						<label>
							<input type="checkbox" name="freedomreader_user_activity_logs" id="freedomreader_user_activity_logs" value="1"
								<?php checked( get_option( 'freedomreader_user_activity_logs', 1 ), 1 ); ?> />
							<?php esc_html_e( 'Log detailed user activities and admin actions', 'freedomreader' ); ?>
						</label>
						<p class="description">
							<?php esc_html_e( 'Maintain detailed audit trail of user purchases, content unlocks, and admin configuration changes.', 'freedomreader' ); ?>
						</p>
					</td>
				</tr>

				<tr>
					<th scope="row">
						<label for="freedomreader_email_notifications"><?php esc_html_e( 'Email Notifications', 'freedomreader' ); ?></label>
					</th>
					<td>
						<fieldset>
							<legend class="screen-reader-text"><span><?php esc_html_e( 'Email Notification Options', 'freedomreader' ); ?></span></legend>
							<label>
								<input type="checkbox" name="freedomreader_email_new_purchases" value="1"
									<?php checked( get_option( 'freedomreader_email_new_purchases', 1 ), 1 ); ?> />
								<?php esc_html_e( 'New purchases', 'freedomreader' ); ?>
							</label>
							<br>
							<label>
								<input type="checkbox" name="freedomreader_email_new_subscriptions" value="1"
									<?php checked( get_option( 'freedomreader_email_new_subscriptions', 1 ), 1 ); ?> />
								<?php esc_html_e( 'New subscriptions', 'freedomreader' ); ?>
							</label>
							<br>
							<label>
								<input type="checkbox" name="freedomreader_email_failed_payments" value="1"
									<?php checked( get_option( 'freedomreader_email_failed_payments', 1 ), 1 ); ?> />
								<?php esc_html_e( 'Failed payments', 'freedomreader' ); ?>
							</label>
							<br>
							<label>
								<input type="checkbox" name="freedomreader_email_performance_alerts" value="1"
									<?php checked( get_option( 'freedomreader_email_performance_alerts', 0 ), 1 ); ?> />
								<?php esc_html_e( 'Performance alerts', 'freedomreader' ); ?>
							</label>
						</fieldset>
						<p class="description">
							<?php esc_html_e( 'Choose which events should trigger email notifications to the admin email address.', 'freedomreader' ); ?>
						</p>
					</td>
				</tr>
			</table>

			<div class="fr-data-actions" style="margin-top: 30px; padding: 20px; background: #f9f9f9; border-radius: 5px;">
				<h3><?php esc_html_e( 'Data Actions', 'freedomreader' ); ?></h3>
				<p><?php esc_html_e( 'Use these tools to manage your FreedomReader data:', 'freedomreader' ); ?></p>

				<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-top: 15px;">
					<button type="button" class="button button-secondary" id="fr-export-all-data">
						<span class="dashicons dashicons-download" style="margin-right: 5px;"></span>
						<?php esc_html_e( 'Export All Data', 'freedomreader' ); ?>
					</button>

					<button type="button" class="button button-secondary" id="fr-import-data">
						<span class="dashicons dashicons-upload" style="margin-right: 5px;"></span>
						<?php esc_html_e( 'Import Data', 'freedomreader' ); ?>
					</button>

					<button type="button" class="button button-secondary" id="fr-create-backup">
						<span class="dashicons dashicons-backup" style="margin-right: 5px;"></span>
						<?php esc_html_e( 'Create Backup', 'freedomreader' ); ?>
					</button>

					<button type="button" class="button button-secondary" id="fr-cleanup-logs">
						<span class="dashicons dashicons-admin-tools" style="margin-right: 5px;"></span>
						<?php esc_html_e( 'Clean Old Logs', 'freedomreader' ); ?>
					</button>

					<button type="button" class="button button-secondary" id="fr-verify-data">
						<span class="dashicons dashicons-yes-alt" style="margin-right: 5px;"></span>
						<?php esc_html_e( 'Verify Data Integrity', 'freedomreader' ); ?>
					</button>

					<button type="button" class="button button-secondary" id="fr-performance-check">
						<span class="dashicons dashicons-performance" style="margin-right: 5px;"></span>
						<?php esc_html_e( 'Performance Check', 'freedomreader' ); ?>
					</button>
				</div>

				<!-- Import Data Modal -->
				<div id="fr-import-modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7); z-index: 9999;">
					<div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 30px; border-radius: 8px; max-width: 500px; width: 90%;">
						<h3 style="margin-top: 0;"><?php esc_html_e( 'Import FreedomReader Data', 'freedomreader' ); ?></h3>
						<p><?php esc_html_e( 'Select a FreedomReader backup file to import:', 'freedomreader' ); ?></p>

						<input type="file" id="fr-import-file" accept=".json" style="margin-bottom: 20px; width: 100%;" />

						<div style="margin-bottom: 20px;">
							<label>
								<input type="checkbox" id="fr-import-overwrite" />
								<?php esc_html_e( 'Overwrite existing data (use with caution)', 'freedomreader' ); ?>
							</label>
						</div>

						<div style="text-align: right;">
							<button type="button" class="button" id="fr-import-cancel"><?php esc_html_e( 'Cancel', 'freedomreader' ); ?></button>
							<button type="button" class="button button-primary" id="fr-import-confirm" disabled><?php esc_html_e( 'Import Data', 'freedomreader' ); ?></button>
						</div>
					</div>
				</div>

				<div id="fr-data-action-result" style="margin-top: 15px;"></div>
			</div>
		</div>

		<?php submit_button( esc_html__( 'Save Settings', 'freedomreader' ) ); ?>
	</form>




</div>




