<?php
/**
 * Admin Purchases View
 *
 * @package FreedomReader
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="wrap">
	<h1><?php esc_html_e( 'Purchases', 'freedomreader' ); ?></h1>
	
	<div class="fr-purchases-header">
		<div class="fr-export-controls">
			<h3><?php esc_html_e( 'Export Purchases', 'freedomreader' ); ?></h3>
			<div class="fr-form-row">
				<div class="fr-form-group">
					<label for="export-date-from"><?php esc_html_e( 'From Date', 'freedomreader' ); ?></label>
					<input type="date" id="export-date-from" />
				</div>
				<div class="fr-form-group">
					<label for="export-date-to"><?php esc_html_e( 'To Date', 'freedomreader' ); ?></label>
					<input type="date" id="export-date-to" />
				</div>
				<div class="fr-form-group">
					<button class="button fr-export-data" data-export-type="purchases">
						<?php esc_html_e( 'Export CSV', 'freedomreader' ); ?>
					</button>
				</div>
			</div>
		</div>
	</div>
	
	<div class="fr-purchases-table-container">
		<table class="fr-admin-table">
			<thead>
				<tr>
					<th><?php esc_html_e( 'ID', 'freedomreader' ); ?></th>
					<th><?php esc_html_e( 'Customer', 'freedomreader' ); ?></th>
					<th><?php esc_html_e( 'Content', 'freedomreader' ); ?></th>
					<th><?php esc_html_e( 'Type', 'freedomreader' ); ?></th>
					<th><?php esc_html_e( 'Amount', 'freedomreader' ); ?></th>
					<th><?php esc_html_e( 'Status', 'freedomreader' ); ?></th>
					<th><?php esc_html_e( 'Date', 'freedomreader' ); ?></th>
					<th><?php esc_html_e( 'Actions', 'freedomreader' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php if ( ! empty( $purchases ) ) : ?>
					<?php foreach ( $purchases as $purchase ) : ?>
						<tr>
							<td><?php echo esc_html( $purchase->id ); ?></td>
							<td>
								<strong><?php echo esc_html( $purchase->display_name ? $purchase->display_name : 'Unknown' ); ?></strong><br>
								<small><?php echo esc_html( $purchase->user_email ? $purchase->user_email : 'N/A' ); ?></small>
							</td>
							<td>
								<?php if ( $purchase->post_id && $purchase->post_title ) : ?>
									<a href="<?php echo esc_url( get_edit_post_link( $purchase->post_id ) ); ?>" target="_blank">
										<?php echo esc_html( $purchase->post_title ); ?>
									</a>
								<?php else : ?>
									<em><?php echo esc_html( ucfirst( $purchase->purchase_type ) ); ?></em>
								<?php endif; ?>
							</td>
							<td>
								<span class="fr-purchase-type">
									<?php echo esc_html( ucfirst( $purchase->purchase_type ) ); ?>
								</span>
							</td>
							<td>
								<strong>$<?php echo esc_html( number_format( $purchase->amount, 2 ) ); ?></strong>
								<small><?php echo esc_html( $purchase->currency ); ?></small>
							</td>
							<td>
								<span class="fr-status fr-status-<?php echo esc_attr( $purchase->status ); ?>">
									<?php echo esc_html( ucfirst( $purchase->status ) ); ?>
								</span>
							</td>
							<td>
								<?php echo esc_html( gmdate( 'M j, Y g:i A', strtotime( $purchase->created_at ) ) ); ?>
							</td>
							<td>
								<div class="fr-actions">
									<?php if ( $purchase->paypal_transaction_id ) : ?>
										<a href="#" class="fr-view-transaction" 
											data-transaction-id="<?php echo esc_attr( $purchase->paypal_transaction_id ); ?>"
											title="<?php esc_html_e( 'View PayPal Transaction', 'freedomreader' ); ?>">
											<?php esc_html_e( 'View', 'freedomreader' ); ?>
										</a>
									<?php endif; ?>
									
									<?php if ( 'completed' === $purchase->status ) : ?>
										<a href="#" class="fr-refund-purchase" 
											data-purchase-id="<?php echo esc_attr( $purchase->id ); ?>"
											title="<?php esc_html_e( 'Refund Purchase', 'freedomreader' ); ?>">
											<?php esc_html_e( 'Refund', 'freedomreader' ); ?>
										</a>
									<?php endif; ?>
								</div>
							</td>
						</tr>
					<?php endforeach; ?>
				<?php else : ?>
					<tr>
						<td colspan="8" style="text-align: center; padding: 40px;">
							<?php esc_html_e( 'No purchases found.', 'freedomreader' ); ?>
						</td>
					</tr>
				<?php endif; ?>
			</tbody>
		</table>
	</div>
	
	<?php if ( $total_pages > 1 ) : ?>
		<div class="fr-pagination">
			<?php
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Pagination parameter for admin page
			$current_page = isset( $_GET['paged'] ) ? max( 1, intval( $_GET['paged'] ) ) : 1;

			// Previous page.
			if ( $current_page > 1 ) {
				echo '<a href="' . esc_url( admin_url( 'admin.<?php?page=freedomreader-purchases&paged=' . ( $current_page - 1 ) ) ) . '">&laquo; ' . esc_html__( 'Previous', 'freedomreader' ) . '</a>';
			}

			// Page numbers.
			for ( $i = 1; $i <= $total_pages; $i++ ) {
				if ( $i === $current_page ) {
					echo '<span class="current">' . esc_html( $i ) . '</span>';
				} else {
					echo '<a href="' . esc_url( admin_url( 'admin.php?page=freedomreader-purchases&paged=' . $i ) ) . '">' . esc_html( $i ) . '</a>';
				}
			}

			// Next page.
			if ( $current_page < $total_pages ) {
				echo '<a href="' . esc_url( admin_url( 'admin.php?page=freedomreader-purchases&paged=' . ( $current_page + 1 ) ) ) . '">' . esc_html__( 'Next', 'freedomreader' ) . ' &raquo;</a>';
			}
			?>
		</div>
	<?php endif; ?>
</div>

<!-- Scripts and styles are now properly enqueued via wp_enqueue_script and wp_enqueue_style -->
