<?php
/**
 * Help & Support page view
 *
 * @package FreedomReader
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="wrap">
	<h1><?php esc_html_e( 'Help & Support', 'freedomreader' ); ?></h1>
	
	<div class="fr-help-support-grid" style="display: grid; grid-template-columns: 1fr 1fr; gap: 30px; margin-top: 20px;">
		
		<!-- Documentation Section -->
		<div class="fr-help-card" style="background: #fff; padding: 25px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
			<div style="display: flex; align-items: center; margin-bottom: 20px;">
				<span class="dashicons dashicons-book-alt" style="font-size: 24px; color: #0073aa; margin-right: 10px;"></span>
				<h2 style="margin: 0; color: #23282d;"><?php esc_html_e( 'Documentation', 'freedomreader' ); ?></h2>
			</div>
			
			<p style="color: #666; line-height: 1.6; margin-bottom: 20px;">
				<?php esc_html_e( 'Access comprehensive guides, tutorials, and documentation to get the most out of FreedomReader.', 'freedomreader' ); ?>
			</p>
			
			<div style="margin-bottom: 20px;">
				<h4 style="margin-bottom: 10px; color: #23282d;"><?php esc_html_e( 'Quick Links:', 'freedomreader' ); ?></h4>
				<ul style="margin: 0; padding-left: 20px; color: #666;">
					<li style="margin-bottom: 8px;"><?php esc_html_e( 'Getting Started Guide', 'freedomreader' ); ?></li>
					<li style="margin-bottom: 8px;"><?php esc_html_e( 'PayPal Setup Instructions', 'freedomreader' ); ?></li>
					<li style="margin-bottom: 8px;"><?php esc_html_e( 'Content Locking Tutorial', 'freedomreader' ); ?></li>
					<li style="margin-bottom: 8px;"><?php esc_html_e( 'Subscription Management', 'freedomreader' ); ?></li>
					<li style="margin-bottom: 8px;"><?php esc_html_e( 'Troubleshooting Guide', 'freedomreader' ); ?></li>
				</ul>
			</div>
			
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=freedomreader-documentation' ) ); ?>" 
				class="button button-primary" style="text-decoration: none;">
				<span class="dashicons dashicons-external" style="margin-right: 5px;"></span>
				<?php esc_html_e( 'View Documentation', 'freedomreader' ); ?>
			</a>
		</div>
		
		<!-- Support Section -->
		<div class="fr-help-card" style="background: #fff; padding: 25px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
			<div style="display: flex; align-items: center; margin-bottom: 20px;">
				<span class="dashicons dashicons-heart" style="font-size: 24px; color: #d63638; margin-right: 10px;"></span>
				<h2 style="margin: 0; color: #23282d;"><?php esc_html_e( 'Support Development', 'freedomreader' ); ?></h2>
			</div>
			
			<p style="color: #666; line-height: 1.6; margin-bottom: 20px;">
				<?php esc_html_e( 'FreedomReader is developed with passion and dedication. Your support helps keep the plugin free and continuously improved.', 'freedomreader' ); ?>
			</p>
			
			<div style="margin-bottom: 25px;">
				<h4 style="margin-bottom: 10px; color: #23282d;"><?php esc_html_e( 'Ways to Support:', 'freedomreader' ); ?></h4>
				<ul style="margin: 0; padding-left: 20px; color: #666;">
					<li style="margin-bottom: 8px;"><?php esc_html_e( '⭐ Rate the plugin on WordPress.org', 'freedomreader' ); ?></li>
					<li style="margin-bottom: 8px;"><?php esc_html_e( '☕ Buy me a coffee to fuel development', 'freedomreader' ); ?></li>
					<li style="margin-bottom: 8px;"><?php esc_html_e( '🐛 Report bugs and suggest features', 'freedomreader' ); ?></li>
					<li style="margin-bottom: 8px;"><?php esc_html_e( '📢 Share with other WordPress users', 'freedomreader' ); ?></li>
				</ul>
			</div>
			
			<!-- Buy Me a Coffee Button -->
			<div style="text-align: center; margin-bottom: 20px;">
				<a href="https://www.buymeacoffee.com/kiranrs1432" target="_blank" style="text-decoration: none; display: inline-block; background: #28a745; color: white; padding: 12px 24px; border-radius: 8px; font-weight: bold; box-shadow: 0 2px 8px rgba(0,0,0,0.15); transition: background 0.3s ease;">
					☕ <?php esc_html_e( 'Buy Me A Coffee', 'freedomreader' ); ?>
				</a>
			</div>
			
			<p style="text-align: center; color: #666; font-size: 14px; margin: 0;">
				<?php esc_html_e( 'Every contribution, no matter how small, makes a difference!', 'freedomreader' ); ?>
			</p>
		</div>
	</div>
	
	<!-- Additional Resources -->
	<div class="fr-resources-section" style="margin-top: 40px; background: #fff; padding: 25px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
		<h2 style="margin-top: 0; color: #23282d; border-bottom: 2px solid #0073aa; padding-bottom: 10px;">
			<span class="dashicons dashicons-admin-links" style="margin-right: 10px;"></span>
			<?php esc_html_e( 'Additional Resources', 'freedomreader' ); ?>
		</h2>
		
		<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-top: 20px;">
			
			<div class="fr-resource-item">
				<h4 style="color: #0073aa; margin-bottom: 10px;">
					<span class="dashicons dashicons-wordpress" style="margin-right: 5px;"></span>
					<?php esc_html_e( 'WordPress.org', 'freedomreader' ); ?>
				</h4>
				<p style="color: #666; margin-bottom: 10px; font-size: 14px;">
					<?php esc_html_e( 'Plugin page, reviews, and support forum', 'freedomreader' ); ?>
				</p>
				<a href="https://wordpress.org/plugins/freedomreader/" target="_blank" class="button button-secondary">
					<?php esc_html_e( 'Visit Plugin Page', 'freedomreader' ); ?>
				</a>
			</div>
			
			<div class="fr-resource-item">
				<h4 style="color: #0073aa; margin-bottom: 10px;">
					<span class="dashicons dashicons-admin-users" style="margin-right: 5px;"></span>
					<?php esc_html_e( 'Support Forum', 'freedomreader' ); ?>
				</h4>
				<p style="color: #666; margin-bottom: 10px; font-size: 14px;">
					<?php esc_html_e( 'Community support and discussions', 'freedomreader' ); ?>
				</p>
				<a href="https://wordpress.org/support/plugin/freedomreader/" target="_blank" class="button button-secondary">
					<?php esc_html_e( 'Visit Forum', 'freedomreader' ); ?>
				</a>
			</div>
			
			<div class="fr-resource-item">
				<h4 style="color: #0073aa; margin-bottom: 10px;">
					<span class="dashicons dashicons-star-filled" style="margin-right: 5px;"></span>
					<?php esc_html_e( 'Rate & Review', 'freedomreader' ); ?>
				</h4>
				<p style="color: #666; margin-bottom: 10px; font-size: 14px;">
					<?php esc_html_e( 'Help others discover FreedomReader', 'freedomreader' ); ?>
				</p>
				<a href="https://wordpress.org/support/plugin/freedomreader/reviews/#new-post" target="_blank" class="button button-secondary">
					<?php esc_html_e( 'Leave Review', 'freedomreader' ); ?>
				</a>
			</div>
			
		</div>
	</div>
	
	<!-- Plugin Information -->
	<div class="fr-plugin-info" style="margin-top: 30px; padding: 20px; background: #f8f9fa; border-radius: 8px; border-left: 4px solid #0073aa;">
		<div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 20px;">
			<div>
				<h3 style="margin: 0 0 5px 0; color: #23282d;"><?php esc_html_e( 'FreedomReader', 'freedomreader' ); ?></h3>
				<p style="margin: 0; color: #666;">
					<?php
					printf(
						/* translators: %s: Plugin version */
						esc_html__( 'Version %s - Content Monetization Plugin', 'freedomreader' ),
						esc_html( FREEDOMREADER_VERSION )
					);
					?>
				</p>
			</div>
			<div style="text-align: right;">
				<p style="margin: 0; color: #666; font-size: 14px;">
					<?php esc_html_e( 'Developed with ❤️ by', 'freedomreader' ); ?>
					<a href="https://github.com/kiranrs" target="_blank" style="color: #0073aa; text-decoration: none;">
						<?php esc_html_e( 'Kiran RS', 'freedomreader' ); ?>
					</a>
				</p>
			</div>
		</div>
	</div>
</div>

<?php
// Enqueue help support styles.
$help_support_css = '
@media (max-width: 768px) {
	.fr-help-support-grid {
		grid-template-columns: 1fr !important;
	}

	.fr-resources-section div[style*="grid-template-columns"] {
		grid-template-columns: 1fr !important;
	}
}

.fr-help-card:hover {
	transform: translateY(-2px);
	transition: transform 0.2s ease;
}

.fr-resource-item {
	padding: 15px;
	border: 1px solid #e1e1e1;
	border-radius: 6px;
	background: #fafafa;
}

.fr-resource-item:hover {
	background: #f0f0f0;
	transition: background 0.2s ease;
}';
wp_add_inline_style( 'freedomreader-admin', $help_support_css );
?>
