<?php
/**
 * Admin Documentation View
 *
 * @package FreedomReader
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="wrap">
	<div class="fr-header-section">
		<h1><?php esc_html_e( 'FreedomReader Documentation', 'freedomreader' ); ?></h1>
		<div class="fr-support-section">
			<p><?php esc_html_e( 'Enjoying FreedomReader? Support the development!', 'freedomreader' ); ?></p>
			<div id="fr-coffee-button"></div>
		</div>
	</div>

	<div class="fr-documentation-container">
		<!-- Table of Contents -->
		<div class="fr-toc">
			<h3><?php esc_html_e( 'Table of Contents', 'freedomreader' ); ?></h3>
			<ul>
				<li><a href="#overview"><?php esc_html_e( 'Plugin Overview', 'freedomreader' ); ?></a></li>
				<li><a href="#getting-started"><?php esc_html_e( 'Getting Started', 'freedomreader' ); ?></a></li>
				<li><a href="#paypal-setup"><?php esc_html_e( 'PayPal Setup', 'freedomreader' ); ?></a></li>
				<li><a href="#content-locking"><?php esc_html_e( 'Content Locking', 'freedomreader' ); ?></a></li>
				<li><a href="#subscription-plans"><?php esc_html_e( 'Subscription Plans', 'freedomreader' ); ?></a></li>
				<li><a href="#lock-rules"><?php esc_html_e( 'Lock Rules', 'freedomreader' ); ?></a></li>
				<li><a href="#content-enhancements"><?php esc_html_e( 'Content Enhancements', 'freedomreader' ); ?></a></li>
				<li><a href="#analytics-reports"><?php esc_html_e( 'Analytics & Reports', 'freedomreader' ); ?></a></li>
				<li><a href="#shortcodes"><?php esc_html_e( 'Shortcodes', 'freedomreader' ); ?></a></li>
				<li><a href="#troubleshooting"><?php esc_html_e( 'Troubleshooting', 'freedomreader' ); ?></a></li>
			</ul>
		</div>

		<!-- Documentation Content -->
		<div class="fr-doc-content">
			
			<!-- Plugin Overview -->
			<section id="overview" class="fr-doc-section">
				<h2><?php esc_html_e( 'Plugin Overview', 'freedomreader' ); ?></h2>
				<p><?php esc_html_e( 'FreedomReader is a comprehensive content monetization plugin that allows you to create premium content experiences on your WordPress website. With both subscription-based and à la carte purchase options, you can monetize your content effectively while providing value to your readers.', 'freedomreader' ); ?></p>
				
				<h3><?php esc_html_e( 'Key Features', 'freedomreader' ); ?></h3>
				<ul class="fr-feature-list">
					<li><strong><?php esc_html_e( 'Content Locking', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Lock specific posts, pages, or content sections behind paywalls', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Subscription Plans', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Create monthly/yearly subscription plans for unlimited access', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Single Purchases', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Allow users to purchase individual pieces of content', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'PayPal Integration', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Secure payment processing through PayPal', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Advanced Lock Rules', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Create complex locking rules based on categories, tags, and custom criteria', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Content Enhancements', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Reading progress bars, estimated reading time, and interactive features', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Analytics & Reports', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Comprehensive sales and subscription analytics', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'User Management', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Track user purchases and subscription status', 'freedomreader' ); ?></li>
				</ul>
			</section>

			<!-- Getting Started -->
			<section id="getting-started" class="fr-doc-section">
				<h2><?php esc_html_e( 'Getting Started', 'freedomreader' ); ?></h2>
				<p><?php esc_html_e( 'Follow these steps to set up FreedomReader on your website:', 'freedomreader' ); ?></p>
				
				<ol class="fr-setup-steps">
					<li>
						<strong><?php esc_html_e( 'Install and Activate', 'freedomreader' ); ?></strong>
						<p><?php esc_html_e( 'Install the FreedomReader plugin and activate it from your WordPress admin dashboard.', 'freedomreader' ); ?></p>
					</li>
					<li>
						<strong><?php esc_html_e( 'Configure PayPal', 'freedomreader' ); ?></strong>
						<p><?php esc_html_e( 'Set up your PayPal API credentials in Settings → PayPal Settings. You\'ll need a PayPal Business account.', 'freedomreader' ); ?></p>
					</li>
					<li>
						<strong><?php esc_html_e( 'Create Subscription Plans', 'freedomreader' ); ?></strong>
						<p><?php esc_html_e( 'Define your subscription plans with pricing and billing intervals in Settings → Subscription Plans.', 'freedomreader' ); ?></p>
					</li>
					<li>
						<strong><?php esc_html_e( 'Lock Your Content', 'freedomreader' ); ?></strong>
						<p><?php esc_html_e( 'Start locking posts and pages using the content lock metabox or create advanced lock rules.', 'freedomreader' ); ?></p>
					</li>
					<li>
						<strong><?php esc_html_e( 'Test Your Setup', 'freedomreader' ); ?></strong>
						<p><?php esc_html_e( 'Use PayPal\'s sandbox mode to test purchases before going live.', 'freedomreader' ); ?></p>
					</li>
				</ol>
			</section>

			<!-- PayPal Setup -->
			<section id="paypal-setup" class="fr-doc-section">
				<h2><?php esc_html_e( 'PayPal Setup', 'freedomreader' ); ?></h2>
				<p><?php esc_html_e( 'FreedomReader requires PayPal API credentials to process payments. Here\'s how to set them up:', 'freedomreader' ); ?></p>
				
				<h3><?php esc_html_e( 'Requirements', 'freedomreader' ); ?></h3>
				<ul>
					<li><?php esc_html_e( 'PayPal Business Account (required for API access)', 'freedomreader' ); ?></li>
					<li><?php esc_html_e( 'PayPal Developer Account (free)', 'freedomreader' ); ?></li>
				</ul>
				
				<h3><?php esc_html_e( 'Step-by-Step Setup', 'freedomreader' ); ?></h3>
				<ol>
					<li>
						<strong><?php esc_html_e( 'Create PayPal App', 'freedomreader' ); ?></strong>
						<p><?php esc_html_e( 'Go to', 'freedomreader' ); ?> <a href="https://developer.paypal.com/dashboard/applications" target="_blank">PayPal Developer Dashboard</a></p>
						<p><?php esc_html_e( 'Click "Create App" and fill in your application details', 'freedomreader' ); ?></p>
						<div class="fr-screenshot">
							<img src="<?php echo esc_url( FREEDOMREADER_PLUGIN_URL . 'assets/images/paypal-developer-dashboard.png' ); ?>" alt="PayPal Developer Dashboard" style="max-width: 100%; height: auto; border: 1px solid #ddd; border-radius: 4px;" />
							<p class="fr-screenshot-caption"><?php esc_html_e( 'PayPal Developer Dashboard - Create App', 'freedomreader' ); ?></p>
						</div>
					</li>
					<li>
						<strong><?php esc_html_e( 'Get API Credentials', 'freedomreader' ); ?></strong>
						<p><?php esc_html_e( 'Copy the Client ID and Client Secret from your app dashboard', 'freedomreader' ); ?></p>
						<div class="fr-screenshot">
							<img src="<?php echo esc_url( FREEDOMREADER_PLUGIN_URL . 'assets/images/paypal-app-credentials.png' ); ?>" alt="PayPal App Credentials" style="max-width: 100%; height: auto; border: 1px solid #ddd; border-radius: 4px;" />
							<p class="fr-screenshot-caption"><?php esc_html_e( 'PayPal App Credentials Page', 'freedomreader' ); ?></p>
						</div>
					</li>
					<li>
						<strong><?php esc_html_e( 'Configure Plugin', 'freedomreader' ); ?></strong>
						<p><?php esc_html_e( 'Paste the credentials in FreedomReader → Settings → PayPal Settings', 'freedomreader' ); ?></p>
						<p><?php esc_html_e( 'Start with Sandbox mode for testing, then switch to Live mode when ready', 'freedomreader' ); ?></p>
						<div class="fr-screenshot">
							<img src="<?php echo esc_url( FREEDOMREADER_PLUGIN_URL . 'assets/images/plugin-settings-paypal.png' ); ?>" alt="Plugin PayPal Settings" style="max-width: 100%; height: auto; border: 1px solid #ddd; border-radius: 4px;" />
							<p class="fr-screenshot-caption"><?php esc_html_e( 'FreedomReader PayPal Settings', 'freedomreader' ); ?></p>
						</div>
					</li>
				</ol>
				
				<div class="fr-notice fr-notice-warning">
					<p><strong><?php esc_html_e( 'Important:', 'freedomreader' ); ?></strong> <?php esc_html_e( 'Always test your payment setup in Sandbox mode before going live. This ensures everything works correctly without processing real payments.', 'freedomreader' ); ?></p>
				</div>
			</section>

			<!-- Content Locking -->
			<section id="content-locking" class="fr-doc-section">
				<h2><?php esc_html_e( 'Content Locking', 'freedomreader' ); ?></h2>
				<p><?php esc_html_e( 'FreedomReader offers multiple ways to lock your content behind paywalls:', 'freedomreader' ); ?></p>
				
				<h3><?php esc_html_e( 'Individual Post/Page Locking', 'freedomreader' ); ?></h3>
				<p><?php esc_html_e( 'When editing any post or page, you\'ll find the "Content Lock Settings" metabox:', 'freedomreader' ); ?></p>
				<div class="fr-screenshot">
					<img src="<?php echo esc_url( FREEDOMREADER_PLUGIN_URL . 'assets/images/content-lock-metabox.png' ); ?>" alt="Content Lock Metabox" style="max-width: 100%; height: auto; border: 1px solid #ddd; border-radius: 4px;" />
					<p class="fr-screenshot-caption"><?php esc_html_e( 'Content Lock Settings Metabox', 'freedomreader' ); ?></p>
				</div>
				<ul>
					<li><strong><?php esc_html_e( 'Enable Content Lock', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Toggle to lock this content', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Lock Type', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Choose between subscription-only, single purchase, or both', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Single Purchase Price', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Set the price for one-time access', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Preview Length', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Number of words to show before the paywall', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Custom Message', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Personalized message for locked content', 'freedomreader' ); ?></li>
				</ul>
				
				<h3><?php esc_html_e( 'Shortcode Locking', 'freedomreader' ); ?></h3>
				<p><?php esc_html_e( 'Use shortcodes to lock specific sections within your content:', 'freedomreader' ); ?></p>
				<code>[freedomreader_lock type="subscription"]Premium content here[/freedomreader_lock]</code>

				<h3><?php esc_html_e( 'Frontend Experience', 'freedomreader' ); ?></h3>
				<p><?php esc_html_e( 'Here\'s how locked content appears to your visitors:', 'freedomreader' ); ?></p>
				<div class="fr-screenshot">
					<img src="<?php echo esc_url( FREEDOMREADER_PLUGIN_URL . 'assets/images/locked-content-frontend.png' ); ?>" alt="Locked Content Frontend" style="max-width: 100%; height: auto; border: 1px solid #ddd; border-radius: 4px;" />
					<p class="fr-screenshot-caption"><?php esc_html_e( 'How locked content appears to visitors', 'freedomreader' ); ?></p>
				</div>
				<div class="fr-screenshot">
					<img src="<?php echo esc_url( FREEDOMREADER_PLUGIN_URL . 'assets/images/purchase-button-frontend.png' ); ?>" alt="Purchase Buttons Frontend" style="max-width: 100%; height: auto; border: 1px solid #ddd; border-radius: 4px;" />
					<p class="fr-screenshot-caption"><?php esc_html_e( 'Purchase and subscription buttons on frontend', 'freedomreader' ); ?></p>
				</div>
			</section>

			<!-- Subscription Plans -->
			<section id="subscription-plans" class="fr-doc-section">
				<h2><?php esc_html_e( 'Subscription Plans', 'freedomreader' ); ?></h2>
				<p><?php esc_html_e( 'Create flexible subscription plans to provide unlimited access to your premium content:', 'freedomreader' ); ?></p>

				<h3><?php esc_html_e( 'Creating Plans', 'freedomreader' ); ?></h3>
				<p><?php esc_html_e( 'Go to Settings → Subscription Plans to manage your plans:', 'freedomreader' ); ?></p>
				<div class="fr-screenshot">
					<img src="<?php echo esc_url( FREEDOMREADER_PLUGIN_URL . 'assets/images/subscription-plans-settings.png' ); ?>" alt="Subscription Plans Settings" style="max-width: 100%; height: auto; border: 1px solid #ddd; border-radius: 4px;" />
					<p class="fr-screenshot-caption"><?php esc_html_e( 'Subscription Plans Configuration Page', 'freedomreader' ); ?></p>
				</div>
				<ul>
					<li><strong><?php esc_html_e( 'Plan Name', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Display name for the subscription (e.g., "Premium Monthly")', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Price', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Monthly or yearly price in your chosen currency', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Billing Interval', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Choose between monthly or yearly billing', 'freedomreader' ); ?></li>
				</ul>

				<h3><?php esc_html_e( 'Best Practices', 'freedomreader' ); ?></h3>
				<ul>
					<li><?php esc_html_e( 'Offer both monthly and yearly options with yearly discounts', 'freedomreader' ); ?></li>
					<li><?php esc_html_e( 'Keep plan names simple and descriptive', 'freedomreader' ); ?></li>
					<li><?php esc_html_e( 'Consider offering a free trial period to attract subscribers', 'freedomreader' ); ?></li>
				</ul>
			</section>

			<!-- Lock Rules -->
			<section id="lock-rules" class="fr-doc-section">
				<h2><?php esc_html_e( 'Advanced Lock Rules', 'freedomreader' ); ?></h2>
				<p><?php esc_html_e( 'Create sophisticated locking rules to automatically protect content based on various criteria:', 'freedomreader' ); ?></p>

				<h3><?php esc_html_e( 'Rule Types', 'freedomreader' ); ?></h3>
				<ul>
					<li><strong><?php esc_html_e( 'Category Rules', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Lock all posts in specific categories', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Tag Rules', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Lock posts with certain tags', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Post Type Rules', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Lock specific post types', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Date-based Rules', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Lock content published after a certain date', 'freedomreader' ); ?></li>
				</ul>

				<h3><?php esc_html_e( 'Creating Rules', 'freedomreader' ); ?></h3>
				<div class="fr-screenshot">
					<img src="<?php echo esc_url( FREEDOMREADER_PLUGIN_URL . 'assets/images/lock-rules-page.png' ); ?>" alt="Lock Rules Management" style="max-width: 100%; height: auto; border: 1px solid #ddd; border-radius: 4px;" />
					<p class="fr-screenshot-caption"><?php esc_html_e( 'Lock Rules Management Interface', 'freedomreader' ); ?></p>
				</div>
				<ol>
					<li><?php esc_html_e( 'Go to Lock Rules in the admin menu', 'freedomreader' ); ?></li>
					<li><?php esc_html_e( 'Click "Add New Rule"', 'freedomreader' ); ?></li>
					<li><?php esc_html_e( 'Define your rule criteria and lock settings', 'freedomreader' ); ?></li>
					<li><?php esc_html_e( 'Save and activate the rule', 'freedomreader' ); ?></li>
				</ol>
			</section>

			<!-- Content Enhancements -->
			<section id="content-enhancements" class="fr-doc-section">
				<h2><?php esc_html_e( 'Content Enhancements', 'freedomreader' ); ?></h2>
				<p><?php esc_html_e( 'Enhance your content with interactive features that improve user engagement:', 'freedomreader' ); ?></p>

				<h3><?php esc_html_e( 'Available Features', 'freedomreader' ); ?></h3>
				<ul>
					<li><strong><?php esc_html_e( 'Reading Progress Bar', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Shows reading progress at the top of posts', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Estimated Reading Time', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Displays how long it takes to read the content', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Ask the Author Button', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Allows readers to contact the author directly', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Auto Internal Linking', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Automatically links keywords to related posts', 'freedomreader' ); ?></li>
				</ul>

				<h3><?php esc_html_e( 'Configuration', 'freedomreader' ); ?></h3>
				<p><?php esc_html_e( 'Enable and configure these features in Settings → Content Settings:', 'freedomreader' ); ?></p>
				<ul>
					<li><?php esc_html_e( 'Toggle individual features on/off', 'freedomreader' ); ?></li>
					<li><?php esc_html_e( 'Customize reading speed for time calculations', 'freedomreader' ); ?></li>
					<li><?php esc_html_e( 'Set up keyword mappings for auto-linking', 'freedomreader' ); ?></li>
				</ul>
			</section>

			<!-- Analytics & Reports -->
			<section id="analytics-reports" class="fr-doc-section">
				<h2><?php esc_html_e( 'Analytics & Reports', 'freedomreader' ); ?></h2>
				<p><?php esc_html_e( 'Track your revenue and understand your audience with comprehensive analytics:', 'freedomreader' ); ?></p>

				<h3><?php esc_html_e( 'Dashboard Overview', 'freedomreader' ); ?></h3>
				<p><?php esc_html_e( 'The main dashboard provides a quick overview of:', 'freedomreader' ); ?></p>
				<div class="fr-screenshot">
					<img src="<?php echo esc_url( FREEDOMREADER_PLUGIN_URL . 'assets/images/dashboard-overview.png' ); ?>" alt="Dashboard Overview" style="max-width: 100%; height: auto; border: 1px solid #ddd; border-radius: 4px;" />
					<p class="fr-screenshot-caption"><?php esc_html_e( 'FreedomReader Main Dashboard', 'freedomreader' ); ?></p>
				</div>
				<ul>
					<li><?php esc_html_e( 'Total revenue and recent sales', 'freedomreader' ); ?></li>
					<li><?php esc_html_e( 'Active subscriptions count', 'freedomreader' ); ?></li>
					<li><?php esc_html_e( 'Top-performing content', 'freedomreader' ); ?></li>
					<li><?php esc_html_e( 'Recent transactions', 'freedomreader' ); ?></li>
				</ul>

				<h3><?php esc_html_e( 'Detailed Reports', 'freedomreader' ); ?></h3>
				<p><?php esc_html_e( 'Access detailed reports for deeper insights:', 'freedomreader' ); ?></p>
				<div class="fr-screenshot">
					<img src="<?php echo esc_url( FREEDOMREADER_PLUGIN_URL . 'assets/images/reports-page.png' ); ?>" alt="Reports Page" style="max-width: 100%; height: auto; border: 1px solid #ddd; border-radius: 4px;" />
					<p class="fr-screenshot-caption"><?php esc_html_e( 'Detailed Analytics and Reports Page', 'freedomreader' ); ?></p>
				</div>
				<ul>
					<li><strong><?php esc_html_e( 'Sales Reports', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Revenue trends, top products, customer analysis', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Subscription Reports', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Subscriber growth, churn rates, plan performance', 'freedomreader' ); ?></li>
					<li><strong><?php esc_html_e( 'Content Performance', 'freedomreader' ); ?>:</strong> <?php esc_html_e( 'Which content generates the most revenue', 'freedomreader' ); ?></li>
				</ul>

				<h3><?php esc_html_e( 'Data Export', 'freedomreader' ); ?></h3>
				<p><?php esc_html_e( 'Export your data for external analysis:', 'freedomreader' ); ?></p>
				<ul>
					<li><?php esc_html_e( 'CSV exports of purchases and subscriptions', 'freedomreader' ); ?></li>
					<li><?php esc_html_e( 'Date range filtering', 'freedomreader' ); ?></li>
					<li><?php esc_html_e( 'Custom report generation', 'freedomreader' ); ?></li>
				</ul>
			</section>

			<!-- Shortcodes -->
			<section id="shortcodes" class="fr-doc-section">
				<h2><?php esc_html_e( 'Shortcodes Reference', 'freedomreader' ); ?></h2>
				<p><?php esc_html_e( 'FreedomReader provides several shortcodes for flexible content management:', 'freedomreader' ); ?></p>

				<h3><?php esc_html_e( 'Content Locking Shortcode', 'freedomreader' ); ?></h3>
				<p><code>[freedomreader_lock type="subscription" price="9.99"]Premium content[/freedomreader_lock]</code></p>
				<p><?php esc_html_e( 'Parameters:', 'freedomreader' ); ?></p>
				<ul>
					<li><strong>type</strong>: subscription, purchase, or both</li>
					<li><strong>price</strong>: Price for single purchase (if applicable)</li>
					<li><strong>message</strong>: Custom unlock message</li>
				</ul>

				<h3><?php esc_html_e( 'Subscription Button Shortcode', 'freedomreader' ); ?></h3>
				<p><code>[freedomreader_subscribe plan="monthly" text="Subscribe Now"]</code></p>
				<p><?php esc_html_e( 'Parameters:', 'freedomreader' ); ?></p>
				<ul>
					<li><strong>plan</strong>: Plan ID (monthly, yearly, etc.)</li>
					<li><strong>text</strong>: Button text</li>
					<li><strong>class</strong>: Additional CSS classes</li>
				</ul>

				<h3><?php esc_html_e( 'User Status Shortcode', 'freedomreader' ); ?></h3>
				<p><code>[freedomreader_user_status]</code></p>
				<p><?php esc_html_e( 'Displays current user\'s subscription status and purchase history.', 'freedomreader' ); ?></p>
			</section>

			<!-- Troubleshooting -->
			<section id="troubleshooting" class="fr-doc-section">
				<h2><?php esc_html_e( 'Troubleshooting', 'freedomreader' ); ?></h2>
				<p><?php esc_html_e( 'Common issues and their solutions:', 'freedomreader' ); ?></p>

				<h3><?php esc_html_e( 'PayPal Issues', 'freedomreader' ); ?></h3>
				<div class="fr-troubleshoot-item">
					<h4><?php esc_html_e( 'Payments not processing', 'freedomreader' ); ?></h4>
					<ul>
						<li><?php esc_html_e( 'Verify PayPal API credentials are correct', 'freedomreader' ); ?></li>
						<li><?php esc_html_e( 'Check if you\'re using the right mode (Sandbox vs Live)', 'freedomreader' ); ?></li>
						<li><?php esc_html_e( 'Ensure your PayPal account is verified and in good standing', 'freedomreader' ); ?></li>
					</ul>
				</div>

				<h3><?php esc_html_e( 'Content Lock Issues', 'freedomreader' ); ?></h3>
				<div class="fr-troubleshoot-item">
					<h4><?php esc_html_e( 'Content not locking properly', 'freedomreader' ); ?></h4>
					<ul>
						<li><?php esc_html_e( 'Check if content lock is enabled in post settings', 'freedomreader' ); ?></li>
						<li><?php esc_html_e( 'Verify lock rules are active and properly configured', 'freedomreader' ); ?></li>
						<li><?php esc_html_e( 'Clear any caching plugins that might interfere', 'freedomreader' ); ?></li>
					</ul>
				</div>

				<h3><?php esc_html_e( 'Performance Issues', 'freedomreader' ); ?></h3>
				<div class="fr-troubleshoot-item">
					<h4><?php esc_html_e( 'Slow page loading', 'freedomreader' ); ?></h4>
					<ul>
						<li><?php esc_html_e( 'Enable caching in your hosting environment', 'freedomreader' ); ?></li>
						<li><?php esc_html_e( 'Optimize database queries by limiting lock rules', 'freedomreader' ); ?></li>
						<li><?php esc_html_e( 'Consider using a CDN for better performance', 'freedomreader' ); ?></li>
					</ul>
				</div>

				<div class="fr-notice fr-notice-info">
					<p><strong><?php esc_html_e( 'Need More Help?', 'freedomreader' ); ?></strong></p>
					<p><?php esc_html_e( 'If you\'re still experiencing issues, please contact me with:', 'freedomreader' ); ?></p>
					<ul>
						<li><?php esc_html_e( 'Detailed description of the problem', 'freedomreader' ); ?></li>
						<li><?php esc_html_e( 'Steps to reproduce the issue', 'freedomreader' ); ?></li>
						<li><?php esc_html_e( 'Your WordPress and plugin version numbers', 'freedomreader' ); ?></li>
						<li><?php esc_html_e( 'Any error messages you\'re seeing', 'freedomreader' ); ?></li>
						
					</ul>
				</div>
			</section>

		</div>
	</div>
</div>

<?php
// Enqueue documentation styles.
$documentation_css = '
.fr-header-section {
	display: flex;
	justify-content: space-between;
	align-items: center;
	margin-bottom: 20px;
	padding-bottom: 15px;
	border-bottom: 1px solid #e0e0e0;
}

.fr-header-section h1 {
	margin: 0;
}

.fr-support-section {
	text-align: right;
}

.fr-support-section p {
	margin: 0 0 10px 0;
	font-size: 14px;
	color: #666;
}

#fr-coffee-button {
	display: inline-block;
}

.fr-documentation-container {
	display: flex;
	gap: 30px;
	margin-top: 20px;
}

.fr-toc {
	flex: 0 0 250px;
	background: #f8f9fa;
	padding: 20px;
	border-radius: 8px;
	height: fit-content;
	position: sticky;
	top: 32px;
}

.fr-toc h3 {
	margin-top: 0;
	color: #1d2327;
	font-size: 16px;
}

.fr-toc ul {
	list-style: none;
	padding: 0;
	margin: 0;
}

.fr-toc li {
	margin-bottom: 8px;
}

.fr-toc a {
	color: #2271b1;
	text-decoration: none;
	font-size: 14px;
	display: block;
	padding: 5px 0;
}

.fr-toc a:hover {
	color: #135e96;
}

.fr-doc-content {
	flex: 1;
	max-width: calc(100% - 280px);
}

.fr-doc-section {
	margin-bottom: 40px;
	padding-bottom: 30px;
	border-bottom: 1px solid #e0e0e0;
}

.fr-doc-section:last-child {
	border-bottom: none;
}

.fr-doc-section h2 {
	color: #1d2327;
	font-size: 24px;
	margin-bottom: 15px;
	padding-bottom: 10px;
	border-bottom: 2px solid #2271b1;
}

.fr-doc-section h3 {
	color: #1d2327;
	font-size: 18px;
	margin-top: 25px;
	margin-bottom: 10px;
}

.fr-feature-list,
.fr-setup-steps {
	margin: 15px 0;
}

.fr-feature-list li,
.fr-setup-steps li {
	margin-bottom: 10px;
	line-height: 1.6;
}

.fr-notice {
	padding: 15px;
	border-radius: 5px;
	margin: 20px 0;
}

.fr-notice-warning {
	background: #fff3cd;
	border-left: 4px solid #ffc107;
	color: #856404;
}

.fr-notice-info {
	background: #d1ecf1;
	border-left: 4px solid #17a2b8;
	color: #0c5460;
}

code {
	background: #f1f1f1;
	padding: 2px 6px;
	border-radius: 3px;
	font-family: "Courier New", monospace;
	font-size: 13px;
}

.fr-screenshot {
	margin: 15px 0;
	text-align: center;
}

.fr-screenshot img {
	box-shadow: 0 2px 8px rgba(0,0,0,0.1);
	transition: transform 0.3s ease;
}

.fr-screenshot img:hover {
	transform: scale(1.02);
}

.fr-screenshot-caption {
	font-size: 12px;
	color: #666;
	margin-top: 8px;
	font-style: italic;
}

@media (max-width: 1200px) {
	.fr-documentation-container {
		flex-direction: column;
	}

	.fr-toc {
		flex: none;
		position: static;
	}

	.fr-doc-content {
		max-width: 100%;
	}
}';
wp_add_inline_style( 'freedomreader-admin', $documentation_css );
?>

<?php
// Enqueue coffee button script.
$coffee_button_js = '
document.addEventListener("DOMContentLoaded", function() {
	// Load Buy Me a Coffee button
	var script = document.createElement("script");
	script.type = "text/javascript";
	script.src = "https://cdnjs.buymeacoffee.com/1.0.0/button.prod.min.js";
	script.setAttribute("data-name", "bmc-button");
	script.setAttribute("data-slug", "kiranrs1432");
	script.setAttribute("data-color", "#40DCA5");
	script.setAttribute("data-emoji", "");
	script.setAttribute("data-font", "Cookie");
	script.setAttribute("data-text", "Buy me a coffee");
	script.setAttribute("data-outline-color", "#000000");
	script.setAttribute("data-font-color", "#ffffff");
	script.setAttribute("data-coffee-color", "#FFDD00");

	document.getElementById("fr-coffee-button").appendChild(script);
});';
wp_add_inline_script( 'freedomreader-admin', $coffee_button_js );
?>
