<?php
/**
 * Admin Dashboard View
 *
 * @package FreedomReader
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="wrap">
	<div class="fr-dashboard-header">
		<h1><?php esc_html_e( 'FreedomReader Dashboard', 'freedomreader' ); ?></h1>
		<div class="fr-support-widget">
			<div id="fr-coffee-button-dashboard"></div>
		</div>
	</div>

	<div class="fr-dashboard-stats">
		<div class="fr-stat-cards">
			<div class="fr-stat-card">
				<h3><?php esc_html_e( 'Total Revenue', 'freedomreader' ); ?></h3>
				<div class="fr-stat-value">$<?php echo number_format( $stats['total_revenue'], 2 ); ?></div>
				<div class="fr-stat-change">
					<?php
					/* translators: %s: formatted revenue amount */
					printf( esc_html__( '$%s this month', 'freedomreader' ), esc_html( number_format( $stats['monthly_revenue'], 2 ) ) );
					?>
				</div>
			</div>
			
			<div class="fr-stat-card">
				<h3><?php esc_html_e( 'Active Subscriptions', 'freedomreader' ); ?></h3>
				<div class="fr-stat-value"><?php echo esc_html( number_format( $stats['active_subscriptions'] ) ); ?></div>
				<div class="fr-stat-change">
					<?php
					/* translators: %d: number of trial subscriptions */
					printf( esc_html__( '%d trial subscriptions', 'freedomreader' ), esc_html( $stats['trial_subscriptions'] ) );
					?>
				</div>
			</div>
			
			<div class="fr-stat-card">
				<h3><?php esc_html_e( 'Total Purchases', 'freedomreader' ); ?></h3>
				<div class="fr-stat-value"><?php echo esc_html( number_format( $stats['total_purchases'] ) ); ?></div>
				<div class="fr-stat-change">
					<?php
					/* translators: %d: number of purchases this month */
					printf( esc_html__( '%d this month', 'freedomreader' ), esc_html( $stats['monthly_purchases'] ) );
					?>
				</div>
			</div>
			
			<div class="fr-stat-card">
				<h3><?php esc_html_e( 'Conversion Rate', 'freedomreader' ); ?></h3>
				<div class="fr-stat-value">
					<?php
					$conversion_rate = $stats['total_purchases'] > 0 ? ( $stats['active_subscriptions'] / $stats['total_purchases'] ) * 100 : 0;
					echo esc_html( number_format( $conversion_rate, 1 ) . '%' );
					?>
				</div>
				<div class="fr-stat-change"><?php esc_html_e( 'Purchase to subscription', 'freedomreader' ); ?></div>
			</div>
		</div>
	</div>
	
	<div class="fr-dashboard-content">
		<div class="fr-dashboard-left">
			<div class="fr-dashboard-widget">
				<h2><?php esc_html_e( 'Quick Actions', 'freedomreader' ); ?></h2>
				<div class="fr-quick-actions">
					<a href="<?php echo esc_url( admin_url( 'admin.php?page=freedomreader-settings' ) ); ?>" class="button button-primary">
						<?php esc_html_e( 'Configure Settings', 'freedomreader' ); ?>
					</a>
					<a href="<?php echo esc_url( admin_url( 'post-new.php' ) ); ?>" class="button">
						<?php esc_html_e( 'Create Locked Content', 'freedomreader' ); ?>
					</a>
					<a href="<?php echo esc_url( admin_url( 'admin.php?page=freedomreader-reports' ) ); ?>" class="button">
						<?php esc_html_e( 'View Reports', 'freedomreader' ); ?>
					</a>
				</div>
			</div>
			
			<div class="fr-dashboard-widget">
				<h2><?php esc_html_e( 'Recent Activity', 'freedomreader' ); ?></h2>
				<div class="fr-recent-activity">
					<?php
					// Get recent purchases from reports class with caching.
					$reports          = FREEDO_Reports::get_instance();
					$recent_purchases = $reports->get_recent_purchases( 5 );

					if ( $recent_purchases ) :
						?>
						<ul class="fr-activity-list">
							<?php foreach ( $recent_purchases as $purchase ) : ?>
								<li class="fr-activity-item">
									<div class="fr-activity-icon">💰</div>
									<div class="fr-activity-content">
										<strong><?php echo esc_html( $purchase->user_name ? $purchase->user_name : 'Unknown User' ); ?></strong>
										<?php esc_html_e( 'purchased', 'freedomreader' ); ?>
										<em><?php echo esc_html( $purchase->post_title ? $purchase->post_title : 'Subscription' ); ?></em>
										<div class="fr-activity-meta">
											$<?php echo esc_html( number_format( $purchase->amount, 2 ) ); ?> •
											<?php echo esc_html( human_time_diff( strtotime( $purchase->created_at ), time() ) ); ?> <?php esc_html_e( 'ago', 'freedomreader' ); ?>
										</div>
									</div>
								</li>
							<?php endforeach; ?>
						</ul>
					<?php else : ?>
						<p><?php esc_html_e( 'No recent activity.', 'freedomreader' ); ?></p>
					<?php endif; ?>
				</div>
			</div>
		</div>
		
		<div class="fr-dashboard-right">
			<div class="fr-dashboard-widget">
				<h2><?php esc_html_e( 'System Status', 'freedomreader' ); ?></h2>
				<div class="fr-system-status">
					<?php
					$paypal_client_id     = get_option( 'freedomreader_paypal_client_id' );
					$paypal_client_secret = get_option( 'freedomreader_paypal_client_secret' );
					?>

					<div class="fr-status-item">
						<span class="fr-status-label"><?php esc_html_e( 'PayPal Configuration', 'freedomreader' ); ?></span>
						<span class="fr-status-value <?php echo esc_attr( ( ! empty( $paypal_client_id ) && ! empty( $paypal_client_secret ) ) ? 'fr-status-ok' : 'fr-status-error' ); ?>">
							<?php echo esc_html( ( ! empty( $paypal_client_id ) && ! empty( $paypal_client_secret ) ) ? esc_html__( 'Configured', 'freedomreader' ) : esc_html__( 'Not Configured', 'freedomreader' ) ); ?>
						</span>
					</div>
					
					<div class="fr-status-item">
						<span class="fr-status-label"><?php esc_html_e( 'Database Tables', 'freedomreader' ); ?></span>
						<span class="fr-status-value fr-status-ok"><?php esc_html_e( 'OK', 'freedomreader' ); ?></span>
					</div>

					<div class="fr-status-item">
						<span class="fr-status-label"><?php esc_html_e( 'Plugin Version', 'freedomreader' ); ?></span>
						<span class="fr-status-value"><?php echo esc_html( FREEDOMREADER_VERSION ); ?></span>
					</div>

					<div class="fr-status-item">
						<span class="fr-status-label"><?php esc_html_e( 'WordPress Version', 'freedomreader' ); ?></span>
						<span class="fr-status-value"><?php echo esc_html( get_bloginfo( 'version' ) ); ?></span>
					</div>
				</div>
			</div>
			
			<div class="fr-dashboard-widget">
				<h2><?php esc_html_e( 'Subscription Plans', 'freedomreader' ); ?></h2>
				<div class="fr-subscription-plans">
					<?php
					$subscription_plans = get_option( 'freedomreader_subscription_plans', array() );

					if ( ! empty( $subscription_plans ) ) :
						?>
						<ul class="fr-plans-list">
							<?php foreach ( $subscription_plans as $plan_id => $plan ) : ?>
								<li class="fr-plan-item">
									<strong><?php echo esc_html( $plan['name'] ); ?></strong>
									<span class="fr-plan-price">$<?php echo esc_html( number_format( $plan['price'], 2 ) ); ?>/<?php echo esc_html( $plan['interval'] ); ?></span>
								</li>
							<?php endforeach; ?>
						</ul>
					<?php else : ?>
						<p><?php esc_html_e( 'No subscription plans configured.', 'freedomreader' ); ?></p>
						<a href="<?php echo esc_url( admin_url( 'admin.php?page=freedomreader-settings' ) ); ?>" class="button">
							<?php esc_html_e( 'Add Plans', 'freedomreader' ); ?>
						</a>
					<?php endif; ?>
				</div>
			</div>
			
			<div class="fr-dashboard-widget">
				<h2><?php esc_html_e( 'Help & Support', 'freedomreader' ); ?></h2>
				<div class="fr-help-links">
					<ul>
						<li><a href="#" target="_blank"><?php esc_html_e( 'Documentation', 'freedomreader' ); ?></a></li>
						<li><a href="#" target="_blank"><?php esc_html_e( 'Video Tutorials', 'freedomreader' ); ?></a></li>
						<li><a href="#" target="_blank"><?php esc_html_e( 'Support Forum', 'freedomreader' ); ?></a></li>
						<li><a href="#" target="_blank"><?php esc_html_e( 'Contact Support', 'freedomreader' ); ?></a></li>
					</ul>
				</div>
			</div>
		</div>
	</div>
</div>




