<?php
/**
 * Content Lock Metabox View
 *
 * @package FreedomReader
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get current lock settings.
$enable_lock           = ! empty( $lock_settings );
$lock_type             = $lock_settings ? $lock_settings->lock_type : 'full';
$price                 = $lock_settings ? $lock_settings->price : '';
$teaser_length         = $lock_settings ? $lock_settings->teaser_length : 150;
$subscription_required = $lock_settings ? $lock_settings->subscription_required : 0;
?>

<div class="fr-content-lock-metabox">
	<?php wp_nonce_field( 'freedomreader_content_lock', 'freedomreader_content_lock_nonce' ); ?>



	<p>
		<label>
			<input type="checkbox" name="freedo_enable_lock" value="1" <?php checked( $enable_lock ); ?> />
			<?php esc_html_e( 'Enable content lock for this post', 'freedomreader' ); ?>
		</label>
	</p>
	
	<div class="fr-lock-settings" <?php echo $enable_lock ? '' : esc_attr( 'style="display: none;"' ); ?>>
		
		<p>
			<label for="freedo_lock_type"><?php esc_html_e( 'Lock Type', 'freedomreader' ); ?></label>
			<select name="freedo_lock_type" id="freedo_lock_type">
				<option value="full" <?php selected( $lock_type, 'full' ); ?>><?php esc_html_e( 'Full Content Lock', 'freedomreader' ); ?></option>
				<option value="partial" <?php selected( $lock_type, 'partial' ); ?>><?php esc_html_e( 'Partial Content (Teaser)', 'freedomreader' ); ?></option>
				<option value="subscription_only" <?php selected( $lock_type, 'subscription_only' ); ?>><?php esc_html_e( 'Subscription Only', 'freedomreader' ); ?></option>
			</select>
		</p>
		
		<div class="fr-price-setting" <?php echo ( 'subscription_only' === $lock_type ) ? esc_attr( 'style="display: none;"' ) : ''; ?>>
			<p>
				<label for="freedo_price"><?php esc_html_e( 'Price (for single purchase)', 'freedomreader' ); ?></label>
				<input type="number" name="freedo_price" id="freedo_price" value="<?php echo esc_attr( $price ); ?>"
						step="0.01" min="0" placeholder="9.99" />
				<span class="description"><?php esc_html_e( 'Leave empty to disable single purchase option', 'freedomreader' ); ?></span>
			</p>
		</div>
		
		<div class="fr-teaser-setting" <?php echo ( 'partial' !== $lock_type ) ? esc_attr( 'style="display: none;"' ) : ''; ?>>
			<p>
				<label for="freedo_teaser_length"><?php esc_html_e( 'Teaser Length (words)', 'freedomreader' ); ?></label>
				<input type="number" name="freedo_teaser_length" id="freedo_teaser_length" value="<?php echo esc_attr( $teaser_length ); ?>"
						min="10" max="500" />
				<span class="description"><?php esc_html_e( 'Number of words to show before the lock', 'freedomreader' ); ?></span>
			</p>
		</div>
		
		<p>
			<label>
				<input type="checkbox" name="freedo_subscription_required" value="1" <?php checked( $subscription_required ); ?> />
				<?php esc_html_e( 'Require active subscription', 'freedomreader' ); ?>
			</label>
			<span class="description"><?php esc_html_e( 'Users must have an active subscription to access this content', 'freedomreader' ); ?></span>
		</p>
		
		<div class="fr-preview-section">
			<h4><?php esc_html_e( 'Preview', 'freedomreader' ); ?></h4>
			<div class="fr-preview-content">
				<div class="fr-preview-locked">
					<div class="fr-preview-icon">🔒</div>
					<div class="fr-preview-message">
						<?php echo esc_html( get_option( 'freedomreader_teaser_message', esc_html__( 'This content is locked. Purchase to unlock.', 'freedomreader' ) ) ); ?>
					</div>
					<div class="fr-preview-button">
						<span class="fr-preview-btn"><?php esc_html_e( 'Unlock Content', 'freedomreader' ); ?></span>
					</div>
				</div>
			</div>
		</div>
		
	</div>
</div>





	<div class="fr-advanced-info">
		<h4><?php esc_html_e( 'Advanced Lock Rules', 'freedomreader' ); ?></h4>
		<p><?php esc_html_e( 'This post may also be affected by global lock rules based on categories, tags, authors, geolocation, time windows, or user roles.', 'freedomreader' ); ?></p>
		<a href="<?php echo esc_url( admin_url( 'admin.php?page=freedomreader-lock-rules' ) ); ?>" class="button button-secondary">
			<?php esc_html_e( 'Manage Global Rules', 'freedomreader' ); ?>
		</a>
	</div>
</div>
