<?php
/**
 * Bulk Operations page view
 *
 * @package FreedomReader
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get all posts with content locks.
global $wpdb;
$locks_table = $wpdb->prefix . 'freedo_content_locks';
$query       = "SELECT cl.*, p.post_title, p.post_type, p.post_status
		  FROM `{$locks_table}` cl
		  LEFT JOIN {$wpdb->posts} p ON cl.post_id = p.ID
		  ORDER BY cl.created_at DESC";

// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared -- Admin bulk operations page, no user input in query
$content_locks = $wpdb->get_results( $query, ARRAY_A );
?>

<div class="wrap">
	<h1><?php esc_html_e( 'Bulk Operations', 'freedomreader' ); ?></h1>
	
	<div class="fr-bulk-operations-grid" style="display: grid; grid-template-columns: 1fr 1fr; gap: 30px; margin-top: 20px;">
		
		<!-- Content Lock Management -->
		<div class="fr-bulk-card" style="background: #fff; padding: 25px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
			<h2 style="margin-top: 0; color: #23282d; border-bottom: 2px solid #0073aa; padding-bottom: 10px;">
				<span class="dashicons dashicons-lock" style="margin-right: 10px;"></span>
				<?php esc_html_e( 'Content Lock Management', 'freedomreader' ); ?>
			</h2>
			
			<div style="margin-bottom: 20px;">
				<h4><?php esc_html_e( 'Bulk Actions:', 'freedomreader' ); ?></h4>
				<div style="margin-bottom: 15px;">
					<button type="button" class="button button-primary" id="fr-bulk-lock-posts">
						<span class="dashicons dashicons-lock" style="margin-right: 5px;"></span>
						<?php esc_html_e( 'Lock Selected Posts', 'freedomreader' ); ?>
					</button>
					
					<button type="button" class="button button-secondary" id="fr-bulk-unlock-posts">
						<span class="dashicons dashicons-unlock" style="margin-right: 5px;"></span>
						<?php esc_html_e( 'Unlock Selected Posts', 'freedomreader' ); ?>
					</button>
				</div>
				
				<div style="margin-bottom: 15px;">
					<button type="button" class="button" id="fr-bulk-update-prices">
						<span class="dashicons dashicons-money-alt" style="margin-right: 5px;"></span>
						<?php esc_html_e( 'Update Prices', 'freedomreader' ); ?>
					</button>
					
					<button type="button" class="button" id="fr-bulk-update-keywords">
						<span class="dashicons dashicons-tag" style="margin-right: 5px;"></span>
						<?php esc_html_e( 'Update Keywords', 'freedomreader' ); ?>
					</button>
				</div>
			</div>
			
			<div style="margin-bottom: 20px;">
				<h4><?php esc_html_e( 'Quick Filters:', 'freedomreader' ); ?></h4>
				<select id="fr-post-type-filter" style="margin-right: 10px;">
					<option value=""><?php esc_html_e( 'All Post Types', 'freedomreader' ); ?></option>
					<option value="post"><?php esc_html_e( 'Posts', 'freedomreader' ); ?></option>
					<option value="page"><?php esc_html_e( 'Pages', 'freedomreader' ); ?></option>
				</select>
				
				<select id="fr-lock-status-filter">
					<option value=""><?php esc_html_e( 'All Status', 'freedomreader' ); ?></option>
					<option value="locked"><?php esc_html_e( 'Locked', 'freedomreader' ); ?></option>
					<option value="unlocked"><?php esc_html_e( 'Unlocked', 'freedomreader' ); ?></option>
				</select>
			</div>
			
			<div id="fr-bulk-result" style="margin-top: 15px;"></div>
		</div>
		
		<!-- User Management -->
		<div class="fr-bulk-card" style="background: #fff; padding: 25px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
			<h2 style="margin-top: 0; color: #23282d; border-bottom: 2px solid #0073aa; padding-bottom: 10px;">
				<span class="dashicons dashicons-admin-users" style="margin-right: 10px;"></span>
				<?php esc_html_e( 'User Management', 'freedomreader' ); ?>
			</h2>
			
			<div style="margin-bottom: 20px;">
				<h4><?php esc_html_e( 'Bulk User Actions:', 'freedomreader' ); ?></h4>
				<div style="margin-bottom: 15px;">
					<button type="button" class="button button-primary" id="fr-bulk-grant-access">
						<span class="dashicons dashicons-yes-alt" style="margin-right: 5px;"></span>
						<?php esc_html_e( 'Grant Access', 'freedomreader' ); ?>
					</button>
					
					<button type="button" class="button button-secondary" id="fr-bulk-revoke-access">
						<span class="dashicons dashicons-dismiss" style="margin-right: 5px;"></span>
						<?php esc_html_e( 'Revoke Access', 'freedomreader' ); ?>
					</button>
				</div>
				
				<div style="margin-bottom: 15px;">
					<button type="button" class="button" id="fr-bulk-extend-subscriptions">
						<span class="dashicons dashicons-calendar-alt" style="margin-right: 5px;"></span>
						<?php esc_html_e( 'Extend Subscriptions', 'freedomreader' ); ?>
					</button>
					
					<button type="button" class="button" id="fr-bulk-send-notifications">
						<span class="dashicons dashicons-email-alt" style="margin-right: 5px;"></span>
						<?php esc_html_e( 'Send Notifications', 'freedomreader' ); ?>
					</button>
				</div>
			</div>
			
			<div style="margin-bottom: 20px;">
				<h4><?php esc_html_e( 'User Filters:', 'freedomreader' ); ?></h4>
				<input type="text" id="fr-user-search" placeholder="<?php esc_attr_e( 'Search users...', 'freedomreader' ); ?>" style="width: 100%; margin-bottom: 10px;" />
				
				<select id="fr-subscription-status-filter" style="width: 100%;">
					<option value=""><?php esc_html_e( 'All Subscription Status', 'freedomreader' ); ?></option>
					<option value="active"><?php esc_html_e( 'Active Subscriptions', 'freedomreader' ); ?></option>
					<option value="expired"><?php esc_html_e( 'Expired Subscriptions', 'freedomreader' ); ?></option>
					<option value="cancelled"><?php esc_html_e( 'Cancelled Subscriptions', 'freedomreader' ); ?></option>
				</select>
			</div>
			
			<div id="fr-user-bulk-result" style="margin-top: 15px;"></div>
		</div>
	</div>
	
	<!-- Content Locks Table -->
	<div class="fr-content-locks-section" style="margin-top: 40px; background: #fff; padding: 25px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
		<h2 style="margin-top: 0; color: #23282d; border-bottom: 2px solid #0073aa; padding-bottom: 10px;">
			<span class="dashicons dashicons-list-view" style="margin-right: 10px;"></span>
			<?php esc_html_e( 'Content Locks Overview', 'freedomreader' ); ?>
		</h2>
		
		<?php if ( ! empty( $content_locks ) ) : ?>
			<div style="margin-bottom: 20px;">
				<label>
					<input type="checkbox" id="fr-select-all-locks" />
					<?php esc_html_e( 'Select All', 'freedomreader' ); ?>
				</label>
			</div>
			
			<div class="fr-locks-table-container" style="overflow-x: auto;">
				<table class="wp-list-table widefat fixed striped">
					<thead>
						<tr>
							<th style="width: 40px;"><?php esc_html_e( 'Select', 'freedomreader' ); ?></th>
							<th><?php esc_html_e( 'Post Title', 'freedomreader' ); ?></th>
							<th><?php esc_html_e( 'Type', 'freedomreader' ); ?></th>
							<th><?php esc_html_e( 'Price', 'freedomreader' ); ?></th>
							<th><?php esc_html_e( 'Keywords', 'freedomreader' ); ?></th>
							<th><?php esc_html_e( 'Status', 'freedomreader' ); ?></th>
							<th><?php esc_html_e( 'Actions', 'freedomreader' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach ( $content_locks as $lock ) : ?>
							<tr data-lock-id="<?php echo esc_attr( $lock['id'] ); ?>" data-post-type="<?php echo esc_attr( $lock['post_type'] ); ?>">
								<td>
									<input type="checkbox" class="fr-lock-checkbox" value="<?php echo esc_attr( $lock['id'] ); ?>" />
								</td>
								<td>
									<strong><?php echo esc_html( ! empty( $lock['post_title'] ) ? $lock['post_title'] : 'Untitled' ); ?></strong>
									<div style="color: #666; font-size: 12px;">ID: <?php echo esc_html( $lock['post_id'] ); ?></div>
								</td>
								<td><?php echo esc_html( ucfirst( ! empty( $lock['post_type'] ) ? $lock['post_type'] : 'Unknown' ) ); ?></td>
								<td>
									<?php if ( 'subscription' === $lock['lock_type'] ) : ?>
										<span style="color: #0073aa;"><?php esc_html_e( 'Subscription', 'freedomreader' ); ?></span>
									<?php else : ?>
										$<?php echo esc_html( number_format( (float) $lock['price'], 2 ) ); ?>
									<?php endif; ?>
								</td>
								<td>
									<?php
									$keywords = ! empty( $lock['keywords'] ) ? explode( ',', $lock['keywords'] ) : array();
									if ( ! empty( $keywords ) ) {
										echo esc_html( implode( ', ', array_slice( $keywords, 0, 3 ) ) );
										if ( count( $keywords ) > 3 ) {
											echo esc_html( ' (+' . ( count( $keywords ) - 3 ) . ' more)' );
										}
									} else {
										echo '<span style="color: #999;">' . esc_html__( 'No keywords', 'freedomreader' ) . '</span>';
									}
									?>
								</td>
								<td>
									<?php if ( 'publish' === $lock['post_status'] ) : ?>
										<span style="color: #46b450;"><?php esc_html_e( 'Active', 'freedomreader' ); ?></span>
									<?php else : ?>
										<span style="color: #dc3232;"><?php esc_html_e( 'Inactive', 'freedomreader' ); ?></span>
									<?php endif; ?>
								</td>
								<td>
									<button type="button" class="button button-small fr-edit-lock" data-lock-id="<?php echo esc_attr( $lock['id'] ); ?>">
										<?php esc_html_e( 'Edit', 'freedomreader' ); ?>
									</button>
									<button type="button" class="button button-small button-link-delete fr-delete-lock" data-lock-id="<?php echo esc_attr( $lock['id'] ); ?>">
										<?php esc_html_e( 'Delete', 'freedomreader' ); ?>
									</button>
								</td>
							</tr>
						<?php endforeach; ?>
					</tbody>
				</table>
			</div>
		<?php else : ?>
			<div class="notice notice-info inline">
				<p><?php esc_html_e( 'No content locks found. Create some locked content to use bulk operations.', 'freedomreader' ); ?></p>
			</div>
		<?php endif; ?>
	</div>
</div>

<!-- Bulk Operation Modals -->
<div id="fr-bulk-modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7); z-index: 9999;">
	<div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 30px; border-radius: 8px; max-width: 500px; width: 90%;">
		<h3 id="fr-bulk-modal-title" style="margin-top: 0;"></h3>
		<div id="fr-bulk-modal-content"></div>
		
		<div style="text-align: right; margin-top: 20px;">
			<button type="button" class="button" id="fr-bulk-modal-cancel"><?php esc_html_e( 'Cancel', 'freedomreader' ); ?></button>
			<button type="button" class="button button-primary" id="fr-bulk-modal-confirm"><?php esc_html_e( 'Apply', 'freedomreader' ); ?></button>
		</div>
	</div>
</div>

<?php
// Enqueue inline styles for bulk operations.
$bulk_operations_css = '
.fr-bulk-card:hover {
	transform: translateY(-2px);
	transition: transform 0.2s ease;
}

.fr-locks-table-container {
	max-height: 600px;
	overflow-y: auto;
}

@media (max-width: 768px) {
	.fr-bulk-operations-grid {
		grid-template-columns: 1fr !important;
	}
}';
wp_add_inline_style( 'freedomreader-admin', $bulk_operations_css );
?>
