# FreedomReader Documentation Screenshots

**Note: Screenshots have been moved to `/assets/images/` folder.**

This folder was originally intended for screenshots but they are now located in:
`wp-content/plugins/freedomreader/assets/images/`

## Current Screenshot Status ✅

All essential screenshots have been added to the `/assets/images/` folder:

### ✅ PayPal Setup Screenshots
- ✅ **`paypal-developer-dashboard.png`** - PayPal Developer Dashboard showing where to create apps
- ✅ **`paypal-app-credentials.png`** - PayPal app page showing Client ID and Client Secret
- ✅ **`plugin-settings-paypal.png`** - FreedomReader PayPal settings page

### ✅ Plugin Interface Screenshots
- ✅ **`content-lock-metabox.png`** - Content lock metabox in post editor
- ✅ **`subscription-plans-settings.png`** - Subscription plans configuration page
- ✅ **`lock-rules-page.png`** - Lock rules management interface
- ✅ **`dashboard-overview.png`** - Main FreedomReader dashboard
- ✅ **`reports-page.png`** - Reports and analytics page

### ✅ Frontend Screenshots
- ✅ **`locked-content-frontend.png`** - How locked content appears to users
- ✅ **`purchase-button-frontend.png`** - Purchase/subscribe buttons on frontend

## 🎯 All Essential Screenshots Complete!

All 10 essential screenshots have been successfully added to the documentation.

## Screenshot Guidelines

### Technical Requirements
- **Format**: PNG preferred (better quality for UI screenshots)
- **Resolution**: Minimum 1200px wide for clarity
- **Quality**: High resolution, clear text
- **Browser**: Use Chrome or Firefox for consistent UI rendering

### Content Guidelines
- **Clean Interface**: Hide personal information, use demo data
- **Highlight Key Areas**: Use arrows or highlights if needed
- **Consistent Styling**: Use the same WordPress theme/admin styling
- **Real Data**: Use realistic but fake data for demonstrations

### Naming Convention
- Use exact filenames as listed above
- All lowercase with hyphens
- PNG format (.png extension)

## Usage in Documentation

These screenshots are automatically loaded in the documentation page at:
`/wp-admin/admin.php?page=freedomreader-documentation`

The images are referenced using:
```php
FREEDOMREADER_PLUGIN_URL . 'admin/assets/screenshots/filename.png'
```

## Missing Screenshots

If a screenshot file is missing, the documentation will show a broken image placeholder. This is intentional to help identify which screenshots still need to be added.

## Adding Screenshots

1. Take screenshots according to the guidelines above
2. Save them with the exact filenames listed
3. Place them in this directory
4. Refresh the documentation page to see them appear

The documentation page will automatically display any screenshots that are present and show placeholders for missing ones.
