/**
 * FreedomReader Subscriptions Admin JavaScript
 *
 * @package FreedomReader
 */

(function ($) {
	'use strict';

	$( document ).ready(
		function () {
			// View PayPal subscription.
			$( '.fr-view-paypal-subscription' ).click(
				function (e) {
					e.preventDefault();
					var subscriptionId = $( this ).data( 'subscription-id' );

					// Open PayPal subscription management in new window.
					var paypalMode = freedomreader_subscriptions.paypal_mode;
					var paypalUrl  = paypalMode === 'live'
					? 'https://www.paypal.com/billing/subscriptions/' + subscriptionId
					: 'https://www.sandbox.paypal.com/billing/subscriptions/' + subscriptionId;

					window.open( paypalUrl, '_blank' );
				}
			);

			// Cancel subscription.
			$( '.fr-cancel-subscription' ).click(
				function (e) {
					e.preventDefault();

					if ( ! confirm( freedomreader_subscriptions.confirm_cancel )) {
						return;
					}

					var subscriptionId = $( this ).data( 'subscription-id' );
					var $button        = $( this );

					$button.text( freedomreader_subscriptions.processing_text ).prop( 'disabled', true );

					$.ajax(
						{
							url: ajaxurl,
							type: 'POST',
							data: {
								action: 'freedomreader_cancel_subscription',
								nonce: freedomreader_subscriptions.nonce,
								subscription_id: subscriptionId
							},
							success: function (response) {
								if (response.success) {
									alert( freedomreader_subscriptions.cancel_success );
									location.reload();
								} else {
									alert( freedomreader_subscriptions.cancel_failed + response.data.message );
									$button.text( freedomreader_subscriptions.cancel_text ).prop( 'disabled', false );
								}
							},
							error: function () {
								alert( freedomreader_subscriptions.error_occurred );
								$button.text( freedomreader_subscriptions.cancel_text ).prop( 'disabled', false );
							}
						}
					);
				}
			);
		}
	);

})( jQuery );
