/**
 * FreedomReader Settings Page JavaScript
 */

jQuery( document ).ready(
	function ($) {
		// Add keyword row
		$( '#fr-add-keyword' ).click(
			function () {
				var newRow = '<div class="fr-keyword-row">' +
				'<input type="text" name="auto_link_keywords[]" placeholder="' + freedomreader_settings.keyword_placeholder + '" class="regular-text" />' +
				'<input type="number" name="auto_link_prices[]" placeholder="' + freedomreader_settings.price_placeholder + '" class="small-text" min="0" step="0.01" />' +
				'<button type="button" class="button fr-remove-keyword">' + freedomreader_settings.remove_text + '</button>' +
				'</div>';
				$( '#fr-keywords-container' ).append( newRow );
			}
		);

		// Remove keyword row
		$( document ).on(
			'click',
			'.fr-remove-keyword',
			function () {
				$( this ).closest( '.fr-keyword-row' ).remove();
			}
		);

		// Performance check
		$( '#fr-performance-check' ).click(
			function () {
				var $button = $( this );
				$button.prop( 'disabled', true ).html( '<span class="dashicons dashicons-update-alt" style="margin-right: 5px; animation: spin 1s linear infinite;"></span>' + freedomreader_settings.checking_text );

				$.ajax(
					{
						url: ajaxurl,
						type: 'POST',
						data: {
							action: 'freedomreader_performance_check',
							nonce: freedomreader_settings.nonce
						},
						success: function (response) {
							if (response.success) {
								alert( freedomreader_settings.performance_good );
							} else {
								alert( freedomreader_settings.performance_issues + ': ' + response.data.message );
							}
						},
						error: function () {
							alert( freedomreader_settings.error_occurred );
						},
						complete: function () {
							$button.prop( 'disabled', false ).html( '<span class="dashicons dashicons-performance" style="margin-right: 5px;"></span>' + freedomreader_settings.performance_check_text );
						}
					}
				);
			}
		);

		// Tab switching
		$( '.nav-tab' ).click(
			function (e) {
				e.preventDefault();

				// Remove active class from all tabs and content
				$( '.nav-tab' ).removeClass( 'nav-tab-active' );
				$( '.fr-tab-content' ).hide();

				// Add active class to clicked tab
				$( this ).addClass( 'nav-tab-active' );

				// Show corresponding content
				var target = $( this ).data( 'tab' );
				$( '#' + target ).show();

				// Update URL hash
				window.location.hash = target;
			}
		);

		// Show active tab on page load
		var hash = window.location.hash.substring( 1 );
		if (hash && $( '#' + hash ).length) {
			$( '.nav-tab[data-tab="' + hash + '"]' ).click();
		} else {
			$( '.nav-tab:first' ).click();
		}

		// Add subscription plan
		$( '#fr-add-plan' ).click(
			function () {
				var planCount = $( '.fr-plan-row' ).length;
				var newPlan   = '<div class="fr-plan-row">' +
				'<input type="text" name="subscription_plans[plan_' + planCount + '][name]" placeholder="' + freedomreader_settings.plan_name_placeholder + '" class="regular-text" />' +
				'<input type="number" name="subscription_plans[plan_' + planCount + '][price]" placeholder="' + freedomreader_settings.price_placeholder + '" class="small-text" min="0" step="0.01" />' +
				'<select name="subscription_plans[plan_' + planCount + '][interval]">' +
					'<option value="month">' + freedomreader_settings.monthly_text + '</option>' +
					'<option value="year">' + freedomreader_settings.yearly_text + '</option>' +
				'</select>' +
				'<button type="button" class="button fr-remove-plan">' + freedomreader_settings.remove_text + '</button>' +
				'</div>';
				$( '#fr-plans-container' ).append( newPlan );
			}
		);

		// Remove subscription plan
		$( document ).on(
			'click',
			'.fr-remove-plan',
			function () {
				if (confirm( freedomreader_settings.confirm_remove_plan )) {
					$( this ).closest( '.fr-plan-row' ).remove();
				}
			}
		);

		// PayPal credential validation
		$( '#validate-paypal-credentials' ).click(
			function () {
				var $button      = $( this );
				var originalText = $button.text();

				$button.prop( 'disabled', true ).text( freedomreader_settings.validating_text );

				$.ajax(
					{
						url: ajaxurl,
						type: 'POST',
						data: {
							action: 'freedomreader_validate_paypal_credentials',
							nonce: freedomreader_settings.nonce,
							client_id: $( '#freedomreader_paypal_client_id' ).val(),
							client_secret: $( '#freedomreader_paypal_client_secret' ).val(),
							mode: $( '#freedomreader_paypal_mode' ).val()
						},
						success: function (response) {
							if (response.success) {
								alert( freedomreader_settings.credentials_valid );
							} else {
								alert( freedomreader_settings.error_text + ': ' + response.data.message );
							}
						},
						error: function () {
							alert( freedomreader_settings.validation_error );
						},
						complete: function () {
							$button.prop( 'disabled', false ).text( originalText );
						}
					}
				);
			}
		);
	}
);
