/**
 * FreedomReader Purchases Admin JavaScript
 *
 * @package FreedomReader
 */

(function ($) {
	'use strict';

	$( document ).ready(
		function () {
			// View transaction details.
			$( '.fr-view-transaction' ).click(
				function (e) {
					e.preventDefault();
					var transactionId = $( this ).data( 'transaction-id' );

					// Open PayPal transaction in new window.
					var paypalMode = freedomreader_purchases.paypal_mode;
					var paypalUrl  = paypalMode === 'live'
					? 'https://www.paypal.com/activity/payment/' + transactionId
					: 'https://www.sandbox.paypal.com/activity/payment/' + transactionId;

					window.open( paypalUrl, '_blank' );
				}
			);

			// Refund purchase.
			$( '.fr-refund-purchase' ).click(
				function (e) {
					e.preventDefault();

					if ( ! confirm( freedomreader_purchases.confirm_refund )) {
						return;
					}

					var purchaseId = $( this ).data( 'purchase-id' );
					var $button    = $( this );

					$button.text( freedomreader_purchases.processing_text ).prop( 'disabled', true );

					$.ajax(
						{
							url: ajaxurl,
							type: 'POST',
							data: {
								action: 'freedomreader_refund_purchase',
								nonce: freedomreader_purchases.nonce,
								purchase_id: purchaseId
							},
							success: function (response) {
								if (response.success) {
									alert( freedomreader_purchases.refund_success );
									location.reload();
								} else {
									alert( freedomreader_purchases.refund_failed + response.data.message );
									$button.text( freedomreader_purchases.refund_text ).prop( 'disabled', false );
								}
							},
							error: function () {
								alert( freedomreader_purchases.error_occurred );
								$button.text( freedomreader_purchases.refund_text ).prop( 'disabled', false );
							}
						}
					);
				}
			);
		}
	);

})( jQuery );
