/**
 * FreedomReader Content Lock Metabox JavaScript
 */

jQuery( document ).ready(
	function ($) {
		// Toggle lock settings visibility
		$( 'input[name="fr_enable_lock"]' ).change(
			function () {
				if ($( this ).is( ':checked' )) {
					$( '.fr-lock-settings' ).slideDown();
				} else {
					$( '.fr-lock-settings' ).slideUp();
				}
			}
		);

		// Toggle price setting based on lock type
		$( '#fr_lock_type' ).change(
			function () {
				var lockType = $( this ).val();
				if (lockType === 'subscription_only') {
					$( '.fr-price-setting' ).hide();
				} else {
					$( '.fr-price-setting' ).show();
				}
				updatePreviewMessage();
			}
		);

		// Update preview when settings change
		$( '#fr_price, #fr_teaser_length' ).on( 'input', updatePreviewMessage );
		$( 'input[name="fr_subscription_required"]' ).change( updatePreviewMessage );

		// Initialize preview on page load
		updatePreviewMessage();

		// Initialize visibility based on current state
		if ($( 'input[name="fr_enable_lock"]' ).is( ':checked' )) {
			$( '.fr-lock-settings' ).show();
		} else {
			$( '.fr-lock-settings' ).hide();
		}

		// Initialize price setting visibility
		$( '#fr_lock_type' ).trigger( 'change' );

		function updatePreviewMessage() {
			var lockType             = $( '#fr_lock_type' ).val();
			var price                = $( '#fr_price' ).val() || '0.00';
			var teaserLength         = $( '#fr_teaser_length' ).val() || '150';
			var subscriptionRequired = $( 'input[name="fr_subscription_required"]' ).is( ':checked' );

			var message = '';

			if (lockType === 'full') {
				message = freedomreader_metabox.full_lock_preview;
			} else if (lockType === 'teaser') {
				message = freedomreader_metabox.teaser_lock_preview.replace( '%d', teaserLength );
			} else if (lockType === 'subscription_only') {
				message = freedomreader_metabox.subscription_only_preview;
			}

			if (price > 0 && lockType !== 'subscription_only') {
				message += ' ' + freedomreader_metabox.price_preview.replace( '%s', price );
			}

			if (subscriptionRequired && lockType !== 'subscription_only') {
				message += ' ' + freedomreader_metabox.subscription_required_preview;
			}

			$( '.fr-preview-message' ).text( message );
		}
	}
);
